/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifdef WIN32
#include <windows.h>
#endif

#include <QApplication>

#include "player.h"
#include "settings.h"
#include "localconnector.h"
#include "webserviceconnector.h"


int main( int argc, char *argv[] )
{
    // Create Windows mutex, so Installer can detect running instances
    #ifdef WIN32
    QString id( "Lastfmradio-F396D8C8-9595-4f48-A319-48DCB827AD8F" );
    ::CreateMutexA( NULL, FALSE, id.toAscii() );
    #endif

    QApplication app( argc, argv );
    #ifdef Q_WS_X11
    QApplication::setStyle( "plastique" );
    #endif

    Settings *settings = new Settings();
    QString cli;

    for ( int i = 1; i < argc; i ++ )
    {
        if ( QString( argv[i] ).contains( "--debug" ) )
            settings->setDebug( true );

        if ( QString( argv[i] ).contains( "--silent" ) )
        {
            WebserviceConnector *ws = new WebserviceConnector();
            ws->handshake( Settings::instance()->username(), Settings::instance()->password() );

            delete ws;
            delete settings;
            return 0;
        }

        if ( QString( argv[i] ).contains( "lastfm://" ) )
            cli = argv[i];
    }

    // check for another instance running
    #ifndef Q_WS_MAC
    if ( !cli.isEmpty() && cli.length() > 9 )
        cli = cli.remove( 0, 9 );
    #endif

    if ( Player::transmitCli( cli ) )
        qDebug() << "Data passed to running instance, shutting down";
    else
    {
        LocalConnector *localConnector = new LocalConnector();

        Player *window = new Player( 0, cli );
        window->setWindowTitle( "Last.fm Radio" );
        window->show();

        return app.exec();
        delete localConnector;
        delete window;
    }

    delete settings;
    return 0;
}
