/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGui>

#ifdef WIN32
#include <windows.h>
#endif

#include "settings.h"
#include "settingsdialog.h"
#include "rtaudio/RtAudio.h"


SettingsDialog::SettingsDialog( QWidget *parent )
    : QDialog( parent )
{
    ui.setupUi( this );
    ui.applyButton->setEnabled( false );

    ui_general.setupUi( ui.pageGeneral );
    ui_connection.setupUi( ui.pageConnection );
    ui_system.setupUi( ui.pageSystem );
    pageChanged( 0 );

    ui.pageList->item( 0 )->setIcon( QPixmap( QApplication::applicationDirPath() + "/data/icon.png" ).scaled( 48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation ) );
    ui.pageList->item( 1 )->setIcon( QPixmap( QApplication::applicationDirPath() + "/data/icon.png" ).scaled( 48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation ) );
    ui.pageList->item( 2 )->setIcon( QPixmap( QApplication::applicationDirPath() + "/data/icon.png" ).scaled( 48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation ) );

/*     connect( ui.signUpButton, SIGNAL( clicked() ), this, SLOT( signUp() ) );

    #ifndef Q_WS_X11
        ui.browserLabel->setVisible( false );
        ui.browserEdit->setVisible( false );
    #endif */

    try
    {
        RtAudio *audio = new RtAudio();

        for ( int i = 1; i < audio->getDeviceCount(); i++ )
        {
            RtAudioDeviceInfo info;
            info = audio->getDeviceInfo( i );
            QString name = QString::fromStdString( info.name );

            #ifdef WIN32
            if ( i > 1 )
            #endif
                ui_system.cardBox->addItem( name );
        }

        delete audio;
    }
    catch ( RtError &error )
    {
        error.printMessage();
    }

    if ( ui_system.cardBox->count() == 0 )
        ui_system.cardBox->addItem( "Default Card" );

    #ifdef Q_WS_X11
        ui_system.systemBox->addItem( "ALSA" );
        ui_system.systemBox->addItem( "OSS" );
    #endif
    #ifdef Q_WS_MAC
        ui_system.systemBox->addItem( "CoreAudio" );
    #endif
    #ifdef WIN32
        ui_system.systemBox->addItem( "DirectSound" );
    #endif

    ui_system.systemBox->addItem( "External Mediaplayer" );

    ui_general.usernameEdit->setText( Settings::instance()->username() );
    if ( !Settings::instance()->password().isEmpty() )
        ui_general.passwordEdit->setText( "********" );
    ui_general.resumeCheckBox->setChecked( Settings::instance()->resumePlayback() );

    ui_connection.proxyBox->setChecked( Settings::instance()->proxyUsage() );
    ui_connection.proxyHostEdit->setText( Settings::instance()->proxyHost() );
    ui_connection.proxyPortEdit->setText( QString().setNum( Settings::instance()->proxyPort() ) );
    ui_connection.proxyUsernameEdit->setText( Settings::instance()->proxyUsername() );
    ui_connection.proxyPasswordEdit->setText( Settings::instance()->proxyPassword() );

    ui_system.systemBox->setCurrentIndex( Settings::instance()->soundSystem() );
    ui_system.cardBox->setCurrentIndex( Settings::instance()->soundCard() );
//     ui.browserEdit->setText( browser() );

    originalUsername = Settings::instance()->username();
    originalPassword = Settings::instance()->password();
    originalProxyHost = Settings::instance()->proxyHost();
    originalProxyUsername = Settings::instance()->proxyUsername();
    originalProxyPassword = Settings::instance()->proxyPassword();
    originalProxyPort = Settings::instance()->proxyPort();
    originalProxyUsage = Settings::instance()->proxyUsage();
    originalSoundCard = Settings::instance()->soundCard();
    originalSoundSystem = Settings::instance()->soundSystem();

    connect( ui.pageList, SIGNAL( currentRowChanged( int ) ), this, SLOT( pageChanged( int ) ) );
    connect( ui.okButton, SIGNAL( clicked() ), this, SLOT( okPressed() ) );
    connect( ui.applyButton, SIGNAL( clicked() ), this, SLOT( applyPressed() ) );

    connect( ui_general.usernameEdit, SIGNAL( textChanged( QString ) ), this, SLOT( configChanged() ) );
    connect( ui_general.passwordEdit, SIGNAL( textChanged( QString ) ), this, SLOT( configChanged() ) );
    connect( ui_general.resumeCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( configChanged() ) );
    connect( ui_connection.proxyBox, SIGNAL( toggled( bool ) ), this, SLOT( configChanged() ) );
    connect( ui_connection.proxyHostEdit, SIGNAL( textChanged( QString ) ), this, SLOT( configChanged() ) );
    connect( ui_connection.proxyPortEdit, SIGNAL( textChanged( QString ) ), this, SLOT( configChanged() ) );
    connect( ui_connection.proxyUsernameEdit, SIGNAL( textChanged( QString ) ), this, SLOT( configChanged() ) );
    connect( ui_connection.proxyPasswordEdit, SIGNAL( textChanged( QString ) ), this, SLOT( configChanged() ) );
    connect( ui_system.systemBox, SIGNAL( currentIndexChanged( int ) ), this, SLOT( configChanged() ) );
    connect( ui_system.cardBox, SIGNAL( currentIndexChanged( int ) ), this, SLOT( configChanged() ) );
}


void
SettingsDialog::pageChanged( int currentRow )
{
    switch ( currentRow )
    {
        case 0:
            ui.pageConnection->setVisible( false );
            ui.pageSystem->setVisible( false );
            ui.pageGeneral->setVisible( true );
            break;

        case 1:
            ui.pageGeneral->setVisible( false );
            ui.pageSystem->setVisible( false );
            ui.pageConnection->setVisible( true );
            break;

        case 2:
            ui.pageConnection->setVisible( false );
            ui.pageGeneral->setVisible( false );
            ui.pageSystem->setVisible( true );
            break;
    }
}


void
SettingsDialog::applyPressed()
{
    Settings::instance()->setUsername( ui_general.usernameEdit->text() );
    Settings::instance()->setPassword( ui_general.passwordEdit->text() );
    Settings::instance()->setResumePlayback( ui_general.resumeCheckBox->isChecked() );

    Settings::instance()->setProxyUsername( ui_connection.proxyUsernameEdit->text() );
    Settings::instance()->setProxyPassword( ui_connection.proxyPasswordEdit->text() );
    Settings::instance()->setProxyHost( ui_connection.proxyHostEdit->text() );
    Settings::instance()->setProxyPort( ui_connection.proxyPortEdit->text().toInt() );
    Settings::instance()->setProxyUsage( ui_connection.proxyBox->isChecked() );

    Settings::instance()->setSoundCard( ui_system.cardBox->currentIndex() );
    Settings::instance()->setSoundSystem( ui_system.systemBox->currentIndex() );
//     Settings::instance()->setBrowser( ui.browserEdit->text() );

    Settings::instance()->save();
    ui.applyButton->setEnabled( false );
}


void
SettingsDialog::okPressed()
{
    QString password = ui_general.passwordEdit->text();

    if ( password.isEmpty() || password == "********" )
        password = originalPassword;
    else
        password = Settings::instance()->MD5Digest( ui_general.passwordEdit->text().toAscii() );

    bool reconnect = ( ui_general.usernameEdit->text() != originalUsername || password != originalPassword ||
                       ui_connection.proxyHostEdit->text() != originalProxyHost || ui_connection.proxyUsernameEdit->text() != originalProxyUsername ||
                       ui_connection.proxyPasswordEdit->text() != originalProxyPassword || ui_connection.proxyPortEdit->text().toInt() != originalProxyPort ||
                       ui_connection.proxyBox->isChecked() != originalProxyUsage );

    bool reaudio = ( ui_system.cardBox->currentIndex() != originalSoundCard || ui_system.systemBox->currentIndex() != originalSoundSystem );

    applyPressed();
    originalUsername = Settings::instance()->username();
    originalPassword = Settings::instance()->password();
    originalProxyHost = Settings::instance()->proxyHost();
    originalProxyUsername = Settings::instance()->proxyUsername();
    originalProxyPassword = Settings::instance()->proxyPassword();
    originalProxyPort = Settings::instance()->proxyPort();
    originalProxyUsage = Settings::instance()->proxyUsage();

    Settings::instance()->save( reconnect, reaudio );
}


void
SettingsDialog::signUp()
{
    Settings::instance()->startBrowser( "http://www.last.fm/signup.php" );
}


void
SettingsDialog::configChanged()
{
    ui.applyButton->setEnabled( true );
}
