#ifndef REGEXEXCEPTION_H
#define REGEXEXCEPTION_H

#include <Exception.h>
#include <sys/types.h>
#include <regex.h>

////// RegexException

class RegexException : public SystemException
{
protected:
	std::string _message;

public:
	RegexException(const regex_t& re, int code, const std::string& context)
		throw ();
	~RegexException() throw () {}

	virtual const char* type() const throw () { return "RegexException"; }
	virtual std::string desc() const throw () { return _message + " " + _context; }
};

class Regex
{
protected:
	regex_t re;

public:
	Regex(const char* expr, int flags = 0) throw(RegexException);
	~Regex() { regfree(&re); }

	bool match(const char* str, int flags = 0) throw(RegexException);
	bool match(const char* str, int nmatch, regmatch_t pmatch[], int flags = 0) throw(RegexException);
};

// vim:set ts=4 sw=4:
#endif
