/***************************************************************************
                          bricks.c  -  description
                             -------------------
    begin                : Thu Sep 6 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "list.h"
#include "config.h"
#include "levels.h"
#include "player.h"
#include "shrapnells.h"
#include "bricks.h"
#ifdef SOUND
#include "audio.h"
#endif

extern Sdl sdl;
extern SDL_Surface *offscreen; /* offscreen with bricks, background, frame */
extern SDL_Surface *bkgnd; /* background picture (includes frame) */
Brick bricks[MAP_WIDTH][MAP_HEIGHT];
int brick_count; /* how many bricks out there? used to determine when level cleared */
extern SDL_Surface *brick_pic; /* brick graphics in a horizontal order */
extern Player *player; /* ad new brick score to this player */
enum { EXTRA_STACK_LIMIT = 20 };
typedef struct { int type; int px, py; } Stack_Extra;
Stack_Extra extra_stack[EXTRA_STACK_LIMIT]; /* stack'ed extras released in brick_hit */
int extra_count;
extern int shadow_size;
extern SDL_Surface *brick_shadow; /* shadow mask */
extern Config config;
extern int shine_x, shine_y, shine_recreate;
extern int active[EX_NUMBER];
#ifdef SOUND
extern Sound_Chunk *wav_boom;
#endif
List *exp_bricks = 0; /* list of exploding bricks */
List *heal_bricks = 0; /* list of regenerating bricks */
int grow = 0;
int grow_mask[MAP_WIDTH][MAP_HEIGHT]; /* if grow is set this contains the indices of the 
                                         growing bricks in brick_conv_table. anything out of 0-BRICK_COUNT 
                                         means no brick */

/* extras conversion table */
Extra_Conv extra_conv_table[EX_NUMBER] = {
    { EX_SCORE200,   '0' },
    { EX_SCORE500,   '1' },
    { EX_SCORE1000,  '2' },
    { EX_SCORE2000,  '3' },
    { EX_SCORE5000,  '4' },
    { EX_SCORE10000, '5' },
    { EX_GOLDSHOWER, 'g' },
    { EX_LENGTHEN,   '+' },
    { EX_SHORTEN,    '-' },
    { EX_LIFE,       'l' },
    { EX_SLIME,      's' },
    { EX_METAL,      'm' },
    { EX_BALL,       'b' },
    { EX_WALL,       'w' },
    { EX_FROZEN,     'f' },
    { EX_WEAPON,     'p' },
    { EX_RANDOM,     '?' },
    { EX_FAST,       '>' },
    { EX_SLOW,       '<' },
    { EX_JOKER,      'j' },
	{ EX_DARKNESS,   'd' },
	{ EX_CHAOS,      'c' },
	{ EX_GHOST_PADDLE, '~' },
    { EX_DISABLE,      '!' },
    { EX_TIME_ADD,     '&' },
/*    
    { EX_SPIN_RIGHT,   ')' },
    { EX_SPIN_LEFT,    '(' },
*/    
    { EX_EXPL_BALL,    '*' },
    { EX_BONUS_MAGNET, '}' },
    { EX_MALUS_MAGNET, '{' },
    { EX_WEAK_BALL,    'W' }
};
/* brick conversion table: brick id, char */
Brick_Conv brick_conv_table[BRICK_COUNT] = {
    { 'E', MAP_WALL,        0, -1, 0 },
	{ '#', MAP_BRICK,       1, -1, 1000 },
    { '@', MAP_BRICK_CHAOS, 2, -1, 1000 },
	{ 'a', MAP_BRICK,       3,  1, BRICK_SCORE * 1 },
	{ 'b', MAP_BRICK,       4,  2, BRICK_SCORE * 2 },
	{ 'c', MAP_BRICK,       5,  3, BRICK_SCORE * 3 },
	{ 'v', MAP_BRICK,       6,  4, BRICK_SCORE * 4 },
    { 'x', MAP_BRICK_HEAL,  7,  1, BRICK_SCORE * 2},
    { 'y', MAP_BRICK_HEAL,  8,  2, BRICK_SCORE * 4},
    { 'z', MAP_BRICK_HEAL,  9,  3, BRICK_SCORE * 6},
	{ 'd', MAP_BRICK,      10,  1, BRICK_SCORE },
	{ 'e', MAP_BRICK,      11,  1, BRICK_SCORE },
	{ 'f', MAP_BRICK,      12,  1, BRICK_SCORE },
	{ 'g', MAP_BRICK,      13,  1, BRICK_SCORE },
	{ 'h', MAP_BRICK,      14,  1, BRICK_SCORE },
	{ 'i', MAP_BRICK,      15,  1, BRICK_SCORE },
	{ 'j', MAP_BRICK,      16,  1, BRICK_SCORE },
	{ 'k', MAP_BRICK,      17,  1, BRICK_SCORE },
	{ '*', MAP_BRICK_EXP,  18,  1, BRICK_SCORE * 2 },
	{ '!', MAP_BRICK_GROW, GROW_BRICK_ID,  1, BRICK_SCORE * 2 },
};

/*
====================================================================
Locals
====================================================================
*/

/*
====================================================================
Remove brick from offscreen and screen.
Create shrapnells by type and impulse.
====================================================================
*/
void brick_remove( int mx, int my, int type, Vector imp )
{
    int px, py, w, h, i, j, shadow;
    int no_anim = 0; /* explosive bricks have their explosion as animation */
    
	/* if explosive set exp_time of surrounding bricks */
	if ( bricks[mx][my].type == MAP_BRICK_EXP ) {
        no_anim = 1;
		for ( i = mx - 1; i <= mx + 1; i++ )
			for ( j = my - 1; j <= my + 1; j++ )
				if ( i != mx || j != my ) 
					if ( bricks[i][j].type != MAP_EMPTY && bricks[i][j].dur > 0 )
						if ( bricks[i][j].exp_time == -1 ) { 
							bricks[i][j].exp_time = BRICK_EXP_TIME;
							bricks[i][j].mx = i; bricks[i][j].my = j;
							list_add( exp_bricks, &bricks[i][j] );
                        }	
        /* add explosion animation */
        exp_create( mx * BRICK_WIDTH + ( BRICK_WIDTH >> 1 ), my * BRICK_HEIGHT + ( BRICK_HEIGHT >> 1 ) );
#ifdef SOUND
        sound_play( wav_boom );
#endif
	}
	if ( bricks[mx][my].type == MAP_BRICK_GROW ) {
        if ( !grow ) memset( grow_mask, 0xff, sizeof( grow_mask ) );
        grow = 1;
        for ( i = mx - 1; i <= mx + 1; i++ )
            for ( j = my - 1; j <= my + 1; j++ )
                if ( bricks[i][j].type == MAP_EMPTY ) 
                    grow_mask[i][j] = RANDOM( BRICK_GROW_FIRST, BRICK_GROW_LAST );
    }
    
    /* decrease brick count if no indestructible brick was destroyed */
    if ( bricks[mx][my].dur != -1 ) --brick_count;
	/* remove brick from map */
    bricks[mx][my].id = -1;
    bricks[mx][my].dur = -1;
    bricks[mx][my].exp_time = -1;
    bricks[mx][my].heal_time = -1;
    bricks[mx][my].type = MAP_EMPTY;
    /* mark as removed in players brick map */
    player->bricks[mx][my] = 0; 
    player->grown_bricks[mx][my] = 0;

    /* get screen position */
    px = mx * BRICK_WIDTH;
    py = my * BRICK_HEIGHT;
    
    /* release extra if one exists */
    if ( bricks[mx][my].extra != EX_NONE )
        bricks_push_extra( bricks[mx][my].extra, px, py );
    else
        if ( active[EX_GOLDSHOWER] )
            bricks_push_extra( EX_SCORE1000, px, py );
    bricks[mx][my].extra = EX_NONE;
    /* get score */
    player->score += bricks[mx][my].score;

	/* in case of darkness no (graphical) remove nescessary */
	if ( active[EX_DARKNESS] ) {
#ifdef SOUND
    sound_play( wav_boom );
#endif
		return;
	}		

    /* add shrapnells */
    if ( !no_anim )
        shrapnells_create( px, py, BRICK_WIDTH, BRICK_HEIGHT, type, imp );
    /* recreate shine if needed */
    if (px == shine_x && py == shine_y) shine_recreate = 1;
    /* clear offscreen */
    w = BRICK_WIDTH; h = BRICK_HEIGHT;
    if ( config.shadow ) {
        w += shadow_size; h += shadow_size;
        if ( px + w > sdl.screen->w - BRICK_WIDTH ) w = sdl.screen->w - BRICK_WIDTH - px;
        set_surf_clip( offscreen, px, py, w, h );
    }
    DEST(offscreen, px, py, w, h );
    SOURCE(bkgnd, px, py);
    blit_surf();
    /* if shadow redraw close bricks */
    if ( config.shadow ) {
        for ( i = mx - 1; i <= mx + 1; i++ )
            for ( j = my - 1; j <= my + 1; j++ ) {
                if ( i > 0 && j > 0 && i < MAP_WIDTH - 1 ) {
                    if ( bricks[i][j].type != MAP_EMPTY ) {
                        if ( i <= mx && j <= my ) shadow = 1; else shadow = 0;
                        brick_draw( offscreen, i, j, shadow );
                    }
                }
                /* redraw shadow of frame */
                if ( ( i == 0 || j == 0 ) && i < MAP_WIDTH - 1 )
                    brick_draw( offscreen, i, j, 1 );
            }
        set_surf_clip( offscreen, 0, 0, 0, 0 );
    }
    /* update screen */
    DEST(sdl.screen, px, py, w, h );
    SOURCE(offscreen, px, py);
    blit_surf();
    add_refresh_rect(px, py, w, h );
#ifdef SOUND
    sound_play( wav_boom );
#endif
}

/*
====================================================================
Publics
====================================================================
*/

/*
====================================================================
Load picture containing brick graphics
====================================================================
*/
void bricks_load()
{
	exp_bricks = list_create( LIST_NO_AUTO_DELETE, NO_CALLBACK );
	heal_bricks = list_create( LIST_NO_AUTO_DELETE, NO_CALLBACK );
}
/*
====================================================================
Delete bricks picture
====================================================================
*/
void bricks_delete()
{
	if ( exp_bricks ) list_delete( exp_bricks ); exp_bricks = 0;
	if ( heal_bricks ) list_delete( heal_bricks ); heal_bricks = 0;
}
/*
====================================================================
Create bricks from level info.
====================================================================
*/
void bricks_create( Level *level )
{
    int i, j, k;
    
    /* clear explosion/healing list */
    list_clear( exp_bricks );
    list_clear( heal_bricks );
    
    /* build walls */
    for (i = 0; i < MAP_WIDTH; i++) {
        bricks[i][0].id = 0;
        bricks[i][0].dur = -1;
        bricks[i][0].type = MAP_WALL; /* this means - indestructible */
        bricks[i][MAP_HEIGHT - 1].id = -1;
        bricks[i][MAP_HEIGHT - 1].dur = -1;
        bricks[i][MAP_HEIGHT - 1].type = MAP_EMPTY;
    }
    for (j = 0; j < MAP_HEIGHT; j++) {
        bricks[0][j].id = 0;
        bricks[0][j].dur = -1;
        bricks[0][j].type = MAP_WALL; /* this means - indestructible */
        bricks[MAP_WIDTH - 1][j].id = 0;
        bricks[MAP_WIDTH - 1][j].dur = -1;
        bricks[MAP_WIDTH - 1][j].type = MAP_WALL;
    }
    /* clear last lines as there are non-editable */
    for (i = 1; i < MAP_WIDTH - 1; i++)
        for (j = EDIT_HEIGHT + 1; j < MAP_HEIGHT - 1; j++) {
            bricks[i][j].id = -1;
            bricks[i][j].dur = -1;
            bricks[i][j].type = MAP_EMPTY;
        }

    /* load map */
    for (i = 0; i < EDIT_WIDTH; i++)
        for (j = 0; j < EDIT_HEIGHT; j++) {
            /* create bricks */
			bricks[i + 1][j + 1].type = MAP_EMPTY;
			bricks[i + 1][j + 1].id = -1;
			bricks[i + 1][j + 1].dur = -1;
			bricks[i + 1][j + 1].exp_time = -1;
			bricks[i + 1][j + 1].heal_time = -1;
			for ( k = 0; k < BRICK_COUNT; k++ )
				if ( level->bricks[i][j] == brick_conv_table[k].c ) {
					bricks[i + 1][j + 1].type = brick_conv_table[k].type;
					bricks[i + 1][j + 1].id = brick_conv_table[k].id;
					bricks[i + 1][j + 1].dur = brick_conv_table[k].dur;
					bricks[i + 1][j + 1].score = brick_conv_table[k].score;
					break;
				}
            /* create extras */
			bricks[i + 1][j + 1].extra = EX_NONE;
			for ( k = 0; k < EX_NUMBER; k++ )
				if ( level->extras[i][j] == extra_conv_table[k].c ) {
					bricks[i + 1][j + 1].extra = extra_conv_table[k].type;
					break;
				}
        }

    /* count bricks */
    brick_count = 0;
    for (i = 1; i < MAP_WIDTH - 1; i++)
        for (j = 1; j < MAP_HEIGHT - 1; j++)
            if ( bricks[i][j].dur > 0 )
                brick_count++;
}
/*
====================================================================
Draw all bricks to offscreen surface.
====================================================================
*/
void bricks_draw()
{
    int i, j;
    if ( offscreen == 0 ) return;
    set_surf_clip( offscreen, 0, 0, sdl.screen->w - BRICK_WIDTH, sdl.screen->h );
    for ( j = 1; j < MAP_HEIGHT - 1; j++ )
        for ( i = 1; i < MAP_WIDTH - 1; i++ )
            if ( bricks[i][j].id >= 0 )
                brick_draw( offscreen, i, j, config.shadow );
    set_surf_clip( offscreen, 0,0,0,0 );
}
/*
====================================================================
Draw brick to passed surface
====================================================================
*/
void brick_draw( SDL_Surface *surf, int map_x, int map_y, int shadow )
{
    int x = map_x * BRICK_WIDTH, y = map_y * BRICK_HEIGHT;
    /* dont draw invisible bricks */
    if ( bricks[map_x][map_y].id == INVIS_BRICK_ID ) return;
    /* add shadow */
    if ( shadow ) {
        DEST( surf, x + shadow_size, y + shadow_size, BRICK_WIDTH, BRICK_HEIGHT );
        SOURCE( brick_shadow, 0, 0 );
        alpha_blit_surf( SHADOW_ALPHA );
    }
    /* brick if not frame brick */
    if ( map_x == 0 || map_y == 0 || map_x == MAP_WIDTH - 1 ) return;
    DEST( surf, x, y, BRICK_WIDTH, BRICK_HEIGHT );
    SOURCE( brick_pic, bricks[map_x][map_y].id * BRICK_WIDTH, 0 );
    blit_surf();
}
/*
====================================================================
Add brick with clipped shadow to offscreen. To draw a brick without 
shadow check use brick_draw().
====================================================================
*/
void brick_draw_complex( int mx, int my, int px, int py )
{
    brick_draw( offscreen, mx, my, 1 );
    /* redraw surrounding bricks */
    set_surf_clip( offscreen, px + shadow_size, py + shadow_size, BRICK_WIDTH, BRICK_HEIGHT );
    if ( mx + 1 == MAP_WIDTH - 1 ) {
        /* right frame part */
        DEST(offscreen, px + BRICK_WIDTH, py, BRICK_WIDTH, ( BRICK_HEIGHT << 1 ) );
        SOURCE(bkgnd, px + BRICK_WIDTH, py);
        blit_surf();
    }
    else {
        brick_draw( offscreen, mx + 1, my, 0 );
        brick_draw( offscreen, mx + 1, my + 1, 0 );
    }
    if ( bricks[mx][my + 1].type != MAP_EMPTY )
        brick_draw( offscreen, mx, my + 1, 0 );
    set_surf_clip( offscreen, 0, 0, 0, 0 );
}
/*
====================================================================
Hit brick and remove if destroyed. 'metal' means the ball
destroys any brick with the first try.
type and imp are used for shrapnell creation.
Return true on destruction
====================================================================
*/
int brick_hit( int mx, int my, int metal, int type, Vector imp )
{
    int px, py;
    int remove = 0;
    int loose_dur = 0;
    int refresh_h, refresh_w;
    
    /* a map wall can't be touched */
    if ( bricks[mx][my].type == MAP_WALL ) return 0;

    /* if metal ball resistance is futile */
    if ( metal )
        remove = 1;
    else {
        if ( bricks[mx][my].dur == -1 ) return 0; /* duration of -1 means only breakable by engery ball (metal ball) */
        if ( bricks[mx][my].dur <= 1 )
            remove = 1;
        else
            loose_dur = 1;
    }

    if ( remove ) 
        brick_remove( mx, my, type, imp );
    else
        if ( loose_dur ) {
            bricks[mx][my].dur--;
            bricks[mx][my].id--;
            player->bricks[mx][my] = bricks[mx][my].dur;
            /* set regeneration time if it's a healing brick */
            if ( bricks[mx][my].type == MAP_BRICK_HEAL ) {
                /* if this brick is already healing just reset the time
                  but don't add to the list again */
                if ( bricks[mx][my].heal_time != -1 )
                    bricks[mx][my].heal_time = BRICK_HEAL_TIME;
                else {
                    bricks[mx][my].mx = mx;
                    bricks[mx][my].my = my;
                    bricks[mx][my].heal_time = BRICK_HEAL_TIME;
                    list_add( heal_bricks, &bricks[mx][my] );
                }
            }
            if ( !active[EX_DARKNESS]) {
                px = mx * BRICK_WIDTH;
                py = my * BRICK_HEIGHT;
                refresh_w = BRICK_WIDTH;
                refresh_h = BRICK_HEIGHT;
                if ( bricks[mx][my].id + 1 == INVIS_BRICK_ID && config.shadow ) {
                    brick_draw_complex( mx, my, px, py );
                    /* resize refreshregion due to shadow */
                    refresh_w += shadow_size;
                    refresh_h += shadow_size;
                    /* udpate screen */
                    DEST( sdl.screen, px, py, refresh_w, refresh_h );
                    SOURCE( offscreen, px, py );
                    blit_surf();
                }
                else {
                    brick_draw( offscreen, mx, my, 0 );
                    brick_draw( sdl.screen, mx, my, 0 );
                }
                add_refresh_rect(px, py, refresh_w, refresh_h );
            }
        }
    return remove;
}
/*
====================================================================
Get released extra from queue if any.
====================================================================
*/
void bricks_push_extra( int type, int px, int py )
{
    if ( extra_count == EXTRA_STACK_LIMIT ) return;
    extra_stack[extra_count].type = type;
    extra_stack[extra_count].px = px;
    extra_stack[extra_count].py = py;
    extra_count++;
}
int bricks_pop_extra( int *type, int *px, int *py )
{
    if ( extra_count == 0 ) return 0;
    extra_count--;
    *type = extra_stack[extra_count].type;
    *px = extra_stack[extra_count].px;
    *py = extra_stack[extra_count].py;
    return 1;
}

