/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** qual.h
**
** representation of type qualifiers
*/

# ifndef QUALH
# define QUALH

/*
** just use tokens to represent type qualifiers 
** (tokens are defined in cgrammar.y) 
*/

typedef enum _quals { 
  QU_UNKNOWN,
  QU_CONST, QU_VOLATILE, QU_INLINE, 
  QU_EXTERN, QU_STATIC, QU_AUTO, QU_REGISTER, 
  QU_SHORT, QU_LONG, QU_SIGNED, QU_UNSIGNED, 
  QU_OUT, QU_IN,
  QU_ONLY, QU_IMPONLY,
  QU_TEMP, QU_SHARED, QU_KEEP, QU_KEPT, QU_PARTIAL, QU_SPECIAL,
  QU_NULL, QU_RELNULL, 
  QU_EXPOSED, QU_RETURNED, QU_OBSERVER, QU_UNIQUE,
  QU_OWNED, QU_DEPENDENT, QU_RELDEF,
  QU_YIELD, 
  QU_NEVEREXIT, QU_EXITS, QU_MAYEXIT, QU_TRUEEXIT, QU_FALSEEXIT,
  QU_UNUSED, QU_EXTERNAL, QU_SEF,
  QU_NOTNULL,
  QU_ABSTRACT, QU_CONCRETE, 
  QU_MUTABLE, QU_IMMUTABLE,
  QU_REFCOUNTED, QU_REFS, QU_NEWREF, QU_KILLREF, QU_TEMPREF,
  QU_TRUENULL, QU_FALSENULL, 
  QU_CHECKED, QU_UNCHECKED, QU_CHECKEDSTRICT, QU_CHECKMOD,
  QU_UNDEF, QU_KILLED,
  QU_PRINTFLIKE, QU_SCANFLIKE, QU_MESSAGELIKE,
  QU_LAST
} qual ;

/*
** qualifiers correspond to tokens in the grammar:
**    
**    standard C qualifiers:    
**        QCONST QVOLATILE QINLINE QEXTERN QSTATIC QAUTO QREGISTER
**        QSHORT QLONG QSIGNED QUNSIGNED
**    augmented LCL qualifiers: 
**        QOUT QONLY QTEMP QSHARED QUNIQUE QYIELD
**        QEXITS QMAYEXIT
*/

extern qual qual_fromInt (int p_q) /*@*/ ;
extern /*@observer@*/ cstring qual_unparse (qual p_q) /*@*/ ;

extern bool qual_equal (qual p_q1, qual p_q2) /*@*/ ;
# define qual_equal(q1,q2)    ((q1) == (q2))

extern bool qual_isUnknown (qual) /*@*/ ;
extern bool qual_isTrueNull (qual) /*@*/ ;
extern bool qual_isFalseNull (qual) /*@*/ ;
extern bool qual_isOwned (qual) /*@*/ ;
extern bool qual_isDependent (qual) /*@*/ ;
extern bool qual_isRefCounted (qual) /*@*/ ;
extern bool qual_isRefs (qual) /*@*/ ;
extern bool qual_isNewRef (qual) /*@*/ ;
extern bool qual_isKillRef (qual) /*@*/ ;
extern bool qual_isTempRef (qual) /*@*/ ;
extern bool qual_isLong (qual) /*@*/ ;
extern bool qual_isShort (qual) /*@*/ ;
extern bool qual_isSigned (qual) /*@*/ ;
extern bool qual_isUnsigned (qual) /*@*/ ;
extern bool qual_isUnique (qual) /*@*/ ;
extern bool qual_isExits (qual) /*@*/ ;
extern bool qual_isMayExit (qual) /*@*/ ;
extern bool qual_isNeverExit (qual) /*@*/ ;
extern bool qual_isTrueExit (qual) /*@*/ ;
extern bool qual_isFalseExit (qual) /*@*/ ;
extern bool qual_isConst (qual) /*@*/ ;
extern bool qual_isVolatile (qual) /*@*/ ;
extern bool qual_isInline (qual) /*@*/ ;
extern bool qual_isExtern (qual) /*@*/ ;
extern bool qual_isStatic (qual) /*@*/ ;
extern bool qual_isAuto (qual) /*@*/ ;
extern bool qual_isRegister (qual) /*@*/ ;
extern bool qual_isOut (qual) /*@*/ ;
extern bool qual_isIn (qual) /*@*/ ;
extern bool qual_isYield (qual) /*@*/ ;
extern bool qual_isOnly (qual) /*@*/ ;
extern bool qual_isImpOnly (qual) /*@*/ ;
extern bool qual_isPartial (qual) /*@*/ ;
extern bool qual_isSpecial (qual) /*@*/ ;
extern bool qual_isKeep (qual) /*@*/ ;
extern bool qual_isKept (qual) /*@*/ ;
extern bool qual_isTemp (qual) /*@*/ ;
extern bool qual_isShared (qual) /*@*/ ;
extern bool qual_isRelDef (qual) /*@*/ ;
extern bool qual_isChecked (qual) /*@*/ ;
extern bool qual_isCheckMod (qual) /*@*/ ;
extern bool qual_isCheckedStrict (qual) /*@*/ ;
extern bool qual_isUnchecked (qual) /*@*/ ;
extern bool qual_isNull (qual) /*@*/ ;
extern bool qual_isRelNull (qual) /*@*/ ;
extern bool qual_isNotNull (qual) /*@*/ ;
extern bool qual_isReturned (qual) /*@*/ ;
extern bool qual_isExposed (qual) /*@*/ ;
extern bool qual_isObserver (qual) /*@*/ ;
extern bool qual_isUnused (qual) /*@*/ ;
extern bool qual_isExternal (qual) /*@*/ ;
extern bool qual_isSef (qual) /*@*/ ;
extern bool qual_isAbstract (qual) /*@*/ ;
extern bool qual_isConcrete (qual) /*@*/ ;
extern bool qual_isMutable (qual) /*@*/ ;
extern bool qual_isImmutable (qual) /*@*/ ;
extern bool qual_isNullPred (/*@sef@*/ qual) /*@*/ ;   
extern bool qual_isRefQual (/*@sef@*/ qual) /*@*/ ;
extern bool qual_isUndef (/*@sef@*/ qual) /*@*/ ;
extern bool qual_isKilled (/*@sef@*/ qual) /*@*/ ;
extern /*@unused@*/ bool qual_isTypeQual (/*@sef@*/ qual) /*@*/ ;     
extern /*@unused@*/ bool qual_isControlQual (/*@sef@*/ qual) /*@*/ ; 
extern /*@unused@*/ bool qual_isStorageClass (/*@sef@*/ qual) /*@*/ ;
extern bool qual_isCQual (/*@sef@*/ qual) /*@*/ ;	
extern bool qual_isAllocQual (/*@sef@*/ qual) /*@*/ ;  
extern bool qual_isGlobalQual (/*@sef@*/ qual) /*@*/ ;  
extern bool qual_isImplied (/*@sef@*/ qual) /*@*/ ;   
extern bool qual_isExQual (/*@sef@*/ qual) /*@*/ ;	
extern bool qual_isAliasQual (/*@sef@*/ qual) /*@*/ ; 

# define qual_isUnknown(q)    ((q) == QU_UNKNOWN)
# define qual_isTrueNull(q)   ((q) == QU_TRUENULL)
# define qual_isFalseNull(q)  ((q) == QU_FALSENULL)
# define qual_isOwned(q)      ((q) == QU_OWNED)
# define qual_isDependent(q)  ((q) == QU_DEPENDENT)
# define qual_isRefCounted(q) ((q) == QU_REFCOUNTED)
# define qual_isRefs(q)       ((q) == QU_REFS)
# define qual_isNewRef(q)     ((q) == QU_NEWREF)
# define qual_isKillRef(q)    ((q) == QU_KILLREF)
# define qual_isTempRef(q)    ((q) == QU_TEMPREF)
# define qual_isLong(q)       ((q) == QU_LONG)
# define qual_isShort(q)      ((q) == QU_SHORT)
# define qual_isSigned(q)     ((q) == QU_SIGNED)
# define qual_isUnsigned(q)   ((q) == QU_UNSIGNED)
# define qual_isUnique(q)     ((q) == QU_UNIQUE)
# define qual_isExits(q)      ((q) == QU_EXITS)
# define qual_isMayExit(q)    ((q) == QU_MAYEXIT)
# define qual_isNeverExit(q)  ((q) == QU_NEVEREXIT)
# define qual_isTrueExit(q)   ((q) == QU_TRUEEXIT)
# define qual_isFalseExit(q)  ((q) == QU_FALSEEXIT)
# define qual_isConst(q)      ((q) == QU_CONST)
# define qual_isVolatile(q)   ((q) == QU_VOLATILE)
# define qual_isInline(q)     ((q) == QU_INLINE)
# define qual_isExtern(q)     ((q) == QU_EXTERN)
# define qual_isStatic(q)     ((q) == QU_STATIC)
# define qual_isAuto(q)       ((q) == QU_AUTO)
# define qual_isRegister(q)   ((q) == QU_REGISTER)
# define qual_isOut(q)        ((q) == QU_OUT)
# define qual_isIn(q)         ((q) == QU_IN)
# define qual_isYield(q)      ((q) == QU_YIELD)
# define qual_isOnly(q)       ((q) == QU_ONLY)
# define qual_isImpOnly(q)    ((q) == QU_IMPONLY)
# define qual_isPartial(q)    ((q) == QU_PARTIAL)
# define qual_isSpecial(q)    ((q) == QU_SPECIAL)
# define qual_isKeep(q)       ((q) == QU_KEEP)
# define qual_isKept(q)       ((q) == QU_KEPT)
# define qual_isTemp(q)       ((q) == QU_TEMP)
# define qual_isShared(q)     ((q) == QU_SHARED)
# define qual_isRelDef(q)     ((q) == QU_RELDEF)
# define qual_isNull(q)       ((q) == QU_NULL)
# define qual_isRelNull(q)    ((q) == QU_RELNULL)
# define qual_isNotNull(q)    ((q) == QU_NOTNULL)
# define qual_isReturned(q)   ((q) == QU_RETURNED)
# define qual_isExposed(q)    ((q) == QU_EXPOSED)
# define qual_isObserver(q)   ((q) == QU_OBSERVER)
# define qual_isUnused(q)     ((q) == QU_UNUSED)
# define qual_isExternal(q)   ((q) == QU_EXTERNAL)
# define qual_isSef(q)        ((q) == QU_SEF)
# define qual_isAbstract(q)   ((q) == QU_ABSTRACT)
# define qual_isConcrete(q)   ((q) == QU_CONCRETE)
# define qual_isMutable(q)    ((q) == QU_MUTABLE)
# define qual_isImmutable(q)  ((q) == QU_IMMUTABLE)
# define qual_isChecked(q)    ((q) == QU_CHECKED)
# define qual_isCheckMod(q)   ((q) == QU_CHECKMOD)
# define qual_isCheckedStrict(q) ((q) == QU_CHECKEDSTRICT)
# define qual_isUnchecked(q)     ((q) == QU_UNCHECKED)
# define qual_isUndef(q)      ((q) == QU_UNDEF)
# define qual_isKilled(q)     ((q) == QU_KILLED)

extern qual qual_createTrueNull (void) /*@*/ ;   
extern qual qual_createFalseNull (void) /*@*/ ;  
extern qual qual_createRefCounted (void) /*@*/ ; 
extern qual qual_createRefs (void) /*@*/ ;       
extern qual qual_createNewRef (void) /*@*/ ;     
extern qual qual_createKillRef (void) /*@*/ ;    
extern qual qual_createTempRef (void) /*@*/ ;    
extern qual qual_createNotNull (void) /*@*/ ;    
extern qual qual_createAbstract (void) /*@*/ ;   
extern qual qual_createConcrete (void) /*@*/ ;   
extern qual qual_createMutable (void) /*@*/ ;    
extern qual qual_createImmutable (void) /*@*/ ;  
extern qual qual_createShort (void) /*@*/ ;      
extern qual qual_createLong (void) /*@*/ ;       
extern qual qual_createSigned (void) /*@*/ ;     
extern qual qual_createUnsigned (void) /*@*/ ;   
extern qual qual_createUnique (void) /*@*/ ;     
extern qual qual_createMayExit (void) /*@*/ ;    
extern qual qual_createExits (void) /*@*/ ;      
extern qual qual_createNeverExit (void) /*@*/ ;    
extern qual qual_createFalseExit (void) /*@*/ ;    
extern qual qual_createTrueExit (void) /*@*/ ;    
extern qual qual_createConst (void) /*@*/ ;      
extern qual qual_createVolatile (void) /*@*/ ;   
extern qual qual_createInline (void) /*@*/ ;     
extern qual qual_createExtern (void) /*@*/ ;     
extern qual qual_createStatic (void) /*@*/ ;     
extern qual qual_createAuto (void) /*@*/ ;       
extern qual qual_createRegister (void) /*@*/ ;   
extern qual qual_createOut (void) /*@*/ ;        
extern qual qual_createIn (void) /*@*/ ;        
extern qual qual_createYield (void) /*@*/ ;      
extern qual qual_createOnly (void) /*@*/ ;       
extern qual qual_createOwned (void) /*@*/ ;      
extern qual qual_createDependent (void) /*@*/ ;  
extern qual qual_createRelDef (void) /*@*/ ;     
extern qual qual_createImpOnly (void) /*@*/ ;    
extern qual qual_createPartial (void) /*@*/ ;    
extern qual qual_createSpecial (void) /*@*/ ;    
extern qual qual_createKeep (void) /*@*/ ;       
extern qual qual_createKept (void) /*@*/ ;       
extern qual qual_createTemp (void) /*@*/ ;       
extern qual qual_createShared (void) /*@*/ ;     
extern qual qual_createNull (void) /*@*/ ;       
extern qual qual_createRelNull (void) /*@*/ ;    
extern qual qual_createReturned (void) /*@*/ ;   
extern qual qual_createExposed (void) /*@*/ ;    
extern qual qual_createObserver (void) /*@*/ ;   
extern qual qual_createUnused (void) /*@*/ ;     
extern qual qual_createExternal (void) /*@*/ ;     
extern qual qual_createSef (void) /*@*/ ;     
extern qual qual_createChecked (void) /*@*/ ;     
extern qual qual_createCheckMod (void) /*@*/ ;     
extern qual qual_createUnchecked (void) /*@*/ ;     
extern qual qual_createCheckedStrict (void) /*@*/ ;     
extern qual qual_createUndef (void) /*@*/ ;
extern qual qual_createKilled (void) /*@*/ ;

# ifndef NOLCL
extern qual qual_createUnknown (void) /*@*/ ;
# define qual_createUnknown()    (QU_UNKNOWN)

extern qual qual_createPrintfLike (void) /*@*/ ;
extern qual qual_createScanfLike (void) /*@*/ ;
extern qual qual_createMessageLike (void) /*@*/ ;

# define qual_createPrintfLike()  (QU_PRINTFLIKE)
# define qual_createScanfLike()   (QU_SCANFLIKE)
# define qual_createMessageLike() (QU_MESSAGELIKE)
# endif

# define qual_createTrueNull()   (QU_TRUENULL)
# define qual_createFalseNull()  (QU_FALSENULL)
# define qual_createRefCounted() (QU_REFCOUNTED)
# define qual_createRefs()       (QU_REFS)
# define qual_createNewRef()     (QU_NEWREF)
# define qual_createKillRef()    (QU_KILLREF)
# define qual_createTempRef()    (QU_TEMPREF)
# define qual_createNotNull()    (QU_NOTNULL)
# define qual_createAbstract()   (QU_ABSTRACT)
# define qual_createConcrete()   (QU_CONCRETE)
# define qual_createMutable()    (QU_MUTABLE)
# define qual_createImmutable()  (QU_IMMUTABLE)
# define qual_createShort()      (QU_SHORT)
# define qual_createLong()       (QU_LONG)
# define qual_createSigned()     (QU_SIGNED)
# define qual_createUnsigned()   (QU_UNSIGNED)
# define qual_createUnique()     (QU_UNIQUE)
# define qual_createMayExit()    (QU_MAYEXIT)
# define qual_createExits()      (QU_EXITS)
# define qual_createNeverExit()  (QU_NEVEREXIT)
# define qual_createTrueExit()   (QU_TRUEEXIT)
# define qual_createFalseExit()  (QU_FALSEEXIT)
# define qual_createConst()      (QU_CONST)
# define qual_createVolatile()   (QU_VOLATILE)
# define qual_createInline()     (QU_INLINE)
# define qual_createExtern()     (QU_EXTERN)
# define qual_createStatic()     (QU_STATIC)
# define qual_createAuto()       (QU_AUTO)
# define qual_createRegister()   (QU_REGISTER)
# define qual_createOut()        (QU_OUT)
# define qual_createIn()         (QU_IN)
# define qual_createYield()      (QU_YIELD)
# define qual_createOnly()       (QU_ONLY)
# define qual_createOwned()      (QU_OWNED)
# define qual_createDependent()  (QU_DEPENDENT)
# define qual_createRelDef()     (QU_RELDEF)
# define qual_createImpOnly()    (QU_IMPONLY)
# define qual_createPartial()    (QU_PARTIAL)
# define qual_createSpecial()    (QU_SPECIAL)
# define qual_createKeep()       (QU_KEEP)
# define qual_createKept()       (QU_KEPT)
# define qual_createTemp()       (QU_TEMP)
# define qual_createShared()     (QU_SHARED)
# define qual_createNull()       (QU_NULL)
# define qual_createRelNull()    (QU_RELNULL)
# define qual_createReturned()   (QU_RETURNED)
# define qual_createExposed()    (QU_EXPOSED)
# define qual_createObserver()   (QU_OBSERVER)
# define qual_createUnused()     (QU_UNUSED)
# define qual_createExternal()   (QU_EXTERNAL)
# define qual_createSef()        (QU_SEF)
# define qual_createChecked()    (QU_CHECKED)
# define qual_createCheckMod()   (QU_CHECKMOD)
# define qual_createCheckedStrict()  (QU_CHECKEDSTRICT)
# define qual_createUnchecked()   (QU_UNCHECKED)
# define qual_createUndef()       (QU_UNDEF)
# define qual_createKilled()      (QU_KILLED)

extern bool qual_isGlobCheck (/*@sef@*/ qual p_q) /*@*/ ;
# define qual_isGlobCheck(q) \
  (qual_isChecked (q) || qual_isCheckMod (q) \
   || qual_isUnchecked (q) || qual_isCheckedStrict (q))

# define qual_isNullPred(q) \
  (qual_isTrueNull (q) || qual_isFalseNull (q))

# define qual_isRefQual(q) \
  (qual_isRefCounted(q) || qual_isRefs(q) || qual_isNewRef (q) || \
   qual_isKillRef (q) || qual_isTempRef (q))

# define qual_isTypeQual(q) \
  (qual_isAbstract(q) || qual_isMutable(q) || qual_isImmutable(q))

# define qual_isControlQual(q)  (qual_isExits(q) || qual_isMayExit (q))
# define qual_isStorageClass(q) (qual_isExtern(q) || qual_isStatic(q))
# define qual_isCQual(q) \
  (qual_isAuto(q) || qual_isRegister(q) || qual_isInline(q) \
   || qual_isConst(q) || qual_isVolatile(q) || qual_isShort(q) \
   || qual_isLong (q) || qual_isSigned (q) || qual_isUnsigned (q))

# define qual_isAllocQual(q) \
  (qual_isOut (q) || qual_isIn (q) || qual_isSpecial (q) \
   || qual_isPartial (q) || qual_isRelDef (q))

# define qual_isGlobalQual(q) \
  (qual_isUndef(q) || qual_isKilled (q))

# define qual_isImplied(q)      (qual_isImpOnly(q))

# define qual_isExQual(q)	(qual_isExposed (q) || qual_isObserver (q))

# define qual_isAliasQual(q) \
  (qual_isOnly(q) || qual_isImpOnly(q) || qual_isTemp(q) \
   || qual_isOwned (q) || qual_isShared (q) || qual_isUnique (q) \
   || qual_isDependent (q) || qual_isKeep (q) || qual_isKept (q))

extern bool qual_isExitQual (/*@sef@*/ qual p_q) /*@*/ ;  
# define qual_isExitQual(q) \
  (qual_isExits (q) || qual_isNeverExit (q) || qual_isMayExit (q) \
   || qual_isTrueExit (q) || qual_isFalseExit (q))

# else
# error "Multiple include"
# endif


