/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */



/*!
 *  \file pdl_variable.h
 *
 *  \brief Include file for using the pdl variables.
 *
 *  All functions listed in here are accessible and usable for
 *  external "modules".
 *
 *
 *  \author  G.M. Venekamp  (venekamp@nikhef.nl)
 *  \version $Revision: 14868 $
 *  \date    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
 *
 */


#ifndef _PDL_VARIABLE_H
#define _PDL_VARIABLE_H

#include "pdl.h"
#include "pdl_rule.h"

/*!
 *  \brief Structure keeps track of the variables, their value and the
 *         line number they are defined on.
 *
 */
typedef struct var_s {
  char* name;      //!<  Name of the variable.
  char* value;     //!<  Value of the variable.
  BOOL okay;             //!<  TRUE if substitution can be done without further checking.
  unsigned int lineno;   //!<  Line number the variable appears on.
  struct var_s* next;    //!<  Next variable, or 0 if none.
} var_t;

extern void   lcmaps_add_variable(record_t* name, record_t* value);
extern var_t* lcmaps_find_variable(char* name);
extern void   lcmaps_reduce_to_var(char** name, rule_type_t rule_type);
extern void   lcmaps_show_variables(void);
extern void   lcmaps_free_variables(void);
extern var_t* lcmaps_get_variables(void);

#endif
