/*
 * $Id: sysconfig.c,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libconfig.
 * A library which provides a framework for managing system hardware
 * and software configuration information.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include <kl_lib.h>
#include <kl_config.h>

/*
 * alloc_sysconfig()
 */
sysconfig_t *
alloc_sysconfig(int flags)
{
	int aflag = AFLG(flags);
	sysconfig_t *scp;

	scp = (sysconfig_t *)kl_alloc_block(sizeof(sysconfig_t), aflag);
	scp->hwconfig = kl_alloc_hwconfig(aflag);
	scp->swconfig = alloc_swconfig(aflag, 0);
	scp->flags = flags;
	return(scp);
}

/*
 * free_sysconfig()
 */
void
free_sysconfig(sysconfig_t *scp)
{
	if (scp) {
		if (scp->hwconfig) {
			kl_free_hwconfig(scp->hwconfig);
		}
		if (scp->swconfig) {
			free_swconfig(scp->swconfig);
		}
		kl_free_block(scp);
	}
}

/*
 * update_sysconfig()
 */
void
update_sysconfig(sysconfig_t *scp)
{
    kl_update_hwconfig(scp->hwconfig);
}
