/*
 * $Id: kl_table.h,v 1.1 2004/12/21 23:26:23 tjm Exp $
 *
 * This file is part of libutil.
 * A library which provides auxiliary functions.
 * libutil is part of lkcdutils -- utilities for Linux kernel crash dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003, 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_TABLE_H
#define __KL_TABLE_H

typedef struct tbl_line_s {
	char  			*ptr;
	int			 cnt;
} tbl_line_t;

typedef struct col_info_s {
	int			 col_num;
	int			 col_width;
	int			 col_padd;
} col_info_t;

typedef struct tbl_col_s {
	col_info_t		*col_info;
	int			 attr;
	char			*src_line; /* ptr to line before wrapping */
	int		 	 num_lines;
	tbl_line_t		*lines;    /* ptr to wrapped line table */
} tbl_col_t;

typedef struct tbl_row_s {
	struct tbl_row_s	*next_row;
	int			 row_num;
	int			 max_lines;
	struct table_s		*tbl;
	tbl_col_t		*columns;  /* ptr to column array */
} tbl_row_t;

typedef struct table_s {
	int			 num_cols;
	col_info_t		*col_info; /* ptr to col_info table */
	int			 row_size; /* size of formatted row string */
	int      	 	 num_rows;
	tbl_row_t		*rows;	   /* linked list of rows */
} table_t;

#define COL_NUM(c) ((c)->col_info->col_num)
#define COL_WIDTH(c) ((c)->col_info->col_width)
#define COL_PADD(c) ((c)->col_info->col_padd)

/* Cell formatting attributes
 */
#define TBL_ATTR_WRAP		0
#define TBL_ATTR_LEFT		1
#define TBL_ATTR_RIGHT		2
#define TBL_ATTR_CENTER		3

/* Function prototypes
 */
table_t *tbl_alloc_table(int);
void tbl_free_table(table_t *);
int tbl_init_col(table_t *, int, int, int);
void tbl_finish_setup(table_t *);
tbl_row_t *tbl_add_row(table_t *);
int tbl_setup_col(tbl_row_t *, int, int, char *);
void tbl_format_line(tbl_row_t *, int, char *);
void tbl_format_seperator(table_t *, char *);

#endif /* __KL_TABLE_H */
