/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dlfcn.h>

#include "ldapdiff.h"

void ldifdl(struct s_mod *smod)
{
 void *h;  
 void (*pluginfunc)(struct s_mod *smod);

 if((h = dlopen(ldifgetgconf(CONFPLUGINFILE),RTLD_LAZY)) == NULL){
  fprintf(stderr,"dlopen() error: %s file: %s, line: %d\n",dlerror(),__FILE__,__LINE__);
  exit(-1);
 }
 ldiflog(LOG2,"plugin %s loaded",ldifgetgconf(CONFPLUGINFILE));

 if((pluginfunc = dlsym(h,ldifgetgconf(CONFPLUGINFUNCTION))) == NULL){
  fprintf(stderr,"dlsym() error: %s file: %s, line: %d\n",dlerror(),__FILE__,__LINE__);
  exit(-1);
 }
 ldiflog(LOG2,"plugin function %s mapped",ldifgetgconf(CONFPLUGINFUNCTION));

 /* thats it */
 pluginfunc(smod);
 
 if(dlclose(h) != 0){
  fprintf(stderr,"dlclose() error: %s file: %s, line: %d\n",dlerror(),__FILE__,__LINE__);
  exit(-1);
 }
 ldiflog(LOG2,"plugin %s closed",ldifgetgconf(CONFPLUGINFILE));
}
