#ifndef __error_h
#define __error_h

#include <errno.h>
#ifndef EBADMSG
/* *BSD doesn't have EBADMSG */
#define EBADMSG EFAULT
#endif
#ifndef ENOTSUP
/* ... or ENOTSUP */
#ifdef EOPNOTSUPPORT
#define ENOTSUP	EOPNOTSUPPORT
#else
#define ENOTSUP	ENOENT
#endif
#endif /*ENOTSUP */


void inline status(const char *m, ...);

extern int use_syslog;
extern const int log_debug, log_info, log_warning, log_fatal;

void log_init(char *s);

void inline log(int lev, const char *m, ...);

void inline debug(const char *m, ...);

void inline fatal(const char *m, ...);
void inline warning(const char *m, ...);

void inline cfatal(const char *m, ...);
void inline cwarning(const char *m, ...);

#endif
