# [Le Biniou](https://biniou.net)

[![pipeline status](https://gitlab.com/lebiniou/lebiniou/badges/master/pipeline.svg)](https://gitlab.com/lebiniou/lebiniou/commits/master)

# Installation

## On a Debian GNU/Linux-based system

  1. Install required dependencies

  ```sh
  sudo apt-get -qq update
  sudo apt-get -qq install autoconf pkg-config gcc make libglib2.0-dev libfftw3-dev libxml2-dev libfreetype6-dev libswscale-dev libsdl2-ttf-dev libpnglite-dev libcaca-dev libjack-dev pandoc libsndfile1-dev
  ```

  2. Configure, compile and install

  ```sh
  autoreconf -fi
  ./configure
  make
  sudo make install
  ```

  3. Follow the same steps for [lebiniou-data](https://gitlab.com/lebiniou/lebiniou-data) package, then

  4. Run

  ```sh
  lebiniou
  ```

  5. Get more options
  ```sh
  lebiniou --help
  man lebiniou
  ```

## Other Linux-based systems

  1. Pull necessary dependencies
  
  2. Same procedure, just add the `--with-pnglite` flag to configure

  ```sh
  autoreconf -i
  ./configure --with-pnglite
  make
  sudo make install
  ```

## BSD-based systems

If you want to build the [documentation](https://biniou.net/manual.html),
make sure you have the [pandoc](https://pandoc.org) package installed:
```sh
pandoc --version
pandoc 2.2
```

1. Fetch dependencies

* FreeBSD (12.0)
  ```sh
  pkg install autoconf automake pkgconf glib fftw3 libxml2 ffmpeg sdl2_ttf libcaca jackit
  ```

* NetBSD (8.0)
  ```sh
  pkg_add autoconf automake pkg-config glib2 fftw libxml2 ffmpeg4 SDL2_ttf libcaca jack
  ```

* OpenBSD (6.4)
  ```sh
  pkg_add glib2 fftw3 libxml ffmpeg sdl2-ttf libcaca jack
  ```

2. Configure, compile and install
  ```sh
  autoreconf -fi
  ./configure
  make
  make install
  ```
