/*
 * The main program.
 * Includes some odd-ball functions that don't fit anywhere else.
 */

#include "ledd.h"

#include <stdio.h>
#include <unistd.h>

static options *ledd_opts_new(void);

/*
 * The main function (as if you didn't know). Sets up the stuff and
 * includes the main loop.
 */
int main(int argc, char *argv[]) {
	options *opts;
	gint p;
	GMainLoop *mainloop;

	/* Set logging to STDERR. */
	log_set_facility(NULL);
	signal_ignore_abort();

	/* Parse the command line and config file options */
	opts=ledd_opts_new();
	config_cmdline(opts,argc,argv);

	/* Check for existing ledd */
	p=startup_pidfile_check(opts);
	if (p) {
		fprintf(stderr,"Another ledd process (PID ");
		if (p==1)
			fprintf(stderr,"unknown");
		else
			fprintf(stderr,"%d",p);
		fprintf(stderr,") seems to be running.\n");
		fprintf(stderr,"If it's not, delete the file %s "
			"and try again\n",opts->pidfile->name);
		abort();
	}

	/* Go into daemon mode if requested (before signal handler) */
	if (opts->daemon>0) {
		startup_fork();
	}

	/* We may now be in daemon mode, so we change logging to the
	 * requested type. If we are in daemon mode, no messages can be
	 * sent outside nicely anyway. */
	log_set_facility(opts->logging);

	/* Set the pidfile */
	startup_pidfile_write(opts);

	/* Set the signal handler */
	signal_set_handler(opts);

	/* Make the pipes */
	pipe_open_all(opts);

	/* Exec the startup script(s) */
	startup_exec_all(opts);

	g_message("up and chugging (PID %d)",getpid());

	/* Then we'll just wait... */
	/* TODO: Not entirely nice casting stuff, if someone can suggest
	 * a clean way (not having the functions cast a (gpointer) to
	 * an (options *)) to do this, please do!
	 */
	mainloop=g_main_new(FALSE);
	g_timeout_add(SLEEPTIME,(GHookCheckFunc)led_do_your_thing,opts);
	g_timeout_add(SLEEPTIME,(GHookCheckFunc)pipe_check_all,opts);
	g_timeout_add(250,(GHookCheckFunc)startup_check_all,opts);
	g_main_run(mainloop);

	g_warning("MAINLOOP exited! Internal bug! Mail the author!");
	return 0;
}




/*
 * Allocates a new options struct, sets everything to sane values
 * (all pointers to NULL, all FDs to -1) and returns it.
 */
static options *ledd_opts_new(void) {
	options *opts;
	int i,j;

	opts=g_new0(options,1);

	opts->ttys=g_slist_alloc();
	opts->pipes=g_slist_alloc();
	opts->startup=g_slist_alloc();
	opts->fixttys=g_slist_alloc();  /* tty-change */
	opts->pidfile=g_new0(File,1);
	opts->pidfile->fd=-1;
	opts->logging=g_new0(File,1);
	opts->logging->fd=-1;

	for (i=0; i<LED_MAX; i++)
		for (j=0; j<(PRIORITY_MAX+1); j++)
			opts->leds[i][j]=g_new0(LedControl,1);

	/* We'll keep it running... */
	opts->anim_timer=g_timer_new();
	g_timer_start(opts->anim_timer);

	return opts;
}


