Browser subclass: #ScopedBrowser
	instanceVariableNames: 'includedCategories excludedClasses includedClasses '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MakingSmalltalk-Article4'!

!ScopedBrowser methodsFor: 'class list' stamp: 'JRS 12/12/2000 09:37'!
classList
	"Override this method to:
		* look up the category index from the system category list, as the browser category index is expected to be different than the system category lists index.
		* reject/include any excluded/included classes
	Answer an array of the class names of the selected category. Answer an empty array if no selection exists."
	| categoryClasses |
	"Use temporary variable here, instead of block variable as I've heard Squeak has/had trouble with block variables."

	systemCategoryListIndex = 0
		ifTrue: [^Array new]
		ifFalse: [categoryClasses := (systemOrganizer listAtCategoryNumber: (systemOrganizer categories 
					indexOf: self selectedSystemCategoryName asSymbol)). 
				"The implicit logic here, is that if there are both no included and no excluded classes - 
				no class scope was specified - don't reject any classes."
				self includedClasses isNil
					ifTrue: [^categoryClasses reject: [:e | self excludedClasses includes: e name]]
					ifFalse: [^categoryClasses select: [:e | self includedClasses includes: e name]]].! !


!ScopedBrowser methodsFor: 'system category list' stamp: 'JRS 11/19/2000 09:16'!
systemCategoryList
	"Override this method to answer the scoped class categories modeled by the receiver."

	^self includedCategories select: [:e | systemOrganizer categories includes: e]! !


!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:05'!
excludedClasses 

	^excludedClasses ! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:06'!
excludedClasses: aCollectionOfClasses 

	^excludedClasses := aCollectionOfClasses.! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:05'!
includedCategories

	^includedCategories! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:06'!
includedCategories: aCollectionOfCategories

	^includedCategories := aCollectionOfCategories! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 12/12/2000 09:26'!
includedClasses 

	^includedClasses ! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 12/12/2000 09:26'!
includedClasses: aCollectionOfClasses 

	^includedClasses := aCollectionOfClasses.! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ScopedBrowser class
	instanceVariableNames: ''!

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 11/19/2000 09:09'!
openBrowserWithCategories: aCollectionOfCategorySymbols 

	self openBrowserWithCategories: aCollectionOfCategorySymbols 
		withoutClasses: OrderedCollection new
		withLabelSuffix: 'Unknown scope'! !

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 12/12/2000 09:19'!
openBrowserWithCategories: aCollectionOfCategorySymbols withClasses: aCollectionOfClassSymbols

	self openBrowserWithCategories: aCollectionOfCategorySymbols 
		withClasses: aCollectionOfClassSymbols
		withLabelSuffix: 'Unknown scope'! !

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 12/12/2000 09:20'!
openBrowserWithCategories: aCollectionOfCategorySymbols withClasses: aCollectionOfClassSymbols withLabelSuffix: aLabelSuffix

	| aScopedBrowser |

	aScopedBrowser := self new.
	aScopedBrowser includedCategories: aCollectionOfCategorySymbols.
	aScopedBrowser includedClasses: aCollectionOfClassSymbols.
	self openBrowserView: (aScopedBrowser openEditString: nil)
			label: 'Scoped Browser: ', aLabelSuffix		! !

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 11/19/2000 09:10'!
openBrowserWithCategories: aCollectionOfCategorySymbols withoutClasses: aCollectionOfClassSymbols

	self openBrowserWithCategories: aCollectionOfCategorySymbols 
		withoutClasses: aCollectionOfClassSymbols
		withLabelSuffix: 'Unknown scope'! !

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 11/19/2000 09:10'!
openBrowserWithCategories: aCollectionOfCategorySymbols withoutClasses: aCollectionOfClassSymbols withLabelSuffix: aLabelSuffix

	| aScopedBrowser |

	aScopedBrowser := self new.
	aScopedBrowser includedCategories: aCollectionOfCategorySymbols.
	aScopedBrowser excludedClasses: aCollectionOfClassSymbols.
	self openBrowserView: (aScopedBrowser openEditString: nil)
			label: 'Scoped Browser: ', aLabelSuffix		! !


!ScopedBrowser class methodsFor: 'instance creation - Making Smalltalk' stamp: 'JRS 12/17/2000 09:43'!
openBrowserForArticle3
	"Scopes the browser for Making Smalltalk 
	(www.magma.ca/~jagwar/makingSmalltalkForwardingPage.html, article 3"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol; 
			add: 'Collections-Sequenceable' asSymbol;
			add: 'Collections-Unordered' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #ArrayedCollection;
			add: #SharedQueue;
			add: #MappedCollection;
			add: #Interval;
			add: #IdentityDictionary;
			add: #IdentitySet;
			add: #PluggableDictionary;
			add: #PluggableSet;
			yourself)
		withLabelSuffix: 'Making Smalltalk - Article 3 scope'! !

!ScopedBrowser class methodsFor: 'instance creation - Making Smalltalk' stamp: 'JRS 12/17/2000 09:43'!
openBrowserForArticle4
	"Scopes the browser for Making Smalltalk 
	(www.magma.ca/~jagwar/makingSmalltalkForwardingPage.html, article 4"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol; 
			add: 'Collections-Sequenceable' asSymbol;
			add: 'Collections-Unordered' asSymbol;
			add: 'Kernel-Objects' asSymbol;
			add: 'Kernel-ST80 Remnants';
			add: 'MakingSmalltalk-Article2' asSymbol;
			add: 'MakingSmalltalk-Article4' asSymbol;
			yourself)
		withClasses: (OrderedCollection new
			add: #Collection;
			add: #SequenceableCollection;

			add: #Heap;
			add: #LinkedList;
			add: #OrderedCollection;
			add: #SortedCollection;

			add: #Bag;
			add: #Dictionary;
			add: #Set;

			add: #Boolean;
			add: #False;
			add: #Object;
			add: #True;

			add: #Workspace;

			add: #Person;
			add: #ScopedBrowser;
			yourself)
		withLabelSuffix: 'Making Smalltalk - Article 4 scope'! !


!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:35'!
openBrowserTest
	"Test category scope creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol;
			yourself)! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:35'!
openBrowserTest2
	"Test exclude classes creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Collection;
			yourself)! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:36'!
openBrowserTest3
	"Test exclude classes creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Collection;
			yourself)
		withLabelSuffix: 'Testing Scope'! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 11/19/2000 09:21'!
openBrowserTest4
	"Test instantiating with a non-existant category"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'asdfasdfd-ereeff' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Collection;
			yourself)
		withLabelSuffix: 'Testing nonexistant category'! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:41'!
openBrowserTest5
	"Test instantiating with a non-existant class to exclude"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'asdfasdfd-ereeff' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Aadfdfefff;
			yourself)
		withLabelSuffix: 'Testing nonexistant class to exclude'! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:35'!
openBrowserTest6
	"Test include classes creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withClasses: (OrderedCollection new
			add: #Collection;
			yourself)! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:39'!
openBrowserTest7
	"Test include classes creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withClasses: (OrderedCollection new
			add: #Collection;
			yourself)
		withLabelSuffix: 'Testing Scope'! !

!ScopedBrowser class methodsFor: 'unit testing' stamp: 'JRS 12/12/2000 09:41'!
openBrowserTest8
	"Test instantiating with a non-existant class to include"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'asdfasdfd-ereeff' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withClasses: (OrderedCollection new
			add: #Aadfdfefff;
			yourself)
		withLabelSuffix: 'Testing nonexistant class to include'! !


!ScopedBrowser class methodsFor: 'testing' stamp: 'JRS 12/13/2000 10:34'!
version

	^1.1! !