/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HEADER
#define LIFEOGRAPH_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gtkmm.h>

#include "helpers.hpp"
#include "settings.hpp"
#include "panel_main.hpp"
#include "panel_diary.hpp"
#include "widget_textview.hpp"
#include "dialog_export.hpp"
#include "view_entry.hpp"
#include "view_login.hpp"
#include "undo.hpp"


namespace LIFEO
{

class AppWindow : public Gtk::ApplicationWindow
{
    public:
                                    AppWindow();
                                    ~AppWindow();
        static AppWindow            *p;

        void                        draw_welcomescreen();
        void                        draw_loginscreen();

        void                        update_title();

        void                        freeze_auto_logout();
        void                        unfreeze_auto_logout();

        bool                        confirm_dismiss_element( const DiaryElement*,
                                                             Gtk::Widget* = NULL );
        Gtk::TreeRow                get_element_row( const DiaryElement* );

        void                        login();
        bool                        finish_editing( bool = true );
        void                        logout( bool );

        void                        show_about();

        bool                        write_backup();

        void                        handle_undo();
        void                        handle_redo();

        // PANELS AND VIEWS
        PanelMain                   *panel_main;
        PanelDiary                  *panel_diary;
        PanelExtra                  *panel_extra;

        ViewLogin                   *m_view_login;
        DiaryView                   *m_diary_view;
        EntryView                   *m_entry_view;
        TagView                     *m_tag_view;
        CategoryTagsView            *m_ctg_tags_view;
        ChapterView                 *m_chapter_view;
        FilterView                  *m_filter_view;

    protected:
        bool                        on_event( GdkEvent* );
        bool                        on_delete_event( GdkEventAny* );

        // WIDGETS
        Gtk::AboutDialog            *m_about_dialog;

        Gtk::Paned                  *m_paned_entry;
        Gtk::Paned                  *m_paned_main;

        sigc::connection            m_connection_backup;

        // ACTIONS
        Glib::RefPtr< Gtk::Action > m_action_undo;
        Glib::RefPtr< Gtk::Action > m_action_redo;
};

} // end of namespace LIFEO

#endif
