/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_LISTITEMDIARY_HEADER
#define LIFEOGRAPH_LISTITEMDIARY_HEADER


#include "helpers.hpp"  // i18n headers
#include "entry.hpp"
#include "diary.hpp"
#include "views.hpp"
#include "widget_textview.hpp"
#include "widget_tag_list.hpp"


namespace LIFEO
{

class EntryView : public ElementShower< Entry >
{
    public:
                                EntryView();

        void                    sync();

        void                    focus_tag();

        Glib::ustring           get_title_str() const
        {
            if( m_ptr2elem->get_date().is_ordinal() )
                return Glib::ustring::compose( "%1: %2",
                                               m_ptr2elem->get_date().format_string(),
                                               m_ptr2elem->m_name );
            else
                return Glib::ustring::compose( "%1, %2",
                                               m_ptr2elem->get_date().format_string(),
                                               m_ptr2elem->get_date().get_weekday_str() );
        }
        Glib::ustring           get_info_str() const
        { return Glib::ustring::compose( _( "Entry last changed on %1" ),
                Date::format_string_d( m_ptr2elem->m_date_changed ) ); }
        Glib::ustring           get_tip_str() const
        {
            return Glib::ustring::compose( "%1: <b>%2</b>\n%3: <b>%4</b>"
#if LIFEOGRAPH_DEBUG_BUILD
                    "\nDEID: %5"
#endif
                    // TRANSLATORS: label of creation date
                    , _( "Created"), m_ptr2elem->get_date_created_str(),
                    // TRANSLATORS: label of last change date
                    _( "Changed"), m_ptr2elem->get_date_changed_str()
#if LIFEOGRAPH_DEBUG_BUILD
                    , m_ptr2elem->get_id()
#endif
                    );
        }

        bool                    is_title_editable() const
        { return( ! m_ptr2elem->get_date().is_ordinal() ); }
        Glib::ustring           get_title_edit_str() const
        { return( m_ptr2elem->get_date().format_string() ); }
        bool                    check_title_applicable( const Glib::ustring& ) const;
        bool                    apply_title( const Glib::ustring& );

        void                    show( Entry& );

        void                    handle_login();

        void                    prepare_for_hiding( Entry& );

        void                    update_formatting_toolbar();
        void                    update_highlight_button();
        void                    toggle_comments();
        void                    update_tag_widget()
        { m_widgettaglist->update(); }
        void                    update_theme();

        TextbufferDiary*        get_buffer() { return m_textview->m_buffer; }

    protected:
        enum TagOperation { TO_NONE, TO_ADD, TO_REMOVE, TO_CREATE_AND_ADD };

        void                    trash_entry();
        void                    restore_entry();
        void                    dismiss_entry();
        void                    print();
        void                    set_todo_status( ElemStatus );
        void                    toggle_favoredness();
        void                    hide();
        void                    hide_before();
        void                    hide_after();
        void                    handle_textview_changed();
        void                    handle_entry_tag_changed();
        void                    handle_button_tag_clicked();
        void                    handle_set_theme();
        void                    handle_treeviewtags_buttonpress( GdkEventButton* );
        void                    handle_drag_data_received(
                                        const Glib::RefPtr< Gdk::DragContext >&,
                                        int, int,
                                        const Gtk::SelectionData&,
                                        uint,
                                        guint );

        void                    focus_tag_entry();
        void                    handle_tag_entry_focus_out( GdkEventFocus* );
        void                    edit_tag_in_entry( const Tag* );
        void                    remove_selected_tags();

        // WIDGETS
        Gtk::RadioMenuItem*     m_menuitem_todo;
        Gtk::RadioMenuItem*     m_menuitem_done;
        Gtk::RadioMenuItem*     m_menuitem_canceled;
        Gtk::MenuItem*          m_menuitem_toggle_favorite;
        Gtk::SeparatorMenuItem* m_menuseparator_1;
        Gtk::SeparatorMenuItem* m_menuseparator_2;
        Gtk::SeparatorMenuItem* m_menuseparator_4;
        Gtk::MenuItem*          m_menuitem_trash;
        Gtk::MenuItem*          m_menuitem_restore;
        Gtk::MenuItem*          m_menuitem_dismiss;

        Gtk::Button*            m_button_bold;
        Gtk::Button*            m_button_italic;
        Gtk::Button*            m_button_strikethrough;
        Gtk::Button*            m_button_highlight;
        Gtk::Label*             m_label_highlight;
        Gtk::EventBox*          m_eventbox_highlight;      // necessary to change bg color!!
        Gtk::Button*            m_button_add_bullet;
        Gtk::Button*            m_button_add_checkbox;
        Gtk::ToggleButton*      m_button_toggle_comments;

        TextviewDiary*          m_textview;
        Gtk::Box*               m_box_tag_edit;
        TagWidget*              m_tag_widget;
        Gtk::Button*            m_button_tag_operation;
        Gtk::Button*            m_button_set_theme;
        WidgetTagList*          m_widgettaglist;
        Gtk::Box*               m_hbox_editing_toolbar;
        TagOperation            m_tag_operation_cur;

        Entry*                  m_entry_sync;

        // ACTIONS
        Glib::RefPtr< Gtk::Action > m_action_bold;
        Glib::RefPtr< Gtk::Action > m_action_italic;
        Glib::RefPtr< Gtk::Action > m_action_strikethrough;
        Glib::RefPtr< Gtk::Action > m_action_highlight;
        Glib::RefPtr< Gtk::Action > m_action_focus_tag;
        Glib::RefPtr< Gtk::ToggleAction > m_action_toggle_comments;
        Glib::RefPtr< Gtk::Action > m_action_indent;
        Glib::RefPtr< Gtk::Action > m_action_unindent;
        Glib::RefPtr< Gtk::Action > m_action_add_empty_line_above;
        Glib::RefPtr< Gtk::Action > m_action_remove_empty_line_above;
        Glib::RefPtr< Gtk::Action > m_action_move_line_up;
        Glib::RefPtr< Gtk::Action > m_action_move_line_down;
        Glib::RefPtr< Gtk::Action > m_action_time_stamp;

        bool                    m_flag_entrychanged;

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
