/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGET_ENTRYLIST_HEADER
#define LIFEOGRAPH_WIDGET_ENTRYLIST_HEADER


#include <gtkmm.h>

#include "diarydata.hpp"
#include "entry.hpp"
#include "views.hpp"


namespace LIFEO
{

class WidgetEntryList : public Gtk::TreeView
{
    public:
            typedef sigc::signal< void, Tag* > Signal_void_Tag;
                                        WidgetEntryList( BaseObjectType*,
                                                         const Glib::RefPtr<Gtk::Builder>& );
                                        ~WidgetEntryList();

            void                        clear();
            void                        present_element( const DiaryElement* );
            void                        expand_element( const DiaryElement* );
            void                        go_up( bool );
            void                        go_down( bool );
            void                        reset_sorting_criteria();
            void                        handle_sorting_criteria_changed( SortingCriteria );

            Gtk::TreePath               find_element( const DiaryElement* ) const;

            // SORTING FUNCTIONS
            int                         sort_by_date( const Gtk::TreeModel::iterator&,
                                                      const Gtk::TreeModel::iterator& );
            int                         sort_by_size( const Gtk::TreeModel::iterator&,
                                                      const Gtk::TreeModel::iterator& );
            int                         sort_by_change( const Gtk::TreeModel::iterator&,
                                                        const Gtk::TreeModel::iterator& );

            void cell_data_func_icon( Gtk::CellRenderer* cell, const Gtk::TreeModel::iterator& iter );

            Glib::RefPtr< Gtk::TreeStore >
                                        m_treestore;

    protected:
            DiaryElement                *m_elem_drop_target;

            bool                        on_button_press_event( GdkEventButton* );
            bool                        on_button_release_event( GdkEventButton* );
            bool                        on_key_press_event( GdkEventKey* );

            void                        on_drag_begin( const Glib::RefPtr< Gdk::DragContext >& );
            bool                        on_drag_motion( const Glib::RefPtr< Gdk::DragContext >&,
                                                        int, int, guint );
            bool                        on_drag_drop( const Glib::RefPtr< Gdk::DragContext >&,
                                                      int x, int y, guint time );
            //void                        on_drag_data_received(
                                                //const Glib::RefPtr< Gdk::DragContext >&,
                                                //int, int, const Gtk::SelectionData&,
                                                //guint, guint );

            bool                        make_path_deeper_last( Gtk::TreePath& );
            bool                        move_path_next( Gtk::TreePath& );
};


} // end of namespace LIFEO

#endif
