/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/HistoryDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/07/18 23:10:26 $
 *!!	$Revision: 1.7 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!    Based on cervisia's code by Bernd Gehrmann
 *!!    Copyright (C) 1999-2001 Bernd Gehrmann - bernd@physik.hu-berlin.de
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <qlistview.h>
#include <qstringlist.h>
#include "CmdThread.h"
#include "globals.h"
#include "HistoryDialogImpl.h"

/* 
 *  Constructs a HistoryDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
HistoryDialogImpl::HistoryDialogImpl( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : HistoryDialog( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
HistoryDialogImpl::~HistoryDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


bool HistoryDialogImpl::parseHistory (QString BaseDir, QString name, QString connectMethod)
{
    QString command;

    bool usingRsh = false;
    bool usingSsh = false;
    
    if( (QString::compare(connectMethod, "ext") == 0)
	|| (QString::compare(connectMethod, "") == 0) )
    {//rsh access
	    usingRsh = true;
		    
       command = "cd " + BaseDir + " && ";
						 
       if (cvsRsh.find("ssh") == 0) {
          if (!sshAgentIsRunning) startSshAgent();
          usingSsh = true;

          command += "set-ssh-commit-env.sh \"";
          command += "env CVS_RSH=" + cvsRsh + " cvs history -e -a \"";
       } else {//rsh
          command += "env CVS_RSH=" + cvsRsh + " cvs history -e -a  2> /dev/null";
       }
    }
								    
    if(!usingRsh) {
       command = "cd " + BaseDir + " && cvs history -e -a 2> /dev/null";
    }
    
    CmdThread * Thread = new CmdThread( command );
    Thread->start();
    Thread->wait();
    
    long len = Thread->m_outputQueue.count();
    QString line;

    for (int i=0, index=0; i<len; ++i)
    {
	    line = Thread->m_outputQueue[i];
            QStringList list = QStringList::split (' ', line);
            QString cmd = list[0];
            if (cmd.length() != 1)
                continue;

            int ncol;
	    //            int cmd_code = cmd[0].latin1();
            QChar cmd_code = cmd[0];
            switch (cmd_code)
                {
                case 'O':
                case 'F':
                case 'E': ncol = 8;
                default:  ncol = 10;
                }
            if (ncol != (int)list.count())
                continue;

            QString event;
            switch (cmd_code)
                {
                case 'O': event = tr("Checkout ");         break;
                case 'T': event = tr("Tag ");              break;
                case 'F': event = tr("Release ");          break;
                case 'W': event = tr("Update, Deleted ");  break;
                case 'U': event = tr("Update, Copied ");   break;
                case 'G': event = tr("Update, Merged ");   break;
                case 'C': event = tr("Update, Conflict "); break;
                case 'M': event = tr("Commit, Modified "); break;
                case 'A': event = tr("Commit, Added ");    break;
                case 'R': event = tr("Commit, Removed ");  break;
                default:  event = tr("Unknown ");
                }

            if (ncol == 10)
	    {
		    new QListViewItem (HistoryList, QString().sprintf(" %05d ", index),
				       " " + list[1] + " " + list[2] + " " + list[3] + " ",
				       event, list[4], list[5], list[6], list[7]);
	    }
            else
	    {
		    new QListViewItem (HistoryList, QString().sprintf(" %05d ", index),
				       " " + list[1] + " " + list[2] + " " + list[3] + " ",
				       event, list[4], "", "", list[5]);
	    }

	    index++;
        }

    return true;
}


// Local Variables:
// c-basic-offset: 4
// End:
