/****************************************************************************
**
** $Id: PixmapCache.cpp,v 1.12 2001/11/04 13:01:54 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <qglobal.h>
#include <qbitmap.h>
#include <qdict.h>
#include "PixmapCache.h"
#include "EmbeddedImages.h"


/*!!***************************************************************************
 *!! FUNCTION NAME
 *!!        findEmbeddedPixmap
 *!!
 *!! PARAMETERS
 *!!        const char* name          -  name of the pixmap to find
 *!!
 *!! RETURN VALUE
 *!!        QPixmap& reference to the requested pixmap if it exist or
 *!!        a default pixmap if the requested one was not found.
 *!!
 *!! GLOBALS ACCESSED
 *!!        ?
 *!!
 *!! DESCRIPTION
 *!!        Find the requested (Embedded) pixmap.
 *!!        This function was originally generated by qembed and has been
 *!!        tweeked for LinCVS.
 *!!**************************************************************************/

const QPixmap& findEmbeddedPixmap (const char* name)
{
    static QDict<QPixmap> dict;
    QPixmap* pPixmap = dict.find(name);
    
    if ( !pPixmap ) {
	for (int i=0; embed_image_vec[i].data; i++) {
	    if ( 0==strcmp(embed_image_vec[i].name, name) ) {
		QImage img = QImage((uchar*)embed_image_vec[i].data,
				    embed_image_vec[i].width,
				    embed_image_vec[i].height,
				    embed_image_vec[i].depth,
				    (QRgb*)embed_image_vec[i].colorTable,
				    embed_image_vec[i].numColors,
				    QImage::BigEndian);
		if ( embed_image_vec[i].alpha )
		    img.setAlphaBuffer(TRUE);
		
		pPixmap = new QPixmap; 
		pPixmap->convertFromImage(img);
		dict.insert (name, pPixmap);
		break;
	    }
	}

	if (!pPixmap)
	{
		// This assertion will help us detect unwanted
		// recursion.
		ASSERT(QString(name) != QString("lincvs-missing"));
		return (findEmbeddedPixmap ("lincvs-missing"));
	}
    }
    
    return *pPixmap;
}
