/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/PropertiesDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/06/28 23:03:33 $
 *!!	$Revision: 1.5 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <qstring.h>
#include <qlistview.h>
#include "PropertiesDialogImpl.h"
#include "directory.h"


/*!!***************************************************************************
 *!! FUNCTION NAME
 *!!    PropertiesDialogImpl::PropertiesDialogImpl
 *!!
 *!! PARAMETERS
 *!!    QWidget *parent
 *!!    Directory *Item
 *!!
 *!! RETURN VALUE
 *!!    none
 *!!
 *!! GLOBALS ACCESSED
 *!!    none
 *!!
 *!! DESCRIPTION
 *!!    Constructs a PropertiesDialogImpl which is a child of 'parent', with
 *!!    the name 'name' and widget flags set to 'f' 
 *!!
 *!!    The dialog will by default be modeless, unless you set 'modal' to
 *!!    TRUE to construct a modal dialog.
 *!!**************************************************************************/

PropertiesDialogImpl::PropertiesDialogImpl (QWidget *parent, Directory *Item)
    : PropertiesDialog (parent, "SandBox Properties", true)
{
	// Disable sorting
	PropertyList->setSorting (-1);

	new QListViewItem (PropertyList, tr("Access"),
			   Item->getDisabled (QString(Item->fullName())) ? 
			   "disabled" : "enabled");
	new QListViewItem (PropertyList, tr("Connection Method"), Item->connectMethod());
	new QListViewItem (PropertyList, tr("Host"), Item->host());
	new QListViewItem (PropertyList, tr("User Name"), Item->userName());
	new QListViewItem (PropertyList, tr("Root Directory"), Item->rootDir());
	new QListViewItem (PropertyList, tr("Repository"), Item->repository());
}

/*  
 *  Destroys the object and frees any allocated resources
 */
PropertiesDialogImpl::~PropertiesDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

