/****************************************************************************
**
** $Id: colortab.cpp,v 1.4 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <colortab.h>
#include <stdio.h>

ColorTab::ColorTab( const QString & S) : QTab( S ) {
        _hasColor = 0;
}

void ColorTab::setColor( const QColor & C ) {
        _hasColor = 1;
        _color = C;
}

ColorTabBar::ColorTabBar( QWidget * Parent ) : QTabBar( Parent ){
}


void ColorTabBar::paintLabel (QPainter * P, const QRect & R, QTab * T, bool b) const
{
        if (((ColorTab*)T)->hasColor())
	{
		QColor C = colorGroup().foreground();

		(const_cast<QColorGroup &>(colorGroup())).
			setColor(QColorGroup::Foreground,((ColorTab *)T)->getColor());

		QFont F = P->font();
		F.setBold(true);
		P->setFont(F);

		QTabBar::paintLabel (P, R, T, b);

		(const_cast<QColorGroup &>(colorGroup())).
			setColor(QColorGroup::Foreground, C);
	}
	else
	{
		QTabBar::paintLabel (P, R, T, b);
	}
}


ColorTabWidget::ColorTabWidget( QWidget * Parent ) :
        QTabWidget( Parent ) {

        ColorTabBar * TB = new ColorTabBar( this );

        setTabBar( TB );
}
