/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/cvstoolbar.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: riemer $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/11/01 09:13:07 $
 *!!	$Revision: 1.17 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!    Tilo Riemer <riemer@lincvs.org>
 *!!    Falk Brettschneider <gigafalk@yahoo.com>
 *!!    Wim Delvaux <wim.delvaux@chello.be>
 *!!    Jose Hernandez <joseh@tesco.net>
 *!!    Helmut Koll <HelmutKoll@web.de>
 *!!    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <qwhatsthis.h>     
#include <qiconset.h>
#include <qwidget.h>
#include <qstring.h>
#include <qapplication.h>
#include <qlayout.h>

#include "globals.h"
#include "cvstoolbar.h"
#include "lincvs.h"

// pixmaps 
#include "PixmapCache.h"


/*---------------------------------------------------------------------------*
 *  Definitions, Macros                                                      *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  typedefs                                                                 *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  global Variables                                                         *
 *---------------------------------------------------------------------------*/

extern ApplicationWindow  *LinMainW;


// -- internal objects ---------------------------------------------------

static const QString whatsThisTextInt[]= {
  
  /* add2Wb */
  "Click this button to add a <em>new folder</em> to the workbench." 
  "You can also select the<br> <b>Project-Explorer -> Add to Workbench</b><br> from the menu.",
  
  /* stopAction */
  "When highlighted button is clicked any current action is terminated immediately."
  "When disabled nothing happens.",

  /* exit */
  "Exit LinCVS.",

  /* info */
  "Click this button to get some useless information about this program "
  "like the authors and GNU GPL.<br>"
  "You can also select the <b>Help -> About</b> from the menu.",

  /* import */
  "Click this button to <em>import</em> a new project or folder "
  "into the CVS repository. It's <b>not</b> a <em>cvs check in </em>!<br>" 
  "You can also select the<br><b>Administration -> Import</b><br>from the menu.",
   
  /* co */
  "Click this button to <em>ckeck out</em> a project from the CVS repository "
  "into your workbench.<br> You can also select the<br><b>Administration -> Checkout</b><br>"
  "from the menu.",
 
  /* upd */
  "Click this button to update the status of your modules.<br>"
  "Normally this is done automatically due to the timer settings and you should never "
  "use it.<br> But for those users who have bad time resources and put therefore a "
  "long time constant this is a possibility to do this manually before they do any "
  "action with cvs.<br> You can also select the <br><b>Options->Status Update->Immediate</b> <br>"
  "from the menu.",

  /*updenable */
  "Toggle button to enable/disable the automatic status update for the files. "
  "When disabled (showing red clock) the file state shows the state of the last update this may not "
  "be currently valid! It's up to the user to maintain correct information.<br>"
  "When enabled (showing green clock) the state is updated automatically due "
  "to the time constant set and the user need not care about. "
  "You can also select the <br><b>Options->Status Update->Enable</b> or <br>"
  "<b>Options->Status Update->Disable</b> from the menu." ,

  /* cvsupd */
  "You should mark a folder or a file before then this button does a cvs update "
  "on it. You can also select this function from the context menu",

  /* cvscom */
  "You should mark a folder or a file before then this button does a cvs commit "
  "on it. You can also select this function from the context menu",

};

// -- external objects ---------------------------------------------------

static const QString whatsThisText[]= {
  
/* wbench */
  "This is your working area<br>"
  "In this area all the folders are listed you already checked out with LinCVS. "
  "Additionally all folders you have added with the command <br>"
  "<b>Project-Explorer -> Add to Workbench</b><br>are listed here.<br>",

/* cvsFile */  
  "When clicked on a folder in the workbench in this area all <em>checked out</em> " 
  "files are listed together with some status information described in the headline."
  "This information is updated periodically due to the timer settings."
  "When you click on a file with your right mouse button a context menu is opened.",

/* nonCvsFile */
  "In this area all the files are listed which never had "
  "been checked in until now. To add a file to the repository just click it with your "
  "right mouse button and do a commit afterwards.",

/* tabFileList */
  "When you select a folder in the workbench then the whole directory contents of a "
  "CVS project is listed in these two tabs. Splitted into <em>CVS</em> and <em>NON CVS</em> files.",
  
/* status */
  "Here you find messages generated from cvs like status, diff, log .. etc ",
};


 
/*---------------------------------------------------------------------------*
 *  Prototypes / classes                                                     *
 *---------------------------------------------------------------------------*/

cvsToolbar::cvsToolbar (QMainWindow *parent) : KToolBar(parent)
{
	// create buttons for toolbar    
	tb_exit = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdExit32x32")),
                             tr("Exit application"), QString::null,
                             qApp, SLOT(closeAllWindows()), this, "Exit");

	this->addSeparator();

	m_pStopAction = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdStop32x32")),
					 tr("Stop Action"), QString::null, parent, 
					 SLOT(stopCurAction()), this, "stop action");  

	m_pStopAction->setEnabled(false);

	this->addSeparator();

	tb_cvsUpd = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdUpdate32x32")),
				     tr("cvs update"), QString::null, parent,
				     SLOT(updateAny()), this, "Update");

	tb_cvsMerge = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdUpdate32x32")),
				     tr("cvs merge"), QString::null, parent,
				     SLOT(mergeAny()), this, "Merge");

	tb_com = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdCommit32x32")),
				  tr("cvs commit"), QString::null, parent, 
				  SLOT(commitAny()), this, "Commit");

	tb_co = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdCheckout32x32")),
				 tr("cvs check out"), QString::null, parent,
				 SLOT(checkOut()), this, "check out");

	tb_imp = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdImport32x32")),
				  tr("cvs import"), QString::null, parent,
				  SLOT(import()), this, "import");

	this->addSeparator();

	tb_addWb = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdWorkbench32x32")),
				    tr("add to workbench"), QString::null, parent, 
				    SLOT(addProjectSlot()), this, "open file");

	this->addSeparator();

	tb_upd = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdModule32x32")),
				  tr("update module status"), QString::null, parent, 
				  SLOT(checkStatus()), this, "update");

	tb_clock = new QToolButton (QIconSet (findEmbeddedPixmap ("CmdTimer32x32")),
				    tr("toggle to enable/disable automatic status update"),
				    QString::null, this, SLOT(toggleStatusTimer()),this,
				    "clock on");

	tb_clock->setToggleButton (TRUE);
	tb_clock->setIconSet (findEmbeddedPixmap ("CmdTimerDisabled32x32"), TRUE);
     
	this->addSeparator();   

	tb_annotate = new QToolButton (QIconSet (findEmbeddedPixmap ("FileUnchanged16x16")),
				       tr("cvs annotate"), QString::null, parent, 
				       SLOT(annotateAny()), this, "annotate");
	tb_annotateGrepLine = new QToolButton (QIconSet (findEmbeddedPixmap ("FileUnchanged16x16")),
				       tr("Who has changed which line?"), QString::null, parent, 
				       SLOT(annotateGrepLine()), this, "annotate_grep_line");
	tb_annotateGrepLines = new QToolButton (QIconSet (findEmbeddedPixmap ("FileUnchanged16x16")),
				       tr("Who has changed which lines?"), QString::null, parent, 
				       SLOT(annotateGrepLines()), this, "annotate_grep_lines");

	this->addSeparator();   

	tb_watchAdd = new QToolButton (QIconSet (findEmbeddedPixmap ("FolderStatus16x16")),
				       tr("cvs watch add"), QString::null, parent, 
				       SLOT(watchAdd()), this, "watch add");
	tb_watchRemove = new QToolButton (QIconSet (findEmbeddedPixmap ("FolderStatus16x16")),
				       tr("cvs watch remove"), QString::null, parent, 
				       SLOT(watchRemove()), this, "watch remove");
	tb_watchOn = new QToolButton (QIconSet (findEmbeddedPixmap ("FolderStatus16x16")),
				       tr("cvs watch on"), QString::null, parent, 
				       SLOT(watchOn()), this, "watch on");
	tb_watchOff = new QToolButton (QIconSet (findEmbeddedPixmap ("FolderStatus16x16")),
				       tr("cvs watch off"), QString::null, parent, 
				       SLOT(watchOff()), this, "watch off");

	this->addSeparator();   

	tb_info = new QToolButton (QIconSet (findEmbeddedPixmap ("lincvs-32")),
				   tr("info"), QString::null, parent, 
				   SLOT(about()), this, "info");

	QWhatsThis::whatsThisButton (this);

	/* Make the toolbar stretch the width or height of the
	 * main window depending on orientation.
	 */
	setStretchableWidget(new QWidget(this));
	setHorizontalStretchable(true);
	setVerticalStretchable(true);

	this->addWhatsThisTextInt (tb_addWb, add2Wb);
	this->addWhatsThisTextInt (m_pStopAction, stopAction);
	this->addWhatsThisTextInt (tb_exit, exit );
	this->addWhatsThisTextInt (tb_info, info);
	this->addWhatsThisTextInt (tb_imp, import);
	this->addWhatsThisTextInt (tb_co, co);
	this->addWhatsThisTextInt (tb_upd, upd);
	this->addWhatsThisTextInt (tb_clock, updenable);
	this->addWhatsThisTextInt (tb_cvsUpd, cvsupd);
	this->addWhatsThisTextInt (tb_com, cvscom);
}




/*---------------------------------------------------------------------------*/
/*!
\fn			cvsToolbar::~cvsToolbar(void)
\brief		dtor.

<BR><HR>*/
/*---------------------------------------------------------------------------*/

cvsToolbar::~cvsToolbar(void) { }



/*---------------------------------------------------------------------------*/
/*!
\fn			void cvsToolbar::addWhatsThisTextInt(QToolButton *tb, T_wtTextInt textType )
\brief		For internal toolbuttons

\param		*tb		toolbutton
\param		textType		index of QString whatsThisTextInt[]

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::addWhatsThisTextInt(QToolButton *tb, T_wtTextInt textType )
{
  QWhatsThis::add( (QWidget*)tb, whatsThisTextInt[textType] );
}


/*---------------------------------------------------------------------------*/
/*!
\fn			void cvsToolbar::addWhatsThisText( void *ptr,  T_wtText textType  )
\brief		for external objects

\param		*ptr		poiter to object
\param		textType		index of QString whatsThisText[]

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::addWhatsThisText( void *ptr,  T_wtText textType  )
{
  QWhatsThis::add( (QWidget*)ptr, whatsThisText[textType] );  
}



/*---------------------------------------------------------------------------*/
/*!
\fn			void cvsToolbar::toggleStatusTimer()
\brief		Toggles status timer between enabled and disabled state.

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::toggleStatusTimer(void)
{
  if (tb_clock->isOn())
  {
    StatTimerEnable = FALSE;
    LinMainW->m_timer.stop();
    /*! once again to update fileview with pixmap "?" */
    LinMainW->checkStatus();
  }
  else
  {
    StatTimerEnable = TRUE;
    LinMainW->m_timer.start(CHECKSTATUSINTERVALL);  
    LinMainW->checkStatus();
  }
  
}


/*---------------------------------------------------------------------------*/
/*!
\fn			void cvsToolbar::setStatTimerEnable (void)
\brief		Slot for selection from menu.

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::setStatTimerEnable (void)
{
  tb_clock->setOn(FALSE);
  toggleStatusTimer();
}


/*---------------------------------------------------------------------------*/
/*!
\fn			void cvsToolbar::setStatTimerDisable (void)
\brief		Slot for selection from menu.

<BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::setStatTimerDisable (void)
{
  tb_clock->setOn(TRUE);
  toggleStatusTimer();
}

/*--------- END OF FILE -----------------------------------------------------*/
