import re
from linda import libchecks, checks

class CopyrightCheck(libchecks.LindaChecker):
    'Checks the copyright file'
    def check_binary_2(self):
        self.copyright_exists()
        self.copyright_location()
        self.compressed()
        self.parse_copyright()
    
    def copyright_exists(self):
        if not os.path.exists(os.path.join(self.information['dir'], \
            'unpacked/usr/share/doc', self.pkg_name, 'copyright')) and not \
            os.path.islink(os.path.join(self.information['dir'], \
            'unpacked/usr/share/doc', self.pkg_name)):
            self.signal_error('no-copyright')
        if os.path.islink(os.path.join(self.information['dir'], 'unpacked', \
            'usr/share/doc', self.pkg_name, 'copyright')):
            self.signal_error('copyright-is-symlink')
    def copyright_location(self):
        if os.path.exists(os.path.join(self.information['dir'], 'unpacked', \
            'usr/share/doc/copyright', self.pkg_name)) or \
            os.path.exists(os.path.join(self.information['dir'], 'unpacked', \
            'usr/doc/copyright', self.pkg_name)):
            self.signal_error('old-copyright-location')
    def compressed(self):
        for file in self.information['collector']('files', 'files').keys():
            if file.find('copyright') != -1 and \
                os.path.getsize(os.path.join(self.information['dir'], \
                'unpacked', file[1:])) < 4096:
                if self.information['collector']('output', 'file')[file].find('compressed') != -1:
                    self.signal_error('compressed-copyright')
    def parse_copyright(self):
        upstream_authors = re.compile(r'upstream author\(s\)', re.IGNORECASE)
        gpl_raw_text = 'This program is free software; you can ' +\
            'redistribute it and/or modify it under the terms of the ' +\
            'GNU Public License as published by the Free'
        gpl_text = re.compile(gpl_raw_text.replace(' ', '..?'), \
            re.MULTILINE + re.DOTALL)
        gpl_bit = re.compile(r'GNU GENERAL PUBLIC LICENSE.*TERMS AND ' +\
            'CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION', \
            re.MULTILINE + re.DOTALL)
        if os.path.exists(os.path.join(self.information['dir'], \
            'unpacked/usr/share/doc', self.pkg_name, 'copyright')):
            f = open(os.path.join(self.information['dir'], \
            'unpacked/usr/share/doc', self.pkg_name, 'copyright'))
            k = f.read()
            f.close()
            if re.search(gpl_text, k) and not \
                re.search(r'\/usr\/share\/common-licenses\/(Artistic|GPL)', k):
                self.signal_error('copyright-blurb-no-name')
            if re.search(gpl_bit, k) and len(k) > 12000:
                self.signal_error('copyright-contains-full-gpl')
            if k.find('<fill in ftp site>') != -1 or \
                k.find('<put author(s) name and email here>') != -1:
                self.signal_error('probable-dh-make-template')
            if k.find('usr/share/doc/copyright') != -1 or \
                k.find('usr/doc/copyright') != -1:
                self.signal_error('copyright-old-directory')
            if k.find('usr/share/common-licences') != -1:
                self.signal_error('common-licenses')
            if re.search(upstream_authors, k):
                self.signal_error('upstream-authors')
            del k

checks.register(CopyrightCheck)

