import re
from linda import libchecks, checks

class LibraryCheck(libchecks.LindaChecker):
    'Checks things regarding shared libraries.'
    def init(self):
        self.numbers = {'libraries': 0, 'binaries': 0}
        self.libraries = {}
        self.la_files = []
        self.info = {'soname_in_pkg': 0, 'pkgname_vs_soname': 0}
        
    def check_binary_2(self):
        self.discover_libraries()
        for library in self.libraries.keys():
            self.discover_sonames(library)
        self.check_against_libs()
        self.check_la_files()
        
    def discover_libraries(self):
        for file in self.information['collector']('files', 'elf'):
            if self.information['collector']('output', 'file')[file].find('LSB shared object') != -1 and file.find('/perl5/') == -1:
                self.numbers['libraries'] += 1
                self.libraries[file] = ''
            elif self.information['collector']('output', 'file')[file].find('LSB executable') != -1:
                self.numbers['binaries'] += 1
            if file.endswith('.so') and \
                os.path.islink(os.path.join(self.information['dir'], \
                'unpacked', file[1:])) and not self.pkg_name.endswith('-dev'):
                self.signal_error('so-symlink-non-dev')
        dprint(_("Libraries discovered without the need of Australian Idol: %s") % self.numbers['libraries'], 3)
        for file in self.information['collector']('files', 'files'):
            if file.endswith('.la'):
                self.la_files.append(file)
        dprint(_("Libraries themselves: %s") % self.libraries, 3)
    def discover_sonames(self, file):
        if not os.path.islink(os.path.join(self.information['dir'], \
            'unpacked', file[1:])):
            path = os.path.split(file)[0]
            if path in ('/lib', '/usr/lib', '/usr/lib/libg++-dbg', \
                '/usr/X11R6/lib/Xaw3d', '/usr/local/lib', '/usr/X11R6/lib', \
                '/usr/lib/libc5-compat', '/lib/libc5-compat'):
                obj = self.information['collector']('output', 'objdump')[file]
                if obj.find('SONAME') != -1:
                    cur_soname = obj[obj.find('SONAME'):obj.find('\n', \
                        obj.find('SONAME'))].split()[-1].split('.')[0].split('-')[0]
                    if cur_soname:
                        self.libraries[file] = cur_soname
                del obj
        if re.search(r'[0-9]\.so\.[0-9]', self.libraries[file]):
            self.libraries[file] = self.libraries[file].replace('.so.', '-')
        else:
            self.libraries[file] = self.libraries[file].replace('.so.', '')
        dprint(_("SONAMEs discovered: %s") % self.libraries, 3)
    def check_against_libs(self):
        if ''.join(self.libraries.values()) and not self.numbers['binaries']:
            if self.information['control']['self'][0]['section'][-1] not in \
                ('libs', 'base', 'oldlibs'):
                self.signal_error('section-not-libs')
            if not self.pkg_name.startswith('lib'):
                self.signal_error('package-not-start-lib')
        for library in self.libraries.keys():
            if self.pkg_name.find(self.libraries[library].lower()) != -1 or \
                self.libraries[library].lower().find(self.pkg_name) != -1:
                self.info['soname_in_pkg'] = 1
        if self.numbers['libraries'] and not self.info['soname_in_pkg']:
            self.signal_error('package-notlike-soname')
    def check_la_files(self):
        for file in self.la_files:
            path, throw = os.path.split(file)
            la_path = ''
            f = open(os.path.join(self.information['dir'], 'unpacked', \
                file[1:]))
            for line in f:
                if line.startswith('libdir='):
                    la_path = line[line.find("'")+1:line.rfind("'")]
            f.close() 
            if la_path != path:
                self.signal_error('libdir-not-equal-dir', [file])
        
checks.register(LibraryCheck)

