import re
from linda import libchecks, checks, dpkgver
from sets import Set

class PerlCheck(libchecks.LindaChecker):
    'Check things regarding to perl.'
    def init(self):
        self.info = {'arch-dep': 0, 'src-pkg': self.pkg_name, \
            'module-pkg': 0, 'arch': 'none', 'perl-dir': 0, 'wrong': \
            {'arch-dep': 0, 'arch-indep': 0}, 'right': {'arch-dep': 0, \
            'arch-indep': 0}}
        
    def check_binary_2(self):
        self.parse_package()
        self.parse_files()
        self.control_checks()
        
    def parse_package(self):
        if self.information['control']['self'][0].has_key('architecture'):
            self.info['arch'] = self.information['control']['self'][0]['architecture']
        if self.information['control']['self'][0].has_key('source'):
            self.info['src-pkg'] = self.information['control']['self'][0]['source']
        if re.match(r'lib.*-perl$', self.pkg_name):
            self.info['module-pkg'] = 1
    def parse_files(self):
        for file in self.information['collector']('files', 'files').keys():
            path, file = os.path.splitext(file)
            if re.match(r'/usr/(lib|share)/perl/', path) and \
                self.info['src-pkg'] != 'perl' and not self.info['perl-dir']:
                self.info['perl-dir'] = 1
                self.signal_error('pkg-installs-into-perl-dir')
            if path.startswith('/usr/lib/perl5') and self.info['arch'] == \
                'all' and not self.info['wrong']['arch-dep']:
                self.info['wrong']['arch-dep'] = 1
                self.signal_error('arch-indep-should-be-u-s-p')
            if path.startswith('/usr/lib/perl5') and \
                DataValidator('arch', self.info['arch']):
                self.info['right']['arch-dep'] = 1
            if path.startswith('/usr/share/perl5') and self.info['arch'] == \
                'all':
                self.info['right']['arch-indep'] = 1
    def control_checks(self):
        if self.info['module-pkg']:
            perl_pkgs = Set(('perl', 'perl-base'))
            no_deps = 0
            if not self.information['control']['self'][0].has_key('depends'):
                no_deps = 1
            else:
                if not len(perl_pkgs.intersection(self.information['control']['self'][0]['depends'].keys())):
                    no_deps = 1
            if no_deps:
                self.signal_error('module-pkg-no-perl-dep')
            if self.info['right']['arch-indep']:
                for depends in perl_pkgs:
                    if self.information['control']['self'][0].has_key('depends'):
                        if self.information['control']['self'][0]['depends'].has_key(depends):
                            self.check_indep_depends(depends)

    def check_indep_depends(self, perl_dep):
        for perl_rel in self.information['control']['self'][0]['depends'][perl_dep]['relation']:
            if perl_rel == [None, None]:
                self.signal_error('unversioned-dep-on-perl')
            elif re.match(r'>(=|>)?', perl_rel[0]):
                ver_a = dpkgver.DpkgVersion(perl_rel[1])
                if ver_a < '5.6.0-16':
                    self.signal_error('perl-dep-not-great-enough', [perl_dep])

checks.register(PerlCheck)

