import os
from linda.parser.rfc822parser import RFC822Parser

class ChangesParser(RFC822Parser):
    def parse(self):
        self.path = os.path.split(os.path.realpath(self.file))[0]
        self.remove_signed()
        self.concat()
        self.split()
        tmp_files = []
        for x in self.data[0]['files'].split('\n'):
            if x:
                tmp_array = x.split(' ')
                tmp_files.append([tmp_array[1], tmp_array[2], tmp_array[3], \
                    tmp_array[4]])
                tmp_files[-1].append('%s/%s' % (self.path, tmp_array[-1]))
        self.data[0]['files'] = tmp_files
        del self.data[0]['changes']
        self.data[0]['description'] = self.data[0]['description'][2:]
        self.data[0]['distribution'] = self.data[0]['distribution'].split(' ')

