import os
from linda.parser.rfc822parser import RFC822Parser

class DSCParser(RFC822Parser):
    def parse(self):
        self.remove_signed()
        self.validate(('Format:', 'Source:', 'Version:'))
        if not self.data:
            raise DSCParserException, "Invalid DSC"
        self.concat()
        self.split()
        tmp_files = self.data[0]['files'].split('\n')
        self.data[0]['files'] = tmp_files[1:]
        
    def __getitem__(self, item):
        return self.data[0][item]

    def keys(self):
        return self.data[0].keys()

    def has_key(self, data):
        return self.data[0].has_key(data)

class DSCParserException(Exception):
    pass

def file_or_sym(x):
    if os.path.isfile(x) or os.path.islink(x):
        return 1
    else:
        return 0

def filter_for_src_dir(data):
    if data in ('unpacked', 'control'):
        return 0
    else:
        return 1

