class UnixPermParser:
    def __init__(self, perm):
        self._perms = [0]*4
        self.perm = perm
        self.type = '-'
        self.sanity()
        self.parse()

    def __ne__(self, other_perm):
        return_value = False
        other_permobj = UnixPermParser(other_perm)
        for comp in range(0, 4):
            if self._perms[comp] != other_permobj._perms[comp]:
                return_value = True
        return return_value
    def __eq__(self, other_perm):
        bits = 0
        other_permobj = UnixPermParser(other_perm)
        for comp in range(0, 4):
            if self._perms[comp] == other_permobj._perms[comp]:
                bits += 1
        if bits == 4:
            return True
        return False
    def __repr__(self):
        return ''.join(map(lambda x: '%s' % x, self._perms))
    def sanity(self):
        if len(self.perm) != 10:
            raise UnixPermParserException, \
                "%s isn't 10 bits long!" % self.perm
        else:
            for bit in range(0, 10):
                if bit in (1, 4, 7):
                    if self.perm[bit] not in ('r', '-'):
                        raise UnixPermParserException, \
                            "Bit %s (%s) isn't r or -" % (bit, self.perm[bit])
                elif bit in (2, 5, 8):
                    if self.perm[bit] not in ('w', '-'):
                        raise UnixPermParserException, \
                            "Bit %s (%s) isn't w or -" % (bit, self.perm[bit])
                elif bit in (3, 6, 9):
                    if self.perm[bit] not in ('x', 's', 'S', 't', 'T', '-'):
                        raise UnixPermParserException, \
                            "Bit %s (%s) isn't x, s, S, t, T or -" % (bit, \
                            self.perm[bit])
                elif bit == 0:
                    if self.perm[0] not in ('b', 'c', 'd', 'h', 'l', 'p', '-'):
                        raise UnixPermParserException, \
                            "Bit 0 (%s) isn't b, c, d, h, l, p, or -" % \
                            self.perm[0]
                    else:
                        self.type = self.perm[0]
                        
    def parse(self):
        tmp_perm = [self.perm[0], self.perm[1:4], self.perm[4:7], \
            self.perm[7:]]
        for x in range(1, 4):
            for y in tmp_perm[x]:
                if y == 'r': self._perms[x] += 4
                if y == 'w': self._perms[x] += 2
                if y == 'x': self._perms[x] += 1
                if y in ('s', 'S') and x in (1, 2):
                    if x == 1: self._perms[0] += 4
                    if x == 2: self._perms[0] += 2
                    if y == 's': self._perms[x] += 1
                if y in ('t', 'T') and x == 3:
                    self._perms[0] += 1
                if y == 't': self._perms[3] += 1

    def is_executable(self):
        executable = 0
        for perm in self._perms:
            if perm % 2:
                executable += 1
        return executable

    def is_link(self):
        if self.type == 'l':
            return True

    def is_directory(self):
        if self.type == 'd':
            return True
    
class UnixPermParserException(Exception):
    pass

