import unittest, gettext, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class ConfigFileCheckBinaryTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/config_file.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['binary'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])

    def test_conffiles(self):
        "Check the sanity of ConfigFileCheck"
        method = getattr(self.instance, 'conffiles')
        os.makedirs(os.path.join(self.instance.information['dir'], \
            'control'))
        f = open(os.path.join(self.instance.information['dir'], 'control', \
            'conffiles'), 'w')
        f.write('/etc/foobar.conf\n')
        f.close()
        method()
        self.assert_('/etc/foobar.conf' in self.instance.conf_files.keys())
        self.assertEqual(self.instance.conf_files['/etc/foobar.conf'], \
            ('/etc', 'foobar.conf'))
        self.instance.conf_files = {'etc/lala.conf': ('etc', 'lala.conf'), \
            '/usr/share/doc/lala/foo.conf': ('/usr/share/doc/lala', \
            'foo.conf')}
        method()
        conf_errors = Set(('non-etc-conffile', 'relative-conffile'))
        self.assertEqual(conf_errors.intersection(self.instance.err_dict.keys()), conf_errors)
        for key in conf_errors:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)
        self.instance.err_dict.clear()
        os.makedirs(os.path.join(self.instance.information['dir'], \
            'unpacked', 'etc'))
        f = open(os.path.join(self.instance.information['dir'], \
            'unpacked', 'etc', 'lala.conf'), 'w')
        f.close()
        self.instance.conf_files = {'/etc/lala.conf': ('/etc', 'lala.conf')}
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.conf_files = {'/etc/foobar.conf': ('/etc', \
            'foobar.conf')}
        method()
        self.assert_('etc-conffile' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'etc-conffile'), True)
        os.unlink(os.path.join(self.instance.information['dir'], \
            'unpacked', 'etc', 'lala.conf'))
        self.instance.err_dict.clear()
        self.instance.conf_files = {}
        os.symlink('../default/rcS', os.path.join(self.instance.information['dir'], \
            'unpacked', 'etc', 'symlink'))
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
