import unittest
from linda.parser.datavalidator import DataValidator

class DataValidatorTest(unittest.TestCase):
    def test_arch(self):
        "Check DataValidator arch validator works"
        self.assertEqual(DataValidator('arch', '!i386').__nonzero__(), True)
        self.assertEqual(DataValidator('arch', 'foo').__nonzero__(), False)

    def test_priority(self):
        "Check DataValidator priority validator works"
        self.assertEqual(DataValidator('priority', 'standard').__nonzero__(), \
            True)
        self.assertEqual(DataValidator('priority', 'foo').__nonzero__(), False)

    def test_section(self):
        "Check DataValidator section validator works"
        self.assertEqual(DataValidator('section', 'python').__nonzero__(), \
            True)
        self.assertEqual(DataValidator('section', 'foo').__nonzero__(), False)

    def test_essential(self):
        "Check DataValidator essential validator works"
        self.assertEqual(DataValidator('essential', 'bash').__nonzero__(), \
            True)
        self.assertEqual(DataValidator('essential', 'foo').__nonzero__(), \
            False)

    def test_none(self):
        "Check DataValidator can deal with the special object None"
        self.assertEqual(DataValidator('arch', None).__nonzero__(), True)
        self.assertEqual(DataValidator('priority', None).__nonzero__(), True)

