import unittest, tempfile, shutil
from linda.funcs import run_external_cmd
from linda.parser.override import OverrideParser, OverrideParserException
from sets import Set

class OverrideParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_override.tar.gz' % \
            self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_override(self):
        "Check parsing an overrides file"
        ovp = OverrideParser('%s/overrides' % self.dir)
        keys = Set(('binary-comment', 'binary-upx', 'binary-note'))
        self.assertEqual(keys.intersection(ovp.data.keys()), keys)
        self.assertEqual(ovp.data['binary-upx'], {})
        self.assertEqual(ovp.data['binary-comment'].keys(), ['Data'])
        self.assertEqual(ovp.data['binary-comment']['Data'], '.*')
        keys = Set(('Data', 'Type'))
        self.assertEqual(keys.intersection(ovp.data['binary-note'].keys()), \
            keys)
        self.assertEqual(ovp.data['binary-note']['Data'], '.*')
        self.assertEqual(ovp.data['binary-note']['Type'], 'Informational')

    def test_bad(self):
        "Check a bad file raises OverrideParserException"
        try:
            ovp = OverrideParser('%s/bad' % self.dir)
        except OverrideParserException:
            pass
        else:
            self.fail()

    def test_badkey(self):
        "Check a bad key raises OverrideParserException"
        try:
            ovp = OverrideParser('%s/badkey' % self.dir)
        except OverrideParserException:
            pass
        else:
            self.fail()

    def test_no_eof(self):
        "Check an overrides file missing an EOF doesn't miss one char"
        ovp = OverrideParser('%s/no-eof' % self.dir)
        self.assertEqual(ovp['executable-manual-page'].has_key('Data'), True)
        self.assertEqual(ovp['executable-manual-page']['Data'], \
            'usr/share/man/man1/ls.1.gz')

