import unittest, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class ChangesCheckChangesTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/changes.py', {'_': __builtins__['_'], 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['changes'][1]:
            self.instance = klass('/tmp', '/tmp/lala_0.0.1-1.changes', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/changes_changes.tar.gz' % \
            self.instance.information['dir'])
        self.po_keys = POFileParser('po/en.po')
        
    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])        

    def test_check_distribution(self):
        "Check check_distribution() method of ChangesCheck"
        method = getattr(self.instance, 'check_distribution')
        self.instance.changes_file = [{'distribution': \
            ['woody-proposed-updates']}]
        method()
        self.assert_('obsolete-dist' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'obsolete-dist'), True)
        self.instance.changes_file[0]['distribution'][0] = 'lala'
        method()
        self.assert_('incorrect-distribution' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'incorrect-distribution'), True)
        
    def test_calculate_md5sums_check_files(self):
        "Check check_files() method of ChangesCheck"
        self.instance.changes_file = [{'files': \
            [['f55f89424b604a2a31b3da7a040e1db0', '266', 'comm', 'extra', \
            '%s/xringd_1.20-16.dsc' % self.instance.information['dir']]]}]
        getattr(self.instance, 'calculate_md5sums')()
        method = getattr(self.instance, 'check_files')
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.changes_file[0]['files'][0][0] = 'f0f0f0'
        method()
        self.assert_('md5sum-mismatch' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'md5sum-mismatch'), True)
        self.instance.changes_file[0]['files'][0][1] = '25'
        method()
        self.assert_('file-size-mismatch' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'file-size-mismatch'), True)
        self.instance.err_dict.clear()
        self.instance.changes_file[0]['files'][0][2] = 'foo/bar'
        method()
        errors = Set(['unknown-component-changes', 'unknown-section-changes'])
        self.assertEqual(errors.intersection(self.instance.err_dict.keys()), \
            errors)
        for key in errors:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)

