import unittest
from linda.parser.unixperm import UnixPermParser, UnixPermParserException

class UnixPermParserTest(unittest.TestCase):
    def test_incorrect(self):
        'Check bad permission strings raises UnixPermParserException'
        self.assertRaises(UnixPermParserException, UnixPermParser, \
            '-rwxr-er-x')
        self.assertRaises(UnixPermParserException, UnixPermParser, \
            {})
        
    def test_correct(self):
        'Check permission string parsing works'
        unx = UnixPermParser('-rwxr-xr-x')
        self.assertEqual(unx._perms, [0, 7, 5, 5])
        unx = UnixPermParser('drwxrwS---')
        self.assertEqual(unx._perms, [2, 7, 6, 0])
        unx = UnixPermParser('lrwx------')
        self.assertEqual(unx._perms, [0, 7, 0, 0])
        for i in ('b', 'c', 'h', 'p'):
            unx = UnixPermParser('%sr--r--r--' % i)
            self.assertEqual(unx._perms, [0, 4, 4, 4])

    def test_notequal(self):
        "Check two not equal permission strings are not equal"
        unx = UnixPermParser('-rwxr-xr-x')
        self.assertEqual(unx != '-rwx-w--w-', True)

    def test_equal(self):
        "Check two equal permission strings are equal"
        unx = UnixPermParser('drwxr-xr-x')
        self.assertEqual(unx == '-rwxr-xr-x', True)

    def test_executable(self):
        "Check .is_executable() method of UnixPermParser"
        unx = UnixPermParser('-rwxr--r--')
        self.assertEqual(unx.is_executable(), True)
        unx = UnixPermParser('-rw-r--r--')
        self.assertEqual(unx.is_executable(), False)

    def test_link(self):
        "Check .is_link() method of UnixPermParser"
        unx = UnixPermParser('lrwxrwxrwx')
        self.assertEqual(unx.is_link(), True)

