#include <fstream>
#include <iostream>

using namespace std;


const int BUFSIZE = 12 * 1024;


int
hex2int(char h)
{
  if((h >= '0') && (h <= '9')) return h - '0';
  if((h >= 'a') && (h <= 'f')) return h - 'a' + 10;
  cerr << "illegal hex character '" << h << "'\n";
  exit(3);
}

int
main(int argc, char *argv[])
{
  if(argc != 3)
    {
      cerr << "usage: hex2raw <hex-file> <raw-file>\n";
      return 1;
    }

  char buf_in[BUFSIZE], buf_out[BUFSIZE / 2];

  ifstream in(argv[1]);
  ofstream out(argv[2]);

  if(!in || !out)
    {
      cerr << "file open error\n";
      return 2;
    }

  while(!in.eof())
    {
      in.read(buf_in, BUFSIZE);
      int read = in.gcount();
      int outnum = 0;

      for(int i = 0; i < read; i += 2)
	{
	  // if(i % 3 == 0) continue;
	  int d0 = hex2int(buf_in[i]);
	  int d1 = hex2int(buf_in[i + 1]);
	  buf_out[outnum++] = d0 * 16 + d1;
	}

      out.write(buf_out, outnum);
    }
}
