#!/bin/sh

VERSION=0.8.1
RELEASE=1

ARCH=$(uname -i)

if test $ARCH == i386 -o $ARCH == i686; then
    ARCH=i586  # uname and rpm disagree
fi

DIRNAME=line6usb-$VERSION
ROOT_PKG=/usr/src/packages

FILES="\
$DIRNAME/INSTALL \
$DIRNAME/Makefile \
$DIRNAME/aplay.sh \
$DIRNAME/arecord.sh \
$DIRNAME/audio.c \
$DIRNAME/audio.h \
$DIRNAME/capture.c \
$DIRNAME/capture.h \
$DIRNAME/config.h \
$DIRNAME/control.c \
$DIRNAME/control.h \
$DIRNAME/create_links.pl \
$DIRNAME/debian/changelog \
$DIRNAME/debian/compat \
$DIRNAME/debian/control \
$DIRNAME/debian/control.modules.in \
$DIRNAME/debian/copyright \
$DIRNAME/debian/rules \
$DIRNAME/debian/watch \
$DIRNAME/downsample_interpolate.patch \
$DIRNAME/driver.c \
$DIRNAME/driver.h \
$DIRNAME/dumprequest.c \
$DIRNAME/dumprequest.h \
$DIRNAME/line6_find_device.pl \
$DIRNAME/line6usb.spec \
$DIRNAME/makefile \
$DIRNAME/midi.c \
$DIRNAME/midi.h \
$DIRNAME/midibuf.c \
$DIRNAME/midibuf.h \
$DIRNAME/pcm.c \
$DIRNAME/pcm.h \
$DIRNAME/playback.c \
$DIRNAME/playback.h \
$DIRNAME/pod.c \
$DIRNAME/pod.h \
$DIRNAME/podxtpro_resample.sh \
$DIRNAME/remove_old_podxtpro_driver.sh \
$DIRNAME/retrieve_all_data.sh \
$DIRNAME/set_revision.sh \
$DIRNAME/store_all_data.sh \
$DIRNAME/toneport.c \
$DIRNAME/toneport.h \
$DIRNAME/tuner.sh \
$DIRNAME/usbdefs.h \
$DIRNAME/variax.c \
$DIRNAME/variax.h \
"

# update version and release:
./batch_replace.pl -q -e "s/( \* Line6 Linux USB driver -) .*?\n/\$1 $VERSION\n/;" "*.c,*.h"
./batch_replace.pl -q -e "s/( \* Copyright \(C\) 2004)-\d+/\$1-2009/;" "*.c,*.h"
./batch_replace.pl -q -e "s/(Version:\s*).*?\n/\${1}$VERSION\n/s;s/(Release:\s*).*?\n/\${1}$RELEASE\n/s;" line6usb.spec
./batch_replace.pl -q -e "s/#define DRIVER_VERSION .*?\n/#define DRIVER_VERSION \"$VERSION\"\n/s;" driver.c
./batch_replace.pl -q -e "s/line6usb-\d+\.\d+\.\d+\w*/line6usb-$VERSION/g;" INSTALL

# tarballs:
make clean
./create_control.pl
ln -s . $DIRNAME
tar cfjh $DIRNAME.tar.bz2 $FILES
tar cfzh $DIRNAME.tar.gz $FILES
rm $DIRNAME
mv $DIRNAME.tar.bz2 $DIRNAME.tar.gz download

# RPM:
cp download/$DIRNAME.tar.bz2 $ROOT_PKG/SOURCES
rpmbuild -ba line6usb.spec
cp $ROOT_PKG/SRPMS/$DIRNAME-$RELEASE.src.rpm download
rm -f download/$DIRNAME-$RELEASE.src.rpm.del
ln download/$DIRNAME-$RELEASE.src.rpm download/$DIRNAME-$RELEASE.src.rpm.del

# documentation:
rm -f driverdocs.pdf
make -C figures
lyx -e pdf driverdocs.lyx
