#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include "../server/srv_def.h"

#define LINESRV_CONFIG_FILE "/etc/linesrv.conf"

void print_http();
void print_err_begin();
void print_err_end();

int main(int argc, char **argv)
{
    FILE* flccfg;
    FILE* fpipe;
    FILE* fpid;
    int res;
    char line[2000];
    char dum[50];
    char val[300];
    char* pipename = NULL;
    char* pidname = NULL;
    pid_t pid = 0;
    //------- open lcs config file
    if ( !(flccfg = fopen(LINESRV_CONFIG_FILE, "r")) )
    {
        print_err_begin();
	printf("<p>LineControl Server configuration file "LINESRV_CONFIG_FILE" not found!<br>\
<font size=\"-1\">This filename is compiled in! Edit ./linesrv/htmlstatus/htmlstatus.c to get it working.</font></p>\n");
	print_err_end();
	exit(-1);
    }
    res = 0;
    while ( fgets(line, sizeof(line), flccfg) )
    {
	sscanf(line, "%s %s", dum, val);
	if ( !strcmp(dum, "pidfile") )
	    pidname = strdup(val);
	else if ( !strcmp(dum, "html_status") )
	    pipename = strdup(val);
	if ( pidname && pipename ) break;
    }
    fclose(flccfg);
    if ( !(pidname && pipename) )
    {
	print_http();
	print_err_begin();
	if ( !pidname )
	    printf("<p>You can only use htmlstatus if linesrv logs it's pid on startup to a file.<br>\
Enable this feature using '<code>pidfile <filename></code>' in your configfile.</p>\n");
	else
	    printf("<p>You can only use htmlstatus if you have enabled this feature in your configfile using 'html_status <pipename>'<br>\n\
Create the file <pipename> by doing 'mknod <pipename> p' in the console. Then restart linesrv.</p>\n");
	print_err_end();
	exit(0);
    }
    if ( !(fpid = fopen(pidname, "r")) )
    {
	print_http();
	print_err_begin();
	printf("<p>Unable to open pidfile '%s'!</p>\n", pidname);
	print_err_end();
	exit(0);
    }
    fscanf(fpid, "%d", &pid);
    fclose(fpid);
//    if ( !fork() )
//    {
//	sleep(1);
	kill(pid, SIGUSR1);
//	exit(0);
//    }
    print_http();
    fflush(stdout);
    if ( !(fpipe = fopen(pipename, "r")) )
    {
	print_err_begin();
	printf("<p>Unable to open fifo pipe '%s'!</p>\n", pipename);
	print_err_end();
	exit(0);
    }
    while ( fgets(line, 1999, fpipe) ) printf(line);
    fflush(stdout);
    fclose(fpipe);
    exit(0);
}

void print_http()
{
    printf("Content-type: text/html\n\n");
}

void print_err_begin()
{
print_http();
printf("\
<html><body bgcolor=\"#ffffff\" text=\"000080\">\n\
<p><b>ERROR:</b></p>\
");
}

void print_err_end()
{
printf("\
program terminated.\
\n</body></html>\
");
}
