#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "global_vars.h"
#include "times.h"
#include "html_status.h"

#define TABLE_WIDTH	"500"

void print_html_header(FILE* where)
{
    fprintf(where, "<html><head><style type=\"text/css\">\n\
p, table, br { align: center; font-family: Arial, Helvetica }\n\
body, td { font-family: Arial, Helvetica }\n\
A { text-decoration: none;\n\
font-style: italic;\n\
font-family: Arial, Helvetica }\n\
</style></head><body bgcolor=\"#ffffff\" text=\"000080\">\n");
    fprintf(where, "<center><p><a href=\""LC_URL"\">\
<img src=\"/lclog/lc-logo-01.gif\" width=\"246\" height=\"53\" border=\"0\"></a></p>\n\
<table width=\""TABLE_WIDTH"\" cellspacing=\"1\" cellpadding=\"2\" border=\"0\">\n");
}

void print_html_footer(FILE* where)
{
    fprintf(where, "</table>\n<p>generated by <font color=\"#0066ff\"><a href=\""LC_URL"\">"LCS_NAME" "LCS_VERSION_STR"</a></font> &copy; "LCS_COPY"</p>\n</center></body></html>\n");
}

void html_status(int sig)
{
    static const char* clt_c_discon =	"c0c0c0";
    const char* clt_c_noauth = clt_c_discon;
    static const char* clt_c_offline = 	"ff6666";
    static const char* clt_c_dialing = 	"ffff66";
    static const char* clt_c_online = 	"66ff66";
    static const char* clt_c_closing = 	"ffff66";
    static const char* clt_t_discon = 	"disconnected";
    static const char* clt_t_noauth = 	"logging in...";
    static const char* clt_t_offline = 	"offline";
    static const char* clt_t_dialing = 	"dialing...";
    static const char* clt_t_online = 	"online";
    static const char* clt_t_closing = 	"closing...";
    const char* ln_c_down = clt_c_offline;
    const char* ln_c_dialing = clt_c_dialing;
    const char* ln_c_up_server = clt_c_online;
    static const char* ln_c_up_user = 	"6699ff";
    const char* ln_c_closing = clt_c_closing;
    static const char* ln_c_locked_up_clt = "ff6600";
    static const char* ln_c_locked_up_timed = "006600";
    static const char* ln_c_locked_down = "c0c0c0";
    static const char* ln_c_close_error = "ff66ff";
    static const char* ln_t_down = "closed";
    static const char* ln_t_dialing = "dialing...";
    static const char* ln_t_up_server = "established by server";
    static const char* ln_t_up_user = "manually established";
    static const char* ln_t_closing = "closing...";
    static const char* ln_t_close_error = "unable to close (close error)";
    static const char* ln_t_locked_up_clt = "established, locked by client";
    static const char* ln_t_locked_up_timed = "established by server, timed";
    static const char* ln_t_locked_down = "disabled";
    struct client_t *who;
    struct line_t *line = (struct line_t *)lstlines.first;
    char printit = 0;
    char *str;
    const char *color, *text, *linecolor, *linetext;
    struct in_addr iaddr;
    time_t now;
    FILE* statpipe;
    
    if ( !server->html_status_pipe )
    {
		syslog(LOG_INFO, "Got SIGUSR1: specify the 'html_status <pipe name>' keyword in your configfile!");
		return;
    }
    if ( !(statpipe = fopen(server->html_status_pipe, "w")) )
    {
		syslog(LOG_INFO, "unable to write to html_status pipe '%s'.", server->html_status_pipe);
		free(server->html_status_pipe);
		server->html_status_pipe = NULL;
		return;
    }
    // ok, let's dump out the stats
    print_html_header(statpipe);
    now = time(NULL);
    fprintf(statpipe, "<tr><td colspan=\"4\">Time of status report: %s</td></tr>\n", cor_ctime(&now));
    fprintf(statpipe, "<tr><td bgcolor=\"#ffffff\" colspan=\"4\" height=\"4\"><img src=\"/lclog/hr01.gif\" width=\""TABLE_WIDTH"\" height=\"2\"></td></tr>\n");
    while ( line )
    {
		// print line header/status
		printit = 0;
		switch ( line->con_stat )
		{
		    case CST_DOWN:
				linecolor = ln_c_down;
				linetext = ln_t_down;
				break;
			case CST_DIALING:
				linecolor = ln_c_dialing;
				linetext = ln_t_dialing;
				break;
		    case CST_UP_SERVER:
				linecolor = ln_c_up_server;
				linetext = ln_t_up_server;
				printit++;
				break;
		    case CST_UP_USER:
				linecolor = ln_c_up_user;
				linetext = ln_t_up_user;
				printit++;
				break;
		    case CST_CLOSING:
				linecolor = ln_c_closing;
				linetext = ln_t_closing;
				break;
		    case CST_CLOSE_ERROR:
				linecolor = ln_c_close_error;
				linetext = ln_t_close_error;
				printit++;
				break;
		    case CST_LOCKED_UP_CLT:
				linecolor = ln_c_locked_up_clt;
				linetext = ln_t_locked_up_clt;
				printit++;
				break;
		    case CST_LOCKED_UP_TIMED:
				linecolor = ln_c_locked_up_timed;
				linetext = ln_t_locked_up_timed;
				printit++;
				break;
		    case CST_LOCKED_DOWN:
				linecolor = ln_c_locked_down;
				linetext = ln_t_locked_down;
				break;
		    default: linecolor = NULL; linetext = NULL;
		}
		fprintf(statpipe, "<tr bgcolor=\"#%s\"><td colspan=\"4\"><b>%s:</b>&nbsp;<code>%s", linecolor, line->linename, linetext);
		if ( printit )
		{
		    if ( (str = make_time(time(NULL) - line->con_up_time)) != NULL )
		    {
				fprintf(statpipe, " (%s) %u MB", str, line->bytes_recvd / (1024*1024) );
				free(str);
		    }
		}
		if ( line->baud_up && line->baud_down )
			fprintf(statpipe, "</code></td></tr>\n<tr bgcolor=\"#%s\"><td colspan=\"4\"><font size=\"-1\">[ kbit/s up: %u&nbsp;&nbsp;&nbsp;&nbsp;down: %u ]</font>",
						linecolor, line->baud_up / 1000, line->baud_down / 1000);
		fprintf(statpipe, "</code></td></tr>\n");
		// print clients of this line.
		who = (struct client_t*)cltlist.first;
		while ( who )
		{
		    if ( (who->line != line) )
		    {
				who = (struct client_t*)who->next;
				continue;
		    }
		    printit = 0;
		    switch ( who->status )
		    {
				case CLT_DISCON:
				    color = clt_c_discon;
				    text = clt_t_discon;
				    break;
				case CLT_NOAUTH:
				    color = clt_c_noauth;
				    text = clt_t_noauth;
				    break;
				case CLT_OFFLINE:
				    color = clt_c_offline;
				    text = clt_t_offline;
				    break;
				case CLT_DIALING:
				    color = clt_c_dialing;
				    text = clt_t_dialing;
				    break;
				case CLT_ONLINE:
				    color = clt_c_online;
				    text = clt_t_online;
				    printit = 1;
				    break;
				case CLT_CLOSING:
				    color = clt_c_closing;
				    text = clt_t_closing;
				    printit = 1;
				    break;
				default: color = NULL; text = NULL;
	    	}
		    fprintf(statpipe, "<tr bgcolor=\"#%s\"><td width=\"16\" bgcolor=\"#%s\">&nbsp;</td><td>%s</td><td>", color, linecolor, text);
		    if ( printit )
		    {
				if ( (str = make_time(time(NULL) - who->started)) != NULL )
				{
				    fprintf(statpipe, " (%s)", str);
				    free(str);
				}
		    }
		    else fprintf(statpipe, "&nbsp;");
		    fprintf(statpipe, "</td><td>");
		    // print name/ip-port
		    if ( who->type >= LCS_CLT_LCP3 )
				fprintf(statpipe, who->name);
		    else
		    {
				iaddr.s_addr = who->ip;
				fprintf(statpipe, "%s:%d", inet_ntoa(iaddr), ntohs(who->port));
		    }
		    fprintf(statpipe, "</td></tr>\n");
		    who = (struct client_t*)who->next;
		}
		// print a separator for the different lines
		line = (struct line_t*)line->next;
	//	if ( line )
	    fprintf(statpipe, "<tr><td bgcolor=\"#ffffff\" colspan=\"4\" height=\"4\"><img src=\"/lclog/hr01.gif\" width=\""TABLE_WIDTH"\" height=\"2\"></td></tr>\n");
    }
    print_html_footer(statpipe);
    fputc(0, statpipe);
    fflush(statpipe);
    fclose(statpipe);
}
