/*----------------

    This is the definition of LineControl Protocol version 3.x

	See minimal changelog at the end...

----------------*/

#ifndef _LCP3_H
#define _LCP3_H

#include <time.h>

/*----- COMMANDS ----------*/

/* client to server */
#define CMD3_AUTHREQ	1	// "struct t_lcp3_info_auth" appended
#define CMD3_ONLINE		2	// set line_id!!
#define CMD3_OFFLINE	3	// server ignores line_id set by client!
#define CMD3_LINESREQ	4	// client will get as many CMD3_LINE as
				// lines are available/configured
#define CMD3_STATREQ	5	// set line_id!!
#define CMD3_SHUTDOWN	6
#define CMD3_PUBKEYREQ	7	// client should get a CMD3_SRVPUBKEY
#define CMD3_LINESEL	8	// bind client to line_id. A Client
				// can't be on more than one line at
				// the same time.
#define CMD3_CHANADD    9   // add isdn channel, no info appended
#define CMD3_CHANRM     10  // remove isdn channel, no info appended
#define CMD3_REFRESH    11
// intoduced with lcp3 version 3.2:
#define CMD3_LOCK		12	// locks linestatus up / down. This cmd gets
			    // only processed if the current status is either
			    // CST_UP_SERVER or CST_DOWN
			    // applies to the line currently selected by the
			    // client
#define CMD3_UNLOCK		13	// remove the lock of the line selected by the
			    // client (with CMD3_LINESEL):
			    // CST_LOCK_UP becomes CST_UP_SERVER
			    // CST_LOCK_DOWN becomes CST_DOWN
#define CMD3_GETALL		14
#define CMD3_UNGETALL	15

/* server to client */
//#define CMD3_AUTHOK	1000	// client gets CMD3_CLIENTSTAT instead
#define CMD3_AUTHBAD	1000	// TCP connection gets dropped
#define CMD3_CLIENTSTAT	1001	// CLT_* update
#define CMD3_LINE		1002	// "struct t_lcp3_info_line" appended
#define CMD3_STATUS		1003	// "struct t_lcp3_info_status" appended
#define CMD3_INVALID	1004	// "struct t_lcp3_info_ack" appended
				// ackcmd is the not supported command
#define CMD3_ENCINFO	1005	// "struct t_lcp3_info_enckey" appended
#define CMD3_NOACCESS	1006	// "struct t_lcp3_info_ack" appended
				// ackcmd is the command which the client
				// may not use
#define CMD3_CHANFAIL   1007    // channel operation failed, no info appended

/* bidirectional */
#define CMD3_ACK		2000	// "struct t_lcp3_info_ack" appended
#define CMD3_UNREG		2001    // sent by client: disconnect from server
                            // sent by server: client got kicked

/* broadcast */
#define MIN_CBR3		3000	// commands > 4000 are CBR
#define CBR3_TPUT		3000	// "struct t_lcp3_info_tput" appended
#define CBR3_LINESTAT	3001	// CST_* update
#define CBR3_SRVDEATH   3002    // server got terminated
#define CBR3_ISDNACT	3003	// "struct t_lcp3_info_isdn" appende
				// get's sent on incoming isdn cal
				// when ISDN Watcher is enable

/*----- PACKET STRUCTS ----*/

/*
 - for each CMD3_* the receiver sends an appropriate CMD3_ACK
 - all strings are zero-terminated
 - there's no ACK for CBR3_* commands
*/

/*
 - If the server has user-accounting enabled, the client has to
   send a CMD3_AUTHREQ as first command
 - If the client then gets a CMD3_AUTHOK it may continue.
   But if it gets a CMD3_AUTHBAD the connection gets closed immediately.
*/

// int: 32 bit
// short: 16 bit
// char: 8 bit
// byte alignment: egcs style (ANSI C?)

struct t_lcp3_cmd {
    unsigned int magic;		//  4	+ 0
    unsigned int version;	//  2	+ 4
    int cmd;				//  4	+ 8
    int info_is_valid;		//  4	+12	// only filled in by server
    int client_stat;		//  4	+16	// only filled in by server
				// server ignores value filled in by client
    int line_id;			//  4	+20
    int line_stat;			//  4	+24	// only filled in by server
				// server ignores value filled in by client
    int line_channels;		//  4   +28	// only filled in by server
				// server ignores value filled in by client
};

#define LCP3_MAGICNR        654760132
#define LCP3_MIN_PROTO_VERSION	33	// a client may talk LCP3_PROTO_VERSION
				    // if it understands at least this version
					// (not understanding some commands doesn't matter
					// but the packet sizes have to be correct!)
#define LCP3_PROTO_VERSION	33	// read ## as #.#
#define LCP3_MAX_INFO_SIZE	72
#define LCP3_MAX_NAME_LEN	16
#define LCP3_MAX_PWD_LEN	LCP3_MAX_NAME_LEN
#define LCP3_MAX_ENCKEY_LEN	32
#define LCP3_CLT_TIMEOUT	80	// when server doesn't get a command
					// from clt for more than # secs then
					// clt will get kicked
#define LCP3_LINENAME_LEN	17	// # characters, inclusive 0-byte

#define LCP3_ENCTYPE_NONE	1	// plaintext passwords over the network
#define LCP3_ENCTYPE_SYM	2	// hash function
					// only passwd is encrypted (rndstr+pwd)
#define LCP3_ENCTYPE_ASYM	3	// public and secret key
					// name and passwd are both encrypted
#define LCP3_ENCTYPE_OPEN	4	// user accounting is switched off..
					// supplay empty string or so to logo

struct t_lcp3_info_auth {	// appended to a CMD3_AUTHREQ
    int enctype;
    char name[LCP3_MAX_NAME_LEN+1];
    char pass[LCP3_MAX_PWD_LEN+1];
};

struct t_lcp3_info_enckey {	// appended to a CMD3_ENCINFO
    int enctype;
    int keylen;
    char key[LCP3_MAX_ENCKEY_LEN];
};

struct t_lcp3_info_ack {	// appended to a CMD3_ACK
    int ackcmd;
};

struct t_lcp3_info_line {	// appended to a CMD3_LINE
				// the line_* entries of the lcp3_cmd data
				// correspond to the line selected by the
				// client, not to this line here!
    int total_lines;		// how many lines? (doesn't matter whether we
				// this once or 10 times... 4bytes...
				// like this the proto-change is easier
    int line_id;		// 0 is no line-ID!
	unsigned int capability_baud_up;  // maximum bits per second
	unsigned int capability_baud_down; // do.
    char linename[LCP3_LINENAME_LEN+1]; // appropriate name to line-id
};

struct t_lcp3_info_tput {	// appended to a CBR3_TPUT
    unsigned int dns;		// download of prev 3 secs in bytes per sec
    unsigned int dnl;		// average download in bytes per sec
    unsigned int dnt;		// total bytes download (in KB)
    unsigned int ups;		// as dns but upload
    unsigned int upl;		// as dnl but upload
    unsigned int upt;		// total bytes upload (in KB)
    time_t client;	// client is online for # secs now
    time_t line;	// line is up for # secs now
};

struct t_lcp3_info_status { // extended server status
    unsigned int clients;	// 2	+0	number of registered clients
    unsigned int online;	// 2	+2	num of cl. that are online
				// on any line (summarized)
};

struct t_lcp3_info_isdn {
    char caller[30];	// this one called us
    char on[20];	// he called this nr of us
    char time[9];	// xx:xx:xx
    char day[4];
    char month[4];
    char year[5];
};

#ifndef _LCP3_CPP_H
    int get_max_lcp3_pack_size();
    int get_lcp3_pack_size(int cmd);
#endif

/*----- STATUS INFOS ------*/

/* client status */
#define CLT_DISCON	1
#define CLT_NOAUTH	2	// only tcp connection
#define CLT_OFFLINE	3	// after CMD3_AUTHOK
#define CLT_DIALING	4	// after CMD3_ONLINE when line isn't already up
#define CLT_ONLINE	5	// after CMD3_ONLINE when line is established
#define CLT_CLOSING	6	// this client's closing the line

/* line status */
#define CST_DOWN	0
#define CST_DIALING	1
#define CST_UP_SERVER	2	// server called the con_up script
#define CST_UP_USER	3	// line connection wasn't established by
				// the server but is up anyway. The server
				// won't close the line!
#define CST_CLOSING	4
#define CST_CLOSE_ERROR	5	// unable to close line!!
// introduction with lcp3 version 3.2:
#define CST_LOCKED_UP_CLT 6	// this line stays established!
#define CST_LOCKED_DOWN	7	// this line stays down!
#define CST_LOCKED_UP_TIMED 8	// the line will be closed when some
				// timer times out and there are no
				// clients anymore. (Useful if you
				// pay the first half hour, then you don't
				// pay for the next half hour then you
				// pay again for half an hour and so on)

/*----- TIMEOUTS ----------*/
#define LCP3_TMO_ACK	3	// wait no more than 3 secs for an ack
				// then resend command or delete client.
#define LCP3_TMO_CNT	3	// don't try to send more than 3 times

#endif

/*------------- 	CHANGELOG -----------------
Date: YYYYMMDD
----

20010910:
	New version: 3.3
	Version minimum: 3.3
	Changes:
		- CMD3_GETALL and CMD3_UNGETALL added
		- t_lcp3_info_tput: "unsigned int" instead of "int"
		  upt, dnt: in KiloBytes, everything else remains as in Version 3.2
		- t_lcp3_info_line: added 'capability_baud_*' struct members.

------------EOF--------------*/
