/*
 * Copyright (C) 2004-2006 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _LM_UTIL_H
#define _LM_UTIL_H

#include <stdarg.h>
#include <time.h>
#include <gtk/gtk.h>

#define LM_LIST_FOREACH(var, head) \
  for ((var) = (head); (var); (var) = (var)->next)

void lm_g_object_slist_free (GSList *list);
GSList *lm_g_object_slist_copy (GSList *list);

void lm_container_create_interface (GtkContainer *container,
				    const char *filename,
				    const char *child_name,
				    const char *callback_prefix,
				    ...);

GdkPixbuf *lm_pixbuf_new (const char *filename);

void lm_thread_create (GThreadFunc func, gpointer data);

time_t lm_time (void);

void lm_tvsub (GTimeVal *out, const GTimeVal *in);

/*
 * Compares 2 timeval structs with the provided comparison operator (based
 * on timevalcmp() from FreeBSD's time.h).
 *
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#define lm_tvcmp(tv1, tv2, cmp) \
  (((tv1)->tv_sec == (tv2)->tv_sec) ?		\
   ((tv1)->tv_usec cmp (tv2)->tv_usec) :	\
   ((tv1)->tv_sec cmp (tv2)->tv_sec))

void lm_display_help (const char *link_id);

GtkWidget *lm_menu_shell_append (GtkMenuShell *shell,
				 const char *stock_id,
				 const char *mnemonic);

void lm_error_dialog (GtkWindow *parent,
		      const char *primary,
		      const char *format,
		      ...) G_GNUC_PRINTF(3, 4);
void lm_fatal_error_dialog (GtkWindow *parent,
			    const char *format,
			    ...) G_GNUC_PRINTF(2, 3) G_GNUC_NORETURN;

void lm_source_clear (unsigned int *tag);

void lm_gtk_object_ref_and_sink (GtkObject *object);

gpointer lm_g_object_connect (gpointer object,
			      gpointer instance,
			      const char *signal_spec,
			      ...);

typedef void (*LMCallbackFunc) (gpointer data);

typedef struct
{
  unsigned int		idle_id;
  LMCallbackFunc	func;
  gpointer		data;
} LMCallback;

void lm_callback_init (LMCallback *callback, LMCallbackFunc func, gpointer data);
void lm_callback_queue (LMCallback *callback);
void lm_callback_clear (LMCallback *callback);

#endif /* _LM_UTIL_H */
