/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-shell.h"

#include "lm-shell-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 37 "src/lm-shell.gob"

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <glib/gi18n.h>
#include "lm-applet.h"
#include "lm-host.h"
#include "lm-util.h"

typedef struct
{
  LMShell		*self;
  const LMSocket	*sock;
} WatchInfo;

LMShell *lm_shell = NULL;

#line 44 "lm-shell.c"
/* self casting macros */
#define SELF(x) LM_SHELL(x)
#define SELF_CONST(x) LM_SHELL_CONST(x)
#define IS_SELF(x) LM_IS_SHELL(x)
#define TYPE_SELF LM_TYPE_SHELL
#define SELF_CLASS(x) LM_SHELL_CLASS(x)

#define SELF_GET_CLASS(x) LM_SHELL_GET_CLASS(x)

/* self typedefs */
typedef LMShell Self;
typedef LMShellClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/lm-shell.gob"
static void lm_shell_init (LMShell * o);
#line 63 "lm-shell.c"
#line 0 "src/lm-shell.gob"
static void lm_shell_class_init (LMShellClass * c);
#line 66 "lm-shell.c"
#line 80 "src/lm-shell.gob"
static void lm_shell_constructor (LMShell * self);
#line 69 "lm-shell.c"
#line 98 "src/lm-shell.gob"
static void lm_shell_init_socket (LMShell * self, LMSocket * sock);
#line 72 "lm-shell.c"
#line 123 "src/lm-shell.gob"
static gboolean lm_shell_socket_watch_cb (GIOChannel * source, GIOCondition condition, gpointer data);
#line 75 "lm-shell.c"
#line 146 "src/lm-shell.gob"
static LMHost * lm_shell_get_host (LMShell * self, int host_id);
#line 78 "lm-shell.c"

enum {
	PROP_0,
	PROP_SOCKETS,
	PROP_HOST_COUNT
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_host_count lm_shell_get_host_count
#define self_init_socket lm_shell_init_socket
#define self_socket_watch_cb lm_shell_socket_watch_cb
#define self_get_host lm_shell_get_host
#define self_allocate_host_id lm_shell_allocate_host_id
#define self_deallocate_host_id lm_shell_deallocate_host_id
#define self_get_socket lm_shell_get_socket
#define self_new lm_shell_new
GType
lm_shell_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMShellClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_shell_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMShell),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_shell_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "LMShell", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMShell *)g_object_new(lm_shell_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMShell * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMShell *
GET_NEW_VARG (const char *first, ...)
{
	LMShell *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMShell *)g_object_new_valist (lm_shell_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static GObject *
___constructor (GType type, guint n_construct_properties, GObjectConstructParam *construct_properties)
{
#define __GOB_FUNCTION__ "LM:Shell::constructor"
	GObject *obj_self;
	LMShell *self;
	obj_self = G_OBJECT_CLASS (parent_class)->constructor (type, n_construct_properties, construct_properties);
	self = LM_SHELL (obj_self);
#line 80 "src/lm-shell.gob"
	lm_shell_constructor (self);
#line 151 "lm-shell.c"
	return obj_self;
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Shell::finalize"
	LMShell *self G_GNUC_UNUSED = LM_SHELL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
lm_shell_init (LMShell * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Shell::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_SHELL,LMShellPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_shell_class_init (LMShellClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Shell::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LMShellPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	g_object_class->constructor = ___constructor;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("sockets" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_SOCKETS,
		param_spec);
	param_spec = g_param_spec_int
		("host_count" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 G_MININT /* minimum */,
		 G_MAXINT /* maximum */,
		 0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_HOST_COUNT,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Shell::set_property"
{
	LMShell *self G_GNUC_UNUSED;

	self = LM_SHELL (object);

	switch (property_id) {
	case PROP_SOCKETS:
		{
#line 60 "src/lm-shell.gob"
self->_priv->sockets = g_value_get_pointer (VAL);
#line 231 "lm-shell.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Shell::get_property"
{
	LMShell *self G_GNUC_UNUSED;

	self = LM_SHELL (object);

	switch (property_id) {
	case PROP_SOCKETS:
		{
#line 60 "src/lm-shell.gob"
g_value_set_pointer (VAL, self->_priv->sockets);
#line 262 "lm-shell.c"
		}
		break;
	case PROP_HOST_COUNT:
		{
#line 69 "src/lm-shell.gob"

      int count = 0;
      int i;

      for (i = 0; i < G_N_ELEMENTS(selfp->hosts); i++)
	if (selfp->hosts[i])
	  count++;

      g_value_set_int(VAL, count);
    
#line 278 "lm-shell.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 69 "src/lm-shell.gob"
gint 
lm_shell_get_host_count (LMShell * self)
{
#line 299 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::get_host_count"
{
#line 67 "src/lm-shell.gob"
		gint val; g_object_get (G_OBJECT (self), "host_count", &val, NULL); return val;
}}
#line 305 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 80 "src/lm-shell.gob"
static void 
lm_shell_constructor (LMShell * self)
{
#line 312 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::constructor"
{
#line 81 "src/lm-shell.gob"
	
    GSList *l;

    g_assert(lm_shell == NULL);

    lm_shell = self;
    lm_add_weak_pointer(&lm_shell);

    /* unique identifier for our ICMP packets */
    self->icmp_ident = getpid() & 0xffff;

    LM_LIST_FOREACH(l, selfp->sockets)
      self_init_socket(self, l->data);

    self->tooltips = lm_tooltips_new();
  }}
#line 332 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 98 "src/lm-shell.gob"
static void 
lm_shell_init_socket (LMShell * self, LMSocket * sock)
{
#line 339 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::init_socket"
#line 98 "src/lm-shell.gob"
	g_return_if_fail (self != NULL);
#line 98 "src/lm-shell.gob"
	g_return_if_fail (LM_IS_SHELL (self));
#line 98 "src/lm-shell.gob"
	g_return_if_fail (sock != NULL);
#line 347 "lm-shell.c"
{
#line 100 "src/lm-shell.gob"
	
    if (! sock->init_error)
      {
	int flags;

	flags = fcntl(sock->desc, F_GETFL, 0);
	if (fcntl(sock->desc, F_SETFL, flags | O_NONBLOCK) < 0)
	  sock->init_error = g_strdup_printf(_("unable to set O_NONBLOCK flag: %s"), g_strerror(errno));
	else
	  {
	    GIOChannel *channel;
	    WatchInfo *info;

	    info = g_new0(WatchInfo, 1);
	    info->self = self;
	    info->sock = sock;

	    channel = g_io_channel_unix_new(sock->desc);
	    g_io_add_watch_full(channel, G_PRIORITY_HIGH, G_IO_IN, self_socket_watch_cb, info, NULL);
	  }
      }
  }}
#line 372 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 123 "src/lm-shell.gob"
static gboolean 
lm_shell_socket_watch_cb (GIOChannel * source, GIOCondition condition, gpointer data)
{
#line 379 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::socket_watch_cb"
{
#line 125 "src/lm-shell.gob"
	
    WatchInfo *info = data;
    Self *self = info->self;
    LMICMPReply reply;

    if (lm_icmp_reply_get(info->sock, &reply))
      {
	LMHost *host;

	host = self_get_host(self, reply.host_id);
	if (host)
	  {
	    GDK_THREADS_ENTER();
	    lm_host_reply_received(host, &reply);
	    GDK_THREADS_LEAVE();
	  }
      }

    return TRUE;		/* keep source */
  }}
#line 403 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 146 "src/lm-shell.gob"
static LMHost * 
lm_shell_get_host (LMShell * self, int host_id)
{
#line 410 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::get_host"
#line 146 "src/lm-shell.gob"
	g_return_val_if_fail (self != NULL, (LMHost * )0);
#line 146 "src/lm-shell.gob"
	g_return_val_if_fail (LM_IS_SHELL (self), (LMHost * )0);
#line 146 "src/lm-shell.gob"
	g_return_val_if_fail (host_id >= 0, (LMHost * )0);
#line 146 "src/lm-shell.gob"
	g_return_val_if_fail (host_id < LM_MAX_HOSTS, (LMHost * )0);
#line 420 "lm-shell.c"
{
#line 148 "src/lm-shell.gob"
	
    return selfp->hosts[host_id];
  }}
#line 426 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 152 "src/lm-shell.gob"
int 
lm_shell_allocate_host_id (LMShell * self, LMHost * host)
{
#line 433 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::allocate_host_id"
#line 152 "src/lm-shell.gob"
	g_return_val_if_fail (self != NULL, (int )0);
#line 152 "src/lm-shell.gob"
	g_return_val_if_fail (LM_IS_SHELL (self), (int )0);
#line 152 "src/lm-shell.gob"
	g_return_val_if_fail (host != NULL, (int )0);
#line 152 "src/lm-shell.gob"
	g_return_val_if_fail (LM_IS_HOST (host), (int )0);
#line 443 "lm-shell.c"
{
#line 154 "src/lm-shell.gob"
	
    int host_id;

    for (host_id = 0; host_id < G_N_ELEMENTS(selfp->hosts); host_id++)
      if (! selfp->hosts[host_id])
	{
	  selfp->hosts[host_id] = host;
	  g_object_notify(G_OBJECT(self), "host-count");
	  return host_id;
	}

    g_assert_not_reached();
    return -1;
  }}
#line 460 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 169 "src/lm-shell.gob"
void 
lm_shell_deallocate_host_id (LMShell * self, int host_id)
{
#line 467 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::deallocate_host_id"
#line 169 "src/lm-shell.gob"
	g_return_if_fail (self != NULL);
#line 169 "src/lm-shell.gob"
	g_return_if_fail (LM_IS_SHELL (self));
#line 473 "lm-shell.c"
{
#line 171 "src/lm-shell.gob"
	
    g_return_if_fail(selfp->hosts[host_id] != NULL);

    selfp->hosts[host_id] = NULL;
    g_object_notify(G_OBJECT(self), "host-count");
  }}
#line 482 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 178 "src/lm-shell.gob"
const LMSocket * 
lm_shell_get_socket (LMShell * self, int domain)
{
#line 489 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::get_socket"
#line 178 "src/lm-shell.gob"
	g_return_val_if_fail (self != NULL, (const LMSocket * )0);
#line 178 "src/lm-shell.gob"
	g_return_val_if_fail (LM_IS_SHELL (self), (const LMSocket * )0);
#line 495 "lm-shell.c"
{
#line 180 "src/lm-shell.gob"
	
    GSList *l;

    LM_LIST_FOREACH(l, selfp->sockets)
      {
	const LMSocket *sock = l->data;

	if (sock->domain == domain)
	  return sock;
      }

    return NULL;
  }}
#line 511 "lm-shell.c"
#undef __GOB_FUNCTION__

#line 194 "src/lm-shell.gob"
LMShell * 
lm_shell_new (GSList * sockets)
{
#line 518 "lm-shell.c"
#define __GOB_FUNCTION__ "LM:Shell::new"
{
#line 196 "src/lm-shell.gob"
	
    return GET_NEW_VARG(LM_SHELL_PROP_SOCKETS(sockets), NULL);
  }}
#line 525 "lm-shell.c"
#undef __GOB_FUNCTION__
