/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Copyright (c)1998-1999 Jean-Marc Jacquet <jm@littleigloo.org>  
 * Little Igloo Org  http://www.LittleIgloo.org
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include "protos.h"


static char rc_path[2048];
static GtkWidget *rc_window;
static GtkWidget *rc_spin;
static GtkWidget *rc_quote;
static GtkWidget *rc_header;
static GtkWidget *rc_dhost;
static GtkWidget *rc_samba_username;
static GtkWidget *rc_samba_nbiosname;
static GtkWidget *rc_samba_misc;

static GtkWidget *rc_check_auto_iconify;
static GtkWidget *rc_check_self_send;
static GtkWidget *rc_check_confirm;
static GtkWidget *rc_check_wrap_to_first;

static char check_flag = 0;



void
save_geom (void)
{
  gdk_window_get_size (window->window, &user_rc.win_w, &user_rc.win_h);
  gdk_window_get_origin (window->window, &user_rc.win_x, &user_rc.win_y);
  save_rc ();
}


void
reset_geom (void)
{
  user_rc.win_w = 0;
  user_rc.win_h = 0;
  user_rc.win_x = 0;
  user_rc.win_y = 0;

  save_rc ();

  gtk_window_set_default_size (GTK_WINDOW (window), MAIN_WIDTH, MAIN_HEIGHT);

}


void
save_rc (void)
{
  int file_handle;
  char errbuf[256];
  errno = 0;

  if ((file_handle = open (rc_path, O_CREAT | O_TRUNC | O_WRONLY, RC_PERM)) == -1)
    {
      sprintf (errbuf, "%s open error: %s", rc_path, strerror (errno));
      alert_ok ("RC Save Error", errbuf, "Ok");
      return;
    }

  if (write (file_handle, &user_rc, sizeof (user_rc)) == -1)
    {
      sprintf (errbuf, "%s write error: %s", rc_path, strerror (errno));
      alert_ok ("RC Save Error", errbuf, "Ok");
    }

  close (file_handle);
  return;
}


static void
create_rc (void)
{
  char *ptr;
  memset (&user_rc, 0, sizeof (user_rc));

  version (user_rc.version);
  user_rc.toolbar_style = GTK_TOOLBAR_BOTH;
  user_rc.message_check_interval = 2000;
  user_rc.hcolors = TRUE;
  user_rc.quote = '|';
  strcpy (user_rc.quote_string, "USER on HOST wrote :");
  user_rc.quoted_text_col.red = 0x8000;
  user_rc.quoted_text_col.green = 0;
  user_rc.quoted_text_col.blue = 0;
  user_rc.deliver = GUESS;


  strcpy (user_rc.guess_adr, "?");

  if ((ptr = getenv ("HOSTNAME")) == NULL)
    {
      compile_host (user_rc.deliver_adr);
    }
  else
    {
      strcpy (user_rc.deliver_adr, ptr);
      strcpy (user_rc.samba_nbiosname, ptr);
    }

  if ((ptr = strchr (user_rc.deliver_adr, '.')) != NULL)
    *ptr = 0;
  if ((ptr = strchr (user_rc.samba_nbiosname, '.')) != NULL)
    *ptr = 0;


  if ((ptr = getenv ("USERNAME")) != NULL)
    {
      strcpy (user_rc.samba_username, ptr);
      strupr (user_rc.samba_username);
    }

  user_rc.samba_warn = FALSE;
  user_rc.auto_iconify = TRUE;
  user_rc.self_send = FALSE;
  user_rc.confirm = TRUE;
  user_rc.wrap_to_first = TRUE;
}



static void
read_rc (void)
{
  int file_handle;
  char this_version[6];
  version (this_version);
  file_handle = open (rc_path, O_RDONLY, RC_PERM);
  read (file_handle, &user_rc, sizeof (user_rc));
  close (file_handle);
}



void
init_rc (void)
{
  char *p;
  if (!(p = getenv ("HOME")))
    fatal_error (2, "HOME");
  sprintf (rc_path, "%s/.linpopuprc", p);

  create_rc ();

  if (access (rc_path, F_OK))
    save_rc ();
  else
    read_rc ();
}




static void
toolbar_set_style (GtkWidget * widget, GtkToolbarStyle style)
{
  gtk_toolbar_set_style (GTK_TOOLBAR (main_toolbar), style);
  user_rc.toolbar_style = style;
}

static void
icons_set_colors (GtkWidget * widget, char IS_HEIGHT)
{
  user_rc.hcolors = IS_HEIGHT;
}

static void
check_set_interval (GtkWidget * widget, char MUST_CHECK)
{
  (check_flag = MUST_CHECK) ? gtk_widget_show (rc_spin) : gtk_widget_hide (rc_spin);
}

static void
reply_set_adr (GtkWidget * widget, char deliver)
{
  user_rc.deliver = deliver;
}



static void
custom_ok (GtkWidget * widget)
{
  if (check_flag)
    user_rc.message_check_interval = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (rc_spin)) * 1000;
  else
    user_rc.message_check_interval = 0;

  user_rc.quote = *gtk_entry_get_text (GTK_ENTRY (rc_quote));
  strcpy (user_rc.quote_string, gtk_entry_get_text (GTK_ENTRY (rc_header)));
  strcpy (user_rc.deliver_adr, gtk_entry_get_text (GTK_ENTRY (rc_dhost)));
  strcpy (user_rc.samba_username, gtk_entry_get_text (GTK_ENTRY (rc_samba_username)));
  strcpy (user_rc.samba_nbiosname, gtk_entry_get_text (GTK_ENTRY (rc_samba_nbiosname)));
  strcpy (user_rc.samba_misc, gtk_entry_get_text (GTK_ENTRY (rc_samba_misc)));

  user_rc.confirm = GTK_TOGGLE_BUTTON (rc_check_confirm)->active;
  user_rc.self_send = GTK_TOGGLE_BUTTON (rc_check_self_send)->active;
  user_rc.auto_iconify = GTK_TOGGLE_BUTTON (rc_check_auto_iconify)->active;
  user_rc.wrap_to_first = GTK_TOGGLE_BUTTON (rc_check_wrap_to_first)->active;


  save_rc ();
  gtk_widget_destroy (rc_window);
}



static void
custom_cancel (GtkWidget * widget)
{
  read_rc ();
  toolbar_set_style (widget, user_rc.toolbar_style);
  gtk_widget_destroy (rc_window);
}


static void
custom_reset (GtkWidget * widget)
{
  create_rc ();
  toolbar_set_style (widget, user_rc.toolbar_style);
  gtk_widget_destroy (rc_window);
  custom_notebook ();
}



void
custom_notebook (void)
{
  GtkWidget *rc_table;
  GtkWidget *rc_notebook;
  GtkWidget *rc_vbox;
  GtkWidget *rc_hbox;
  GtkWidget *rc_hbbox;
  GtkWidget *rc_frame;
  GtkWidget *rc_frame_table;
  GtkWidget *rc_radio_text;
  GtkWidget *rc_radio_icons;
  GtkWidget *rc_radio_both;
  GtkWidget *rc_radio_check;
  GtkWidget *rc_radio_never;
  GtkWidget *rc_radio_hcolors;
  GtkWidget *rc_radio_mcolors;
  GtkWidget *rc_radio_default;
  GtkWidget *rc_radio_guess;
  GtkWidget *rc_radio_blank;
  GtkWidget *rc_label;
  GtkWidget *rc_button_ok;
  GtkWidget *rc_button_cancel;
  GtkWidget *rc_button_reset;
  GtkObject *rc_adj;

  gint check_interval;
  char quote[2];
  gint x, y;



  /* -- create the window and place it -- */
  rc_window = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_widget_set_usize (GTK_WIDGET (rc_window), 400, 375);
  gtk_widget_realize (rc_window);
  gtk_window_set_title (GTK_WINDOW (rc_window), "Preferences");
  gdk_window_get_origin (window->window, &x, &y);
  gtk_widget_set_uposition (rc_window, x, y);
  gtk_window_set_transient_for (GTK_WINDOW (rc_window), GTK_WINDOW (window));
  gtk_signal_connect (GTK_OBJECT (rc_window), "delete_event", GTK_SIGNAL_FUNC (custom_cancel), NULL);

  rc_frame = gtk_frame_new (NULL);
  gtk_widget_show (rc_frame);
  gtk_container_add (GTK_CONTAINER (rc_window), rc_frame);
  gtk_frame_set_shadow_type (GTK_FRAME (rc_frame), GTK_SHADOW_OUT);

  /* -- a table to pack widgets -- */
  rc_table = gtk_table_new (15, 17, FALSE);
  gtk_container_add (GTK_CONTAINER (rc_frame), rc_table);
  gtk_container_border_width (GTK_CONTAINER (rc_table), 5);

  /* -- Create a new notebook, and pack it to the table -- */
  rc_notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (rc_notebook), GTK_POS_TOP);
  gtk_table_attach (GTK_TABLE (rc_table), rc_notebook, 0, 15, 0, 16, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 5);
  gtk_widget_show (rc_notebook);





  /* -- Messages  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);


  /* -- Check interval frame -- */
  rc_frame = create_frame (rc_vbox, " *Check for incoming messages :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 80);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_check = gtk_radio_button_new_with_label (NULL, "Every ... second(s)");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_check, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_check);

  rc_radio_never = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_check)), "Never");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_never, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_never);

  if (user_rc.message_check_interval)
    check_interval = (guint32) user_rc.message_check_interval / 1000;
  else
    check_interval = 2;

  rc_adj = gtk_adjustment_new (check_interval, 1, 10, 1, 0, 0);
  rc_spin = gtk_spin_button_new (GTK_ADJUSTMENT (rc_adj), 0, 0);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (rc_spin), GTK_UPDATE_ALWAYS);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_spin, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_spin);

  gtk_signal_connect (GTK_OBJECT (rc_radio_check), "clicked", GTK_SIGNAL_FUNC (check_set_interval), GINT_TO_POINTER (TRUE));
  gtk_signal_connect (GTK_OBJECT (rc_radio_never), "clicked", GTK_SIGNAL_FUNC (check_set_interval), GINT_TO_POINTER (FALSE));


  if (!user_rc.message_check_interval)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_never), TRUE);
      check_flag = FALSE;
    }
  else
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_check), TRUE);
      check_flag = TRUE;
    }

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);



  /* -- Reply frame -- */
  rc_frame = create_frame (rc_vbox, " Reply :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 80);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);

  rc_label = gtk_label_new ("Quote character :");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  sprintf (quote, "%c", user_rc.quote);

  rc_quote = gtk_entry_new_with_max_length (1);
  gtk_entry_set_text (GTK_ENTRY (rc_quote), quote);
  gtk_entry_set_editable (GTK_ENTRY (rc_quote), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_quote, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_quote);


  rc_label = gtk_label_new ("Reply Header :");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  rc_header = gtk_entry_new_with_max_length (50);
  gtk_entry_set_text (GTK_ENTRY (rc_header), user_rc.quote_string);
  gtk_entry_set_editable (GTK_ENTRY (rc_header), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_header, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_header);


  /* -- host frame -- */

  rc_frame = create_frame (rc_vbox, " Delivery address :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 100);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);
  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);


  rc_radio_default = gtk_radio_button_new_with_label (NULL, "Use default host :");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_default, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_default);

  rc_radio_guess = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_default)), "Guess");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_guess, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_guess);

  rc_radio_blank = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_default)), "Leave blank");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_blank, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_blank);


  rc_dhost = gtk_entry_new_with_max_length (100);
  gtk_entry_set_text (GTK_ENTRY (rc_dhost), user_rc.deliver_adr);
  gtk_entry_set_editable (GTK_ENTRY (rc_dhost), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_dhost, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 10, 0);
  gtk_widget_show (rc_dhost);

  gtk_signal_connect (GTK_OBJECT (rc_radio_default), "clicked", GTK_SIGNAL_FUNC (reply_set_adr), GINT_TO_POINTER (DHOST));
  gtk_signal_connect (GTK_OBJECT (rc_radio_blank), "clicked", GTK_SIGNAL_FUNC (reply_set_adr), GINT_TO_POINTER (BLANK));
  gtk_signal_connect (GTK_OBJECT (rc_radio_guess), "clicked", GTK_SIGNAL_FUNC (reply_set_adr), GINT_TO_POINTER (GUESS));


  switch (user_rc.deliver)
    {
    case DHOST:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_default), TRUE);
      break;
    case BLANK:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_blank), TRUE);
      break;
    default:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_guess), TRUE);
    }


  rc_label = gtk_label_new (" Messages        ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);






  /* -- Samba settings  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);


  /* -- Identity frame -- */
  rc_frame = create_frame (rc_vbox, " Identity :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 80);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);
  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);

  rc_label = gtk_label_new ("User Name :");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  rc_samba_username = gtk_entry_new_with_max_length (sizeof (user_rc.samba_username) - 1);
  gtk_entry_set_text (GTK_ENTRY (rc_samba_username), user_rc.samba_username);
  gtk_entry_set_editable (GTK_ENTRY (rc_samba_username), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_samba_username, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_samba_username);


  rc_label = gtk_label_new ("Host Name :");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  rc_samba_nbiosname = gtk_entry_new_with_max_length (sizeof (user_rc.samba_nbiosname) - 1);
  gtk_entry_set_text (GTK_ENTRY (rc_samba_nbiosname), user_rc.samba_nbiosname);
  gtk_entry_set_editable (GTK_ENTRY (rc_samba_nbiosname), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_samba_nbiosname, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_samba_nbiosname);



  /* -- misc frame -- */
  rc_frame = create_frame (rc_vbox, " Arguments :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 80);

  rc_frame_table = gtk_table_new (2, 5, FALSE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  gtk_container_add (GTK_CONTAINER (rc_frame), rc_frame_table);
  gtk_widget_show (rc_frame_table);

  rc_label = gtk_label_new ("Optional :   ");
  gtk_misc_set_alignment (GTK_MISC (rc_label), 0, 0);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_label, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_label);

  rc_samba_misc = gtk_entry_new_with_max_length (sizeof (user_rc.samba_misc) - 1);
  gtk_entry_set_text (GTK_ENTRY (rc_samba_misc), user_rc.samba_misc);
  gtk_entry_set_editable (GTK_ENTRY (rc_samba_misc), 1);
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_samba_misc, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_samba_misc);


  rc_label = gtk_label_new (" Samba Settings  ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);







  /* -- Toolbar properties  page -- */
  rc_vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (rc_vbox), 5);
  gtk_widget_show (rc_vbox);


  /* -- Options Frame -- */
  rc_frame = create_frame (rc_vbox, " Options :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 140);

  rc_hbox = v_box (rc_frame, TRUE, 10, 15);

  rc_check_confirm = gtk_check_button_new_with_label ("Delivery confirmation");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_check_confirm), user_rc.confirm);
  gtk_box_pack_start (GTK_BOX (rc_hbox), rc_check_confirm, FALSE, TRUE, 0);
  gtk_widget_show (rc_check_confirm);

  rc_check_wrap_to_first = gtk_check_button_new_with_label ("Read wrap-around, last message to first");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_check_wrap_to_first), user_rc.wrap_to_first);
  gtk_box_pack_start (GTK_BOX (rc_hbox), rc_check_wrap_to_first, FALSE, TRUE, 0);
  gtk_widget_show (rc_check_wrap_to_first);

  rc_check_self_send = gtk_check_button_new_with_label ("Copy all messages to self");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_check_self_send), user_rc.self_send);
  gtk_box_pack_start (GTK_BOX (rc_hbox), rc_check_self_send, FALSE, TRUE, 0);
  gtk_widget_show (rc_check_self_send);

  rc_check_auto_iconify = gtk_check_button_new_with_label ("Auto-iconify on last deleted message");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_check_auto_iconify), user_rc.auto_iconify);
  gtk_box_pack_start (GTK_BOX (rc_hbox), rc_check_auto_iconify, FALSE, TRUE, 0);
  gtk_widget_show (rc_check_auto_iconify);


  rc_frame = create_frame (rc_vbox, " Toolbar :  ", FALSE, FALSE, GTK_SHADOW_ETCHED_IN);
  gtk_widget_set_usize (rc_frame, 350, 100);

  rc_hbox = h_box (rc_frame, TRUE, 0, 0);


  /* -- The view Frame -- */
  rc_frame_table = gtk_table_new (1, 3, TRUE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_both = gtk_radio_button_new_with_label (NULL, "Icons and text");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_both, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 20, 0);
  gtk_widget_show (rc_radio_both);

  rc_radio_icons = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_both)), "Icons only");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_icons, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 20, 0);
  gtk_widget_show (rc_radio_icons);

  rc_radio_text = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_both)), "Text only");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_text, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 20, 0);
  gtk_widget_show (rc_radio_text);

  gtk_signal_connect (GTK_OBJECT (rc_radio_both), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_BOTH));
  gtk_signal_connect (GTK_OBJECT (rc_radio_icons), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_ICONS));
  gtk_signal_connect (GTK_OBJECT (rc_radio_text), "clicked", GTK_SIGNAL_FUNC (toolbar_set_style), GINT_TO_POINTER (GTK_TOOLBAR_TEXT));

  switch (user_rc.toolbar_style)
    {
    case GTK_TOOLBAR_TEXT:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_text), TRUE);
      break;
    case GTK_TOOLBAR_ICONS:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_icons), TRUE);
      break;
    default:
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_both), TRUE);
    }

  gtk_box_pack_start (GTK_BOX (rc_hbox), rc_frame_table, FALSE, TRUE, 0);
  gtk_widget_show (rc_frame_table);



  /* -- the icons default frame -- */

  rc_frame_table = gtk_table_new (1, 3, TRUE);
  gtk_container_border_width (GTK_CONTAINER (rc_frame_table), 5);

  rc_radio_hcolors = gtk_radio_button_new_with_label (NULL, "High colors icons set");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_hcolors, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_hcolors);

  rc_radio_mcolors = gtk_radio_button_new_with_label (gtk_radio_button_group (GTK_RADIO_BUTTON (rc_radio_hcolors)), "16 colors icons set");
  gtk_table_attach (GTK_TABLE (rc_frame_table), rc_radio_mcolors, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 30, 0);
  gtk_widget_show (rc_radio_mcolors);

  gtk_box_pack_start (GTK_BOX (rc_hbox), rc_frame_table, FALSE, TRUE, 0);
  gtk_widget_show (rc_frame_table);

  gtk_signal_connect (GTK_OBJECT (rc_radio_hcolors), "clicked", GTK_SIGNAL_FUNC (icons_set_colors), GINT_TO_POINTER (TRUE));
  gtk_signal_connect (GTK_OBJECT (rc_radio_mcolors), "clicked", GTK_SIGNAL_FUNC (icons_set_colors), GINT_TO_POINTER (FALSE));

  if (user_rc.hcolors)
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_hcolors), TRUE);
  else
    gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (rc_radio_mcolors), TRUE);


  rc_label = gtk_label_new (" General Options ");
  gtk_notebook_append_page (GTK_NOTEBOOK (rc_notebook), rc_vbox, rc_label);










  /* -- and here are the 3 buttons "DONE"   "CANCEL" and "RESET"-- */
  rc_hbbox = gtk_hbutton_box_new ();
  gtk_button_box_set_layout (GTK_BUTTON_BOX (rc_hbbox), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (rc_hbbox), 5);

  gtk_table_attach (GTK_TABLE (rc_table), rc_hbbox, 0, 15, 16, 17, GTK_FILL, GTK_FILL | GTK_EXPAND, 0, 0);

  rc_button_ok = box_button (rc_hbbox, "Done");
  rc_button_cancel = box_button (rc_hbbox, "Cancel");
  rc_button_reset = box_button (rc_hbbox, "Reset");

  gtk_signal_connect (GTK_OBJECT (rc_button_ok), "clicked", GTK_SIGNAL_FUNC (custom_ok), NULL);
  gtk_signal_connect (GTK_OBJECT (rc_button_cancel), "clicked", GTK_SIGNAL_FUNC (custom_cancel), NULL);
  gtk_signal_connect (GTK_OBJECT (rc_button_reset), "clicked", GTK_SIGNAL_FUNC (custom_reset), NULL);

  gtk_widget_show (rc_hbbox);
  gtk_widget_show (rc_table);


  gtk_widget_show (rc_window);
}

/* EOF */
