/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Copyright (c)1998-2000 Jean-Marc Jacquet <jm@littleigloo.org>  
 * Little Igloo Org  http://www.LittleIgloo.org
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtkstyle.h>
#include "protos.h"



void
clear_text (GtkWidget * this_text)
{
  gtk_text_freeze (GTK_TEXT (this_text));
  gtk_text_backward_delete (GTK_TEXT (this_text), gtk_text_get_length (GTK_TEXT (this_text)));
  gtk_text_thaw (GTK_TEXT (this_text));
}



void
realize_text (GtkWidget * this_text, gpointer data)
{
  gtk_text_freeze (GTK_TEXT (this_text));
  gtk_text_insert (GTK_TEXT (this_text), NULL, &this_text->style->black, NULL, data, -1);
  gtk_text_thaw (GTK_TEXT (this_text));
}



void
text_copy_to_clipboard (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_copy_clipboard (GTK_EDITABLE (this_text));
}


void
text_cut_to_clipboard (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_cut_clipboard (GTK_EDITABLE (this_text));
}


void
text_paste_from_clipboard (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_paste_clipboard (GTK_EDITABLE (this_text));
}


void
text_select_all (GtkWidget * widget, GtkWidget * this_text)
{
  gtk_editable_select_region (GTK_EDITABLE (this_text), 0, gtk_text_get_length (GTK_TEXT (this_text)));
}





void
create_text_area (GtkWidget * this_text, GtkWidget * vbox)
{
  GtkWidget *table;
  //GtkWidget *hscrollbar;
  GtkWidget *vscrollbar;
  static GdkColor text_bg = { 0, 0xffec, 0xffec, 0xffec };
  GtkStyle *style;

  table = gtk_table_new (2, 2, FALSE);

  gtk_table_attach (GTK_TABLE (table), this_text, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
  gtk_widget_show (this_text);

  style = gtk_style_new ();
  style->base[GTK_STATE_NORMAL] = text_bg;
  gtk_widget_set_style (GTK_WIDGET (this_text), style);

/*
   hscrollbar = gtk_hscrollbar_new (GTK_TEXT (this_text)->hadj);
   gtk_table_attach (GTK_TABLE (table), hscrollbar, 0, 1, 1, 2,
   GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);
   gtk_widget_show (hscrollbar);
 */
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (this_text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1, GTK_FILL, GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
  gtk_widget_show (vscrollbar);

  gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
  gtk_widget_show (table);

}

/* EOF */
