/***************************************************************************
                          cpskdemodulator.cpp  -  description
                             -------------------
    begin                : Sat Jun 2 2001
    copyright            : (C) 2001 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/




#include "cpskdemodulator.h"
#include "fircoeffs.h"
#include "psktable.h"


//define the PSK31 symbols
#define SYM_NOCHANGE 0	//Stay the same phase
#define SYM_P90 1		//Plus 90  deg
#define SYM_P180 2		//Plus 180 deg
#define SYM_M90 3		//Minus 90 deg

// phase wraparound correction table for viterbi decoder
const double AngleTbl1[4] = { 3.0*PI2/4.0, 0.0, PI2/4.0, PI2/2.0};
const double AngleTbl2[4] = { 3.0*PI2/4.0, PI2, PI2/4.0, PI2/2.0 };


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPskDemodulator::CPskDemodulator(): CDemodulator()
{
	m_pQue1 = NULL;
	m_pQue2 = NULL;
	m_pQue3 = NULL;
	m_VaricodeDecTbl = NULL;
}

CPskDemodulator::~CPskDemodulator()
{
	if(m_pQue1)
		delete m_pQue1;
	if(m_pQue2)
		delete m_pQue2;
	if(m_pQue3)
		delete m_pQue3;
	if(m_VaricodeDecTbl)
		delete m_VaricodeDecTbl;

}

/////////////////////////////////////////////////////////////////
//       Initialize PskDet buffers and pointers
/////////////////////////////////////////////////////////////////
bool CPskDemodulator::Init( double Fs, int BlockSize )
{
unsigned short int wTemp;
int i;
//circular delay lines.(data stays put and the pointers move)
	if( (m_pQue1 = new double_complex[sizeof(double_complex)*DEC3_LPFIR_LENGTH] ) == NULL)
		return false;
	if( (m_pQue2 = new double_complex[sizeof(double_complex)*DEC3_LPFIR_LENGTH] ) == NULL)
		return false;
	if( (m_pQue3 = new double_complex[sizeof(double_complex)*BITFIR_LENGTH] ) == NULL)
		return false;
	if( (	m_VaricodeDecTbl = new unsigned char[sizeof(unsigned char)*2048] )== NULL)
		return false;
	for(int i=0; i<DEC3_LPFIR_LENGTH; i++)
	{
	// fill delay buffer with zero
		m_pQue1[i] = double_complex(0.0,0.0);
	}
	for(i=0; i<DEC3_LPFIR_LENGTH; i++)
	{
	// fill delay buffer with zero
		m_pQue2[i] = double_complex(0.0,0.0);

	}
	for( i=0; i<BITFIR_LENGTH; i++)
	{
	// fill delay buffer with zero
		m_pQue3[i] = double_complex(0.0,0.0);
	}

	for( int j=0; j<2048; j++)		//init inverse varicode lookup decoder table
	{
		m_VaricodeDecTbl[j] = 0;
		for(int i=0; i<256;i++)

		{
			wTemp = VARICODE_TABLE[i];
			wTemp >>= 4;
			while( !(wTemp&1) )
				wTemp >>= 1;
			wTemp >>= 1;
			if( wTemp == j)
				m_VaricodeDecTbl[j] = (unsigned char)i;
		}
	}
	m_pInPtr1 = m_pQue1;		//initialize que ptrs
	m_pInPtr2 = m_pQue2;
	m_pInPtr3 = m_pQue3;
	m_Fs = Fs;					//sample rate
	m_BlockSize = BlockSize;	//size data input buffer
	m_phzinc = 1000.0*PI2/m_Fs;	
	m_BitPhaseInc = 9.0/m_Fs;		//bit oversampling period
	m_SignalLevel = 1.0;
	m_BitPhasePos = 0.0;
	m_BitAcc = 0;
	m_LastBitZero = false;
	m_SampCnt = 0;
	m_OnCount = 0;
	m_OffCount = 0;

	for( i=0; i<21; i++)
		m_SyncAve[i] = 0.0;					// initialize the array


// Init a bunch of "static" variables used in various member fuctions
	m_AGCave = 0.0;
	m_FreqError = 0.0;
	m_VcoPhz = 0.0;
	m_LastFreq = 1000.0;
	m_PkPos = 0;
	m_NewPkPos = 5;
	m_BitPos = 0;
	m_I1 = 0.0;
	m_I0 = 0.0;
	m_Q1 = 0.0;
	m_Q0 = 0.0;
	m_DevAve = .4;

  m_z1=double_complex(0.0,0.0);
	m_z2=m_z1;
	m_FerAve = 0.0;
	m_QFreqError = 0.0;
	m_LastPkPos = 0;
	m_ClkErrCounter = 0;
	m_ClkErrTimer = 0;
	m_ClkError = 0;
// Initializing Variables for AFC
	fe1=0.0;
	fe2=0.0;
	ferror=0.0;
	ferror1=0.0;
	ferror2=0.0;
	dp=0.0;
	dp1=0.0;
	dp2=0.0;
		
return true;
}

//////////////////////////////////////////////////////////////////////
// Main routine called to process the next block of data 'pIn'.
//  The center frequency is specified by 'Freq'.
//  The function returns the new AFC'd frequency.
//  'UseAFC' specifies whether to automatically lock to the frequency.
//  30mSec for BPSK, 38mSec for QPSK( 133MHz Pentium )
//////////////////////////////////////////////////////////////////////

void CPskDemodulator::ProcessInput( double* pIn)
{
double freqerror;
double vcophz = m_VcoPhz;
int i,j;
double_complex acc;
const double* Kptr;
double_complex* Firptr;
double_complex* Inptr1;			//decimation FIR #1 variables
double_complex* Qptr1;
double_complex* Inptr2;			//decimation FIR #2 variables
double_complex* Qptr2;

if ( UseAfc)
		freqerror= m_FreqError;
	else
		freqerror= 0.0;	

	m_DispTrig = false;
	j=0;
	if( RxFrequency != m_LastFreq )	//caller is changing center frequency
	{													//so recalc freq error value
///		freqerror = freqerror + m_phzinc;	//current center freq inc
		m_phzinc = (PI2/m_Fs)*RxFrequency;	//new center freq inc
///		if( UseAfc )
///			freqerror = m_phzinc - freqerror;
///		else
			freqerror = 0.0;
		m_LastFreq = RxFrequency;
	}
	Inptr1 = m_pInPtr1;		//use local copies of member variables
	Qptr1 = m_pQue1;		// for better speed.
	Inptr2 = m_pInPtr2;
	Qptr2 = m_pQue2;
	for( i = 0; i<m_BlockSize; i++ )	// put new samples into Queue
	{
		if( --Inptr1 < Qptr1 )		//deal with FIR pointer wrap around
			Inptr1 = Qptr1+DEC3_LPFIR_LENGTH-1;
//Generate complex sample by mixing input sample with NCO's sin/cos
		vcophz = vcophz + (m_phzinc + freqerror);
//			*Inptr1=pIn[i]*exp(float_complex(0,vcophz));
		*Inptr1=pIn[i]*double_complex(cos(vcophz),sin(vcophz));
//		vcophz = vcophz + (m_phzinc + freqerror);
		if(vcophz > PI2)		//handle 2 Pi wrap around
			vcophz -= PI2;
//decimate by 3 filter
//  10uSec( 133MHz Pentium )
		if( ( (++m_SampCnt)%3 ) == 0 )	//calc first decimation filter every 3 samples
		{

			acc=double_complex(0.0,0.0);
			Firptr = Inptr1;
			Kptr = Dec3LPCoef;
			while( Kptr < (Dec3LPCoef + DEC3_LPFIR_LENGTH) )	//do the MAC's
			{

				acc +=(*Firptr)*(*Kptr++);
				if( (++Firptr) >= Qptr1+DEC3_LPFIR_LENGTH ) //deal with wraparound
					Firptr = Qptr1;
			}
			if( --Inptr2 < Qptr2 )		//deal with FIR pointer wrap around
				Inptr2 = Qptr2+DEC3_LPFIR_LENGTH-1;

				*Inptr2=acc;

//decimate by 3 filter
//  10uSec( 133MHz Pentium )
			if( (m_SampCnt%9) == 0 )	//calc second decimation filter every 9 samples
			{

				acc=double_complex(0.0,0.0);
				Firptr = Inptr2;
				Kptr = Dec3LPCoef;
				while( Kptr < (Dec3LPCoef + DEC3_LPFIR_LENGTH) )	//do the MAC's
				{

					acc=(*Firptr)*(*Kptr);
					Kptr++;
					if( (++Firptr) >= Qptr2+DEC3_LPFIR_LENGTH ) //deal with wraparound
						Firptr = Qptr2;
				}
// here at Fs/9 = 612.5 Hz rate with latest sample in acc.
// Matched Filter the I and Q data and also a frequency error filter
//	filter puts filtered signals in m_FreqSignal and m_BitSignal.
				CalcBitFilter( acc );		// 25 uSec( 133MHz Pentium )
// Perform AGC operation
				m_SignalLevel = CalcAGC( m_FreqSignal );	// 9 uSec( 133MHz Pentium )

				if( m_DispTrig  )	//j ranges 0 to 2048/9 or 227
				
					emit newPhaseValue(j++,float_complex(m_BitSignal));
// Calculate frequency error

				if( UseAfc )
					freqerror = CalcFreqError(m_FreqSignal);	// 10 uSec( 133MHz Pentium )
// 			Perhaps I should introduce a narrow / wid switch for the AFC
//				freqerror = CalcFreqError(m_BitSignal);	// 10 uSec( 133MHz Pentium )
				else
					{
#if AFC_DEBUG
					freqerror = CalcFreqError(m_BitSignal);	// 10 uSec( 133MHz Pentium )
#endif	 				
	 				freqerror = 0.0;
	 				}
// Bit Timing synchronization
				
				if( SymbSync(m_BitSignal) )	// 8 uSec( 133MHz Pentium )
				{
					DecodeSymbol( m_BitSignal);		//615uS(QPSK)
				
				}	m_DispTrig = true;
			}
		}
	}
	m_SampCnt = m_SampCnt%9;
	m_pInPtr1 = Inptr1;		// save position in circular delay line
	m_pInPtr2 = Inptr2;		// save position in circular delay line
	
	m_FreqError = freqerror;
	m_VcoPhz = vcophz;
	
		if (UseAfc)			// Change RxFrequency, but slowly
		{
			freqerror=freqerror*m_Fs/PI2;		
			RxFrequency = RxFrequency + freqerror;
			emit rxFrequencyChanged(RxFrequency);
		}
	

  settings.clockerror=m_ClkError;
}


//////////////////////////////////////////////////////////////////////
// Called at Fs/9 rate to calculate the symbol sync position
// Returns true if at center of symbol.
// Sums up the energy at each sample time, averages it, and picks the
//   sample time with the highest energy content.
//////////////////////////////////////////////////////////////////////

bool CPskDemodulator::SymbSync(double_complex sample)

{
bool Trigger;
double energy;


int BitPos = m_BitPos;
	energy = sample.real()*sample.real()+sample.imag()*sample.imag();
	if( energy > 4.0)		//wait for AGC to settle down
		energy = 1.0;
	m_SyncAve[BitPos] = (1.0-1.0/100.0)*m_SyncAve[BitPos] + (1.0/100.0)*energy;
	if( BitPos == m_PkPos )	// see if at middle of symbol
	{
		Trigger = true;
//		display->m_SyncHist[m_PkPos] = (int)(10000.0*m_SyncAve[m_PkPos]);
	}
	else
	{
		Trigger = false;
//		display->m_SyncHist[BitPos] = (int)(7000.0*m_SyncAve[BitPos]);

	}
	if( BitPos == HALF_TBL[m_PkPos] )	//don't change pk pos until
		m_PkPos = m_NewPkPos;			// halfway into next bit.
	BitPos++;
	m_BitPhasePos += (m_BitPhaseInc);
	if( m_BitPhasePos >= Ts )
	{									// here every symbol time
		m_BitPhasePos -= Ts;			//keep phase bounded
		BitPos = 0;
		max = -1e10;
		for( int i=0; i<19; i++)		//find maximum energy pk
		{
			energy = m_SyncAve[i];
			if( energy > max )
			{
				m_NewPkPos = i;
				max = energy;
			}
		}
		if( m_PkPos == m_LastPkPos+1 )	//calculate clock error
			m_ClkErrCounter++;
		else
			if( m_PkPos == m_LastPkPos-1 )
				m_ClkErrCounter--;
		if( m_ClkErrTimer++ > 313 )	// every 10 seconds sample clk drift
		{
			m_ClkError = m_ClkErrCounter*180;
			m_ClkErrCounter = 0;
			m_ClkErrTimer = 0;
		}
		m_LastPkPos = m_PkPos;
	}
	m_BitPos = BitPos;
	return Trigger;
}


//////////////////////////////////////////////////////////////////////
//  Frequency error calculator
// calculates the derivative of the tan(I/Q).
// returns frequency error ~= .0034 per Hz error.
//////////////////////////////////////////////////////////////////////
double CPskDemodulator::CalcFreqError( double_complex IQ )
{


double ftotal ;

ferror2=ferror1;
ferror1=ferror;
dp2=dp1;
dp1=m_QFreqError;
dp=0.98*dp+0.01*dp1-0.01*dp2;
ferror = (IQ.real() - m_z2.real()) * m_z1.imag() - (IQ.imag() - m_z2.imag()) * m_z1.real();

	m_z2 = m_z1;
	m_z1 = IQ;
	if( ferror > .15 )		//clamp range
		ferror = .15;
	if( ferror < -.15 )
		ferror = -.15;
//ftotal=0.03*ferror+0.02*ferror1-0.02*ferror2+0.5*fe1+0.4*fe2;
ftotal=0.01*ferror+0.01*ferror1-0.01*ferror2+0.5*fe1+0.4*fe2;
fe2=fe1;
fe1=ftotal;

		m_FerAve = 0.99 *m_FerAve + 0.008*ftotal + 0.002 * dp;

		return m_FerAve;
}

//////////////////////////////////////////////////////////////////////
// Automatic gain control calculator
//////////////////////////////////////////////////////////////////////
double CPskDemodulator::CalcAGC( double_complex Samp)
{
double mag;

	mag = sqrt(Samp.real()*Samp.real() + Samp.imag()*Samp.imag());
	if( mag > m_AGCave )

		m_AGCave = (1.0-1.0/250.0)*m_AGCave + (1.0/250.0)*mag;
	else
		m_AGCave = (1.0-1.0/1000.0)*m_AGCave + (1.0/1000.0)*mag;
	if( m_AGCave >= 1.0 )	// divide signal by ave if not almost zero
	{
		m_BitSignal /= m_AGCave;
//		m_BitSignal.y /= m_AGCave;
		m_FreqSignal /= m_AGCave;
//		m_FreqSignal.y /= m_AGCave;
	}
	return(m_AGCave);
}


//////////////////////////////////////////////////////////////////////
// BIT FIR filters. A narrow matched(?) data filter for data
//                  and wider filter for the AFC/AGC functions
//////////////////////////////////////////////////////////////////////
void CPskDemodulator::CalcBitFilter(double_complex Samp)
{
double_complex acc1;
double_complex acc2;
const double* Kptr1;
const double* Kptr2;
double_complex* Firptr;
double_complex* Qptr;
double_complex* Inptr;
	Inptr = m_pInPtr3;		//use local copies of member variables
	Qptr = m_pQue3;			// for better speed.
	if( --Inptr < Qptr )	//deal with LPFIR pointer wrap around
		Inptr = Qptr+BITFIR_LENGTH-1;
//	Inptr->x = Samp.x;	//place in circular Queue
	*Inptr = Samp;
//	acc1.x = 0.0;
	acc1 = double_complex(0.0,0.0);
//	acc2.x = 0.0;
	acc2 = double_complex(0.0,0.0);
	Firptr = Inptr;
	Kptr1 = FreqFirCoef;	//frequency error filter
	Kptr2 = BitFirCoef;	//bit data filter
	while( Kptr2 < (BitFirCoef + BITFIR_LENGTH) )	//do the MAC's
	{
//		acc1.x += ( (Firptr->x)*(*Kptr1) );
		acc1 += ( (*Firptr)*(*Kptr1++) );
						
//		acc2.x += ( (Firptr->x)*(*Kptr2) );
		acc2 += ( (*Firptr)*(*Kptr2++) );
						
		if( (++Firptr) >= (Qptr+BITFIR_LENGTH) ) //deal with wraparound
			Firptr = Qptr;
	}
	m_pInPtr3 = Inptr;		// save position in circular delay line
//	m_FreqSignal.x = acc1.x;
	m_FreqSignal = acc1;
//	m_BitSignal.x = acc2.x;
	m_BitSignal = acc2;
}





