/***************************************************************************
                          crxwindow.cpp  -  description
                             -------------------
    begin                : Sat Mar 4 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "crxwindow.h"

CRxwindow::CRxwindow(QWidget *parent, const char *name ) : QMultiLineEdit(parent,name)
{


akt_line=0;
akt_col=0;
RxString="";
TriggerOn=false;

setReadOnly(TRUE);

DebugOn = false;
}
CRxwindow::~CRxwindow()
{
}

void CRxwindow::setMaxVisible(int lines)
{
//visible=lines;
setFixedVisibleLines(lines);
}

void CRxwindow::setMaxLine(int lines)
{
maxline=lines;
}

void CRxwindow::updaterx( char c) // Zeichen in RX-Fenster einfgen
{

bool marked;
int marked_line1,marked_line2,marked_col1,marked_col2;
// save marked region , if exists
marked=getMarkedRegion(&marked_line1,&marked_col1,&marked_line2,&marked_col2);
setCursorPosition(akt_line,akt_col,false);

switch(c)
	{
	case '\n':
	case '\r':		
		newLine();
    akt_col=0;
		akt_line++;
		if (akt_line >= maxline)
			{
				removeLine(0);
				akt_line--;
				if(marked)
					{
						marked_line1--;
						marked_line2--;
					}	
			}
		break;
	case '\b':
		backspace();
		akt_col--;
		break;
	case '0':
		if(settings.slashed0)
//			c= 206 && 0xFF;
				c= 0xF8;
	default:
		
		insert(QString(QChar(c)));
		akt_col++;
		if (akt_col>80)
		{
			akt_col=0;
			newLine();
			killLine();
  		akt_line++;
  		if(akt_line>=maxline)
			{
				removeLine(0);
				akt_line--;
				if(marked)
					{
						marked_line1--;
						marked_line2--;
					}	
				
			}
  	}
	} // End Switch
if (marked)		// mark again
	{
	setCursorPosition(marked_line1,marked_col1);
	cursorWordForward(true);
	}	
if (TriggerOn && (settings.status == TX_OFF_STATE))
	updateTrigger(c);
	
if( DebugOn)
		FileOutput.writeRawBytes(&c,1);
		
		
}

void CRxwindow::mouseDoubleClickEvent(QMouseEvent *m)
{
int line,col;

QString s;

cursorPosition(&line,&col);
setCursorPosition(line,col,false);
cursorWordForward(true);
s=markedText();                    //copy marked word to buffer;


emit theircallChanged(s);
cursorRight(false);							// to unmark
}

/** Updates and compares the Triggerstring */
void CRxwindow::updateTrigger(char c)
{
if ( (c == '\n') || (c == '\r')) //Ignore \n and \r
	return;

if ( c == '\b')
 RxString.remove(RxString.length(),1);		
if (RxString.length() == Trigger.length()) // RxString has equal Length as Triggerstring
																						// so remove first Character
		RxString.remove(0,1);
		
RxString += c;
if (RxString.lower() == Trigger.lower())
 {
 	RxString ="";
 	emit triggered();

 	}		

}
/** Sets the Triggercondition */
void CRxwindow::setTrigger(QString String)
{
Trigger=String;
RxString="";      // Clear RxString
}
/** activates/deactivates the Trigger */
void CRxwindow::setTriggerMode(bool mode)
{
TriggerOn=mode;
if (TriggerOn)
	RxString="";   // Clear RxString
}

/**Open/close DebugFile */
void CRxwindow::setDebugFile(QString FileName)
{
if (DebugOn) // As Debug is on , we should switch to off.
 	{
 	DebugFile->close();
 	DebugOn=false;
 	FileOutput.unsetDevice();
 	DebugFile->~QFile();
 	}
else
 	{
 	DebugFile=new QFile(FileName);
 	DebugFile->open(IO_WriteOnly);
 	FileOutput.setDevice(DebugFile);
 	DebugOn=true;
	}
}	
/** Clears the contents of the window and initializes the pointers */
void CRxwindow::clearRxWindow()
{
clear();
akt_col=0;
akt_line=0;
///emit theircallChanged("");
}
