diff -Naur linux-2.6.17.orig/drivers/video/logo/Kconfig linux-2.6.17/drivers/video/logo/Kconfig
--- linux-2.6.17.orig/drivers/video/logo/Kconfig	2006-10-20 14:17:42.000000000 +0200
+++ linux-2.6.17/drivers/video/logo/Kconfig	2006-10-20 14:23:17.000000000 +0200
@@ -25,6 +25,16 @@
 	depends on LOGO
 	default y
 
+config LOGO_LINUX_DEBIAN
+	bool "Debian GNU/Linux Open Use logo"
+	depends on LOGO
+	default y
+
+config LOGO_LINUX_DEBIAN_TUX
+	bool "Linux logo with Debian swirl"
+	depends on LOGO
+	default y
+
 config LOGO_DEC_CLUT224
 	bool "224-color Digital Equipment Corporation Linux logo"
 	depends on LOGO && (MACH_DECSTATION || ALPHA)
diff -Naur linux-2.6.17.orig/drivers/video/logo/Makefile linux-2.6.17/drivers/video/logo/Makefile
--- linux-2.6.17.orig/drivers/video/logo/Makefile	2006-10-20 14:17:42.000000000 +0200
+++ linux-2.6.17/drivers/video/logo/Makefile	2006-10-20 14:27:34.000000000 +0200
@@ -4,6 +4,8 @@
 obj-$(CONFIG_LOGO_LINUX_MONO)		+= logo_linux_mono.o
 obj-$(CONFIG_LOGO_LINUX_VGA16)		+= logo_linux_vga16.o
 obj-$(CONFIG_LOGO_LINUX_CLUT224)	+= logo_linux_clut224.o
+obj-$(CONFIG_LOGO_LINUX_DEBIAN)		+= logo_linux_debian.o
+obj-$(CONFIG_LOGO_LINUX_DEBIAN_TUX)	+= logo_linux_debian_tux.o
 obj-$(CONFIG_LOGO_DEC_CLUT224)		+= logo_dec_clut224.o
 obj-$(CONFIG_LOGO_MAC_CLUT224)		+= logo_mac_clut224.o
 obj-$(CONFIG_LOGO_PARISC_CLUT224)	+= logo_parisc_clut224.o
@@ -30,6 +32,22 @@
 # 224 Logos
 extra-y += $(call logo-cfiles,_clut224,ppm)
 
+#Debian Logos
+extra-y += $(call logo-cfiles,_debian,ppm)
+extra-y += $(call logo-cfiles,_debian_tux,ppm)
+
+quiet_cmd_logo_debian = DEBIAN  $@
+      cmd_logo_debian = scripts/pnmtologo -n $*_debian -o $@ $<
+
+quiet_cmd_logo_debian_tux = DEBIAN  $@
+      cmd_logo_debian_tux = scripts/pnmtologo -n $*_debian_tux -o $@ $<
+
+$(obj)/%_debian.c: $(src)/%_debian.ppm FORCE
+	$(call if_changed,logo_debian)
+
+$(obj)/%_debian_tux.c: $(src)/%_debian_tux.ppm FORCE
+	$(call if_changed,logo_debian_tux)
+
 # Gray 256
 extra-y += $(call logo-cfiles,_gray256,pgm)
 
diff -Naur linux-2.6.17.orig/drivers/video/logo/logo.c linux-2.6.17/drivers/video/logo/logo.c
--- linux-2.6.17.orig/drivers/video/logo/logo.c	2006-10-20 14:17:42.000000000 +0200
+++ linux-2.6.17/drivers/video/logo/logo.c	2006-10-20 14:25:47.000000000 +0200
@@ -25,6 +25,8 @@
 extern const struct linux_logo logo_linux_mono;
 extern const struct linux_logo logo_linux_vga16;
 extern const struct linux_logo logo_linux_clut224;
+extern const struct linux_logo logo_linux_debian;
+extern const struct linux_logo logo_linux_debian_tux;
 extern const struct linux_logo logo_dec_clut224;
 extern const struct linux_logo logo_mac_clut224;
 extern const struct linux_logo logo_parisc_clut224;
@@ -67,6 +69,14 @@
 		/* Generic Linux logo */
 		logo = &logo_linux_clut224;
 #endif
+#ifdef CONFIG_LOGO_LINUX_DEBIAN
+		/* Debian swirl logo */
+		logo = &logo_linux_debian;
+#endif
+#ifdef CONFIG_LOGO_LINUX_DEBIAN_TUX
+		/* Linux logo with Debian swirl */
+		logo = &logo_linux_debian_tux;
+#endif
 #ifdef CONFIG_LOGO_DEC_CLUT224
 		/* DEC Linux logo on MIPS/MIPS64 or ALPHA */
 #ifndef CONFIG_ALPHA
diff -Naur linux-2.6.17.orig/drivers/video/logo/logo_linux_debian.ppm linux-2.6.17/drivers/video/logo/logo_linux_debian.ppm
--- linux-2.6.17.orig/drivers/video/logo/logo_linux_debian.ppm	1970-01-01 01:00:00.000000000 +0100
+++ linux-2.6.17/drivers/video/logo/logo_linux_debian.ppm	2006-10-20 14:17:41.000000000 +0200
@@ -0,0 +1,4003 @@
+P3
+300 80
+255
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+102 2 38  106 2 38  106 2 38  14 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  66 2 26
+154 6 58  94 2 34  158 6 58  158 6 58  98 2 38  2 2 2
+6 2 2  98 2 38  66 2 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  22 2 10  114 2 42  198 6 74  210 6 78
+214 6 82  214 6 82  214 6 82  210 6 78  206 6 78  202 6 78
+150 6 58  102 2 38  198 6 74  198 6 74  162 6 62  178 6 66
+170 6 62  90 2 34  70 2 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+26 2 10  114 2 42  198 6 74  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  174 6 66  82 2 30  30 2 10
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  6 6 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  26 2 10  114 2 42
+194 6 74  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  198 6 74
+122 2 46  74 2 26  74 2 26  74 2 26  42 2 14  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  30 2 10  114 2 42  194 6 74  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  198 6 74  74 2 26
+6 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  14 2 6  14 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  10 2 6  14 2 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  30 2 10  186 6 70  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+174 6 66  54 2 22  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  14 2 6  6 6 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  34 2 14
+166 6 62  190 6 70  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  198 6 74  126 2 46  10 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  6 6 6  14 2 6  6 6 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  34 2 14  190 6 70
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  194 6 74  198 6 74  214 6 82  174 6 66  118 2 46
+62 2 22  62 2 22  62 2 22  62 2 22  98 2 38  170 6 62
+170 6 62  182 6 70  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  170 6 62  58 2 22  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  26 10 14  162 18 70
+26 10 14  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  186 6 70  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  194 6 74
+106 2 38  22 2 10  38 2 14  62 2 22  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  66 2 26  142 6 54  186 6 70  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  202 6 74  58 2 22
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  26 10 14  186 6 70  214 6 82
+186 6 70  26 10 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+6 6 6  6 6 6  6 6 6  6 6 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 2 2  114 2 42  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  118 2 46  26 2 10
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 2  86 2 34
+186 6 70  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  198 6 74
+58 2 22  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  6 6 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  30 10 18  190 10 78  214 6 82  214 6 82
+214 6 82  186 6 70  26 10 14  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  106 2 38  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  202 6 74  194 6 74  166 6 62  22 2 10  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+10 2 2  142 6 54  210 6 78  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+198 6 74  42 2 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  42 42 42  150 150 150  90 90 90  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  38 38 38  142 142 142  222 222 222
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  26 10 14  186 6 70  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  190 6 74  26 10 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+10 2 6  10 2 6  10 2 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+34 2 14  190 6 70  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  170 6 62
+86 2 34  18 2 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  46 2 18  210 6 78  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  138 6 50  6 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  10 10 10
+82 82 82  182 182 182  250 250 250  254 254 254  74 74 74  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  74 74 74  178 178 178  254 254 254  254 254 254  234 234 234
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+30 10 18  190 10 78  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  186 6 70  26 10 14  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  14 2 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  26 2 10
+190 6 70  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  114 2 42  14 2 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  46 2 18  210 6 78  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  138 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 10 10  42 42 42
+66 66 66  86 86 86  114 114 114  142 142 142  182 182 182  242 242 242
+254 254 254  254 254 254  254 254 254  254 254 254  42 42 42  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 10 10  22 22 22  54 54 54  94 94 94  150 150 150
+218 218 218  254 254 254  254 254 254  254 254 254  254 254 254  226 226 226
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  26 10 14
+186 6 70  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  186 6 70  26 10 14
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+6 6 6  6 6 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  110 2 42
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  210 6 78  74 2 26  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  46 2 18  210 6 78
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  202 6 74  46 2 18  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  18 18 18  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  250 250 250  6 6 6  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  106 106 106
+230 230 230  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  206 206 206
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  30 10 18  186 10 74
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  186 6 70
+26 10 14  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  6 6 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+14 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  54 2 22  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  170 6 62  62 2 22  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  46 2 18
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  194 6 74  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  46 46 46
+246 246 246  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  222 222 222  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+58 58 58  222 222 222  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  190 190 190
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  106 22 54  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+114 18 54  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+10 2 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  170 6 62  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+114 2 42  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+46 2 18  206 6 78  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  90 2 34  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+98 98 98  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  190 190 190  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  54 54 54  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  170 170 170
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  122 22 58
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  134 14 58
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+186 6 70  26 2 10  2 2 2  26 2 10  194 6 74  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  62 2 22
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  142 6 54  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  138 6 50  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+30 30 30  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  174 174 174  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  226 226 226  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  146 146 146
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+114 18 54  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  134 14 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  38 2 14
+126 2 46  2 2 2  2 2 2  106 2 38  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  62 2 22  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  50 2 18  206 6 78  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  206 6 78  38 2 14
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+18 18 18  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  150 150 150  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  198 198 198  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  126 126 126
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  122 22 58  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  134 14 58  6 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  6 6 6
+6 6 6  6 6 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  6 2 2
+14 2 6  2 2 2  106 2 38  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  206 6 78  66 2 26  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  142 6 54  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  166 6 62  142 6 54  210 6 78  102 2 38
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  146 146 146  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  174 174 174  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  118 118 118
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  134 14 58  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  134 14 58  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  66 2 26  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  210 6 78  62 2 22  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  14 2 6  186 6 70  214 6 82  214 6 82
+214 6 82  214 6 82  78 2 30  14 2 6  170 6 62  14 2 6
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  142 142 142  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  158 158 158  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  118 118 118
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  114 18 54  214 6 82  214 6 82
+214 6 82  134 6 50  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  10 2 6
+10 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  166 6 62  214 6 82  214 6 82  214 6 82  214 6 82
+206 6 78  70 2 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  58 2 22  46 2 18  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  86 2 34  214 6 82  214 6 82
+214 6 82  214 6 82  126 2 46  70 2 26  82 2 30  30 2 10
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  118 118 118  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  150 150 150  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  114 114 114
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  134 14 58  214 6 82
+134 14 58  6 6 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+26 2 10  198 6 74  214 6 82  214 6 82  214 6 82  214 6 82
+142 6 54  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  58 2 22
+110 2 42  170 6 62  170 6 62  206 6 78  198 6 74  170 6 62
+170 6 62  86 2 34  46 2 18  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  66 2 26  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  174 6 66  14 2 6  94 2 34
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  110 110 110  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  94 94 94
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  78 18 42
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  78 2 30  6 2 2
+110 2 42  214 6 82  214 6 82  214 6 82  214 6 82  194 6 74
+30 2 10  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  30 2 10  162 6 62  214 6 82
+214 6 82  214 6 82  214 6 82  170 6 62  162 6 62  162 6 62
+162 6 62  174 6 66  206 6 78  86 2 34  18 2 6  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  18 2 6  186 6 70  214 6 82
+214 6 82  214 6 82  214 6 82  194 6 74  2 2 2  110 2 42
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  110 110 110  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  94 94 94
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  110 2 42  22 2 10
+202 6 74  214 6 82  214 6 82  214 6 82  214 6 82  182 6 70
+14 2 6  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  34 2 14  190 6 70  214 6 82  214 6 82
+170 6 62  66 2 26  58 2 22  10 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  58 2 22  134 6 50  146 6 54  18 2 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  166 6 62  214 6 82
+214 6 82  214 6 82  214 6 82  202 6 74  18 2 6  86 2 34
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  110 110 110  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  90 90 90
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  90 2 34  90 2 34
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  146 6 54
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  34 2 14  190 6 70  214 6 82  198 6 74  122 2 46
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  54 2 22  126 2 46
+14 2 6  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  94 2 34  214 6 82
+214 6 82  214 6 82  214 6 82  154 6 58  74 2 26  6 2 2
+70 2 26  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  110 110 110  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  94 94 94
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  166 6 62
+214 6 82  214 6 82  214 6 82  214 6 82  210 6 78  46 2 18
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  142 6 54  214 6 82  194 6 74  38 2 14  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  10 2 2
+30 2 10  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  50 2 18  210 6 78
+214 6 82  214 6 82  214 6 82  198 6 74  14 2 6  2 2 2
+34 2 14  14 2 6  10 2 2  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  106 106 106  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  90 90 90
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  206 6 78
+214 6 82  214 6 82  214 6 82  214 6 82  86 2 34  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+110 2 42  214 6 82  194 6 74  34 2 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  166 6 62
+214 6 82  214 6 82  214 6 82  214 6 82  78 2 30  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+14 14 14  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  90 90 90  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  74 74 74
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  58 2 22  210 6 78
+214 6 82  214 6 82  214 6 82  182 6 70  18 2 6  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  98 2 38
+214 6 82  202 6 74  38 2 14  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  162 6 62
+214 6 82  214 6 82  214 6 82  194 6 74  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  34 34 34  66 66 66  86 86 86
+98 98 98  114 114 114  126 126 126  142 142 142  162 162 162  166 166 166
+166 166 166  162 162 162  142 142 142  106 106 106  42 42 42  2 2 2
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  10 10 10
+46 46 46  74 74 74  98 98 98  122 122 122  150 150 150  170 170 170
+190 190 190  198 198 198  198 198 198  190 190 190  174 174 174  154 154 154
+130 130 130  106 106 106  90 90 90  66 66 66  14 14 14  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  22 22 22
+74 74 74  98 98 98  122 122 122  138 138 138  162 162 162  166 166 166
+158 158 158  138 138 138  126 126 126  86 86 86  14 14 14  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  78 78 78  194 194 194  34 34 34
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  30 30 30  74 74 74  102 102 102  130 130 130  138 138 138
+142 142 142  162 162 162  166 166 166  166 166 166  166 166 166  162 162 162
+150 150 150  134 134 134  122 122 122  110 110 110  94 94 94  78 78 78
+46 46 46  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  14 14 14
+126 126 126  230 230 230  6 6 6  2 2 2  2 2 2  2 2 2
+2 2 2  50 50 50  94 94 94  118 118 118  138 138 138  158 158 158
+178 178 178  198 198 198  198 198 198  190 190 190  170 170 170  154 154 154
+138 138 138  106 106 106  70 70 70  22 22 22  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  98 2 38  214 6 82
+214 6 82  214 6 82  214 6 82  146 6 54  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  22 2 10  190 6 70
+214 6 82  126 2 46  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  162 6 62
+214 6 82  214 6 82  214 6 82  206 6 78  54 2 22  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  54 54 54
+138 138 138  198 198 198  246 246 246  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  226 226 226
+166 166 166  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  30 30 30  106 106 106  170 170 170  226 226 226  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  206 206 206
+106 106 106  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  2 2 2  2 2 2  38 38 38  190 190 190  250 250 250
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  246 246 246  150 150 150
+14 14 14  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  34 34 34
+78 78 78  138 138 138  234 234 234  254 254 254  242 242 242  6 6 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  38 38 38  130 130 130
+218 218 218  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  206 206 206  114 114 114  10 10 10  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  14 14 14  74 74 74  138 138 138  238 238 238
+254 254 254  246 246 246  10 10 10  2 2 2  2 2 2  46 46 46
+206 206 206  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  214 214 214  62 62 62
+2 2 2  2 2 2  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  98 2 38  214 6 82
+214 6 82  214 6 82  214 6 82  42 2 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  42 2 14  214 6 82
+206 6 78  38 2 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  162 6 62
+214 6 82  214 6 82  214 6 82  214 6 82  198 6 74  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  30 30 30  190 190 190  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  38 38 38
+182 182 182  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  178 178 178  6 6 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  2 2 2  38 38 38  234 234 234  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+218 218 218  46 46 46  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  22 22 22  114 114 114
+142 142 142  174 174 174  198 198 198  222 222 222  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  214 214 214  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  54 54 54  186 186 186  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  206 206 206  18 18 18
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  66 66 66  174 174 174  194 194 194  210 210 210
+214 214 214  234 234 234  250 250 250  254 254 254  254 254 254  254 254 254
+254 254 254  246 246 246  6 6 6  2 2 2  42 42 42  238 238 238
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  246 246 246
+46 46 46  2 2 2  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  214 6 82  42 2 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  154 6 58  214 6 82
+130 6 50  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  54 2 22  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  162 6 62
+214 6 82  214 6 82  214 6 82  214 6 82  146 6 54  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  30 30 30  234 234 234  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  54 54 54  242 242 242
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  154 154 154  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  6 6 6  206 206 206  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  238 238 238  42 42 42  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  98 98 98
+246 246 246  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  170 170 170  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+38 38 38  162 162 162  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  170 170 170
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  158 158 158  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  10 10 10  2 2 2  194 194 194  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+154 154 154  2 2 2  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  214 6 82  42 2 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  214 6 82  214 6 82
+74 2 26  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 2 2  214 6 82  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  54 2 22  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  90 2 34  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  190 190 190  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  6 6 6  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  42 42 42  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  98 98 98  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  206 206 206  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+142 142 142  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  134 134 134  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  54 54 54
+250 250 250  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+42 42 42  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  14 14 14  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  246 246 246  6 6 6  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+226 226 226  2 2 2  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  214 6 82  42 2 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  214 6 82  214 6 82
+78 2 30  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  66 2 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  58 2 22  214 6 82
+214 6 82  214 6 82  214 6 82  198 6 74  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  90 90 90  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  126 126 126  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  146 146 146  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  202 202 202  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  138 138 138  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+70 70 70  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+206 206 206  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+114 114 114  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  186 186 186  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  10 10 10  166 166 166  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  190 6 70  22 2 10  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  214 6 82  198 6 74
+42 2 14  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  58 2 22  214 6 82
+214 6 82  214 6 82  214 6 82  150 6 58  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  206 206 206  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  218 218 218  186 186 186  170 170 170
+162 162 162  162 162 162  170 170 170  198 198 198  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  222 222 222  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  158 158 158  94 94 94  74 74 74  54 54 54
+26 26 26  26 26 26  50 50 50  70 70 70  102 102 102  166 166 166
+246 246 246  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  238 238 238  6 6 6  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+42 42 42  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  246 246 246  46 46 46  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+26 26 26  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+78 78 78  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+166 166 166  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  138 138 138  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  246 246 246  26 26 26  246 246 246  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  54 54 54  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  214 6 82  214 6 82
+70 2 26  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  26 2 10  194 6 74
+214 6 82  214 6 82  214 6 82  86 2 34  38 2 14  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+42 42 42  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  190 190 190
+98 98 98  38 38 38  6 6 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  30 30 30  150 150 150
+246 246 246  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  2 2 2  46 46 46  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+242 242 242  58 58 58  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+46 46 46  242 242 242  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  58 58 58  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+146 146 146  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  174 174 174  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  206 206 206  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  242 242 242  182 182 182  114 114 114  94 94 94
+74 74 74  66 66 66  66 66 66  66 66 66  70 70 70  86 86 86
+106 106 106  138 138 138  214 214 214  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+198 198 198  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  106 106 106  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  98 98 98  254 254 254  254 254 254  246 246 246
+174 174 174  138 138 138  110 110 110  94 94 94  94 94 94  106 106 106
+130 130 130  174 174 174  250 250 250  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  66 66 66  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  98 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  214 6 82  214 6 82
+74 2 26  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  94 2 34  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  54 2 22  214 6 82
+214 6 82  214 6 82  214 6 82  86 2 34  70 2 26  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+118 118 118  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  118 118 118  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+78 78 78  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  122 122 122  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+122 122 122  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  126 126 126  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  98 98 98  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  62 62 62
+230 230 230  254 254 254  254 254 254  254 254 254  186 186 186  138 138 138
+118 118 118  118 118 118  138 138 138  158 158 158  186 186 186  242 242 242
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  250 250 250  46 46 46
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  222 222 222  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  114 114 114  254 254 254  254 254 254  254 254 254  254 254 254
+202 202 202  90 90 90  14 14 14  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  158 158 158  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+210 210 210  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  66 66 66  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  202 202 202  254 254 254  222 222 222  34 34 34
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  50 50 50  246 246 246  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  62 62 62  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  214 6 82  214 6 82
+170 6 62  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  6 2 2
+86 2 34  50 2 18  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  94 2 34  214 6 82
+214 6 82  214 6 82  102 2 38  30 2 10  74 2 26  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+190 190 190  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  202 202 202  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+62 62 62  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  2 2 2  166 166 166  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  250 250 250
+22 22 22  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  38 38 38  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  142 142 142  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  122 122 122
+254 254 254  254 254 254  242 242 242  54 54 54  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+70 70 70  226 226 226  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  162 162 162
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  202 202 202  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  234 234 234  90 90 90
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  22 22 22  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+234 234 234  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  42 42 42  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  66 66 66  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  170 170 170  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  66 66 66  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  98 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  34 2 14  198 6 74  214 6 82
+186 6 70  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  106 2 38
+106 2 42  70 2 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  18 2 6  182 6 70  214 6 82
+214 6 82  190 6 70  18 2 6  18 2 6  62 2 22  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+242 242 242  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+46 46 46  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  2 2 2  206 206 206  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  190 190 190
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  242 242 242  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  166 166 166  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  210 210 210
+254 254 254  254 254 254  106 106 106  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  46 46 46  246 246 246  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  246 246 246
+30 30 30  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  178 178 178  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  18 18 18  250 250 250  210 210 210  34 34 34  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  234 234 234  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  6 6 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  18 18 18  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  190 190 190  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  126 126 126  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  74 74 74  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  154 6 58  214 6 82
+206 6 78  62 2 22  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  98 2 38
+150 6 58  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  50 2 18  178 6 66  214 6 82  214 6 82
+214 6 82  98 2 38  2 2 2  82 2 30  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  34 34 34
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  14 14 14  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+34 34 34  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  2 2 2  234 234 234  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  138 138 138
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  210 210 210  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  190 190 190  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  242 242 242  14 14 14  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+102 102 102  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  162 162 162  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  114 114 114  10 10 10  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  250 250 250
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  102 102 102  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  90 90 90  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  98 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  74 2 26  214 6 82
+214 6 82  106 2 38  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  6 2 2
+22 2 10  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  70 2 26  214 6 82  214 6 82  214 6 82
+206 6 78  54 2 22  6 2 2  46 2 18  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  62 62 62
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  218 218 218  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+38 38 38  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  14 14 14  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  102 102 102
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  206 206 206  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  214 214 214  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  158 158 158  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  66 66 66  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+162 162 162  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  142 142 142  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  230 230 230
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  30 30 30  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  62 62 62  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  146 6 54  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  54 2 22  206 6 78
+214 6 82  198 6 74  14 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  118 2 46
+146 6 54  146 6 54  98 2 38  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  146 6 54  214 6 82  214 6 82  190 6 70
+162 6 62  2 2 2  42 2 14  70 2 26  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  86 86 86
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  190 190 190  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+38 38 38  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  26 26 26  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  186 186 186  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  218 218 218  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  54 54 54  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  14 14 14  250 250 250  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+194 194 194  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  138 138 138  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  234 234 234  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  26 26 26  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  98 2 38  214 6 82
+214 6 82  214 6 82  190 6 70  26 2 10  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  122 2 46  178 6 66
+214 6 82  214 6 82  162 6 62  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  62 2 22
+74 2 30  74 2 26  18 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  66 2 26  206 6 78  214 6 82  210 6 78  50 2 18
+38 2 14  2 2 2  94 2 34  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  110 110 110
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  162 162 162  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+54 54 54  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  50 50 50  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  50 50 50
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  186 186 186  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  218 218 218  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+230 230 230  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  214 214 214  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+222 222 222  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  138 138 138  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  182 182 182  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  18 18 18  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  38 2 14  210 6 78
+214 6 82  214 6 82  214 6 82  54 2 22  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  70 2 26  38 2 14  142 6 54
+166 6 62  214 6 82  210 6 78  70 2 26  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+62 2 22  206 6 78  214 6 82  214 6 82  186 6 70  30 2 10
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  130 130 130
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  142 142 142  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+62 62 62  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  38 38 38
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  182 182 182  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  222 222 222  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+158 158 158  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  186 186 186  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  134 134 134  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  130 130 130  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  202 6 74
+214 6 82  214 6 82  214 6 82  150 6 58  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  126 2 46  62 2 22  94 2 34
+74 2 26  206 6 78  214 6 82  210 6 78  70 2 26  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  6 2 2  6 2 2  122 2 46
+206 6 78  214 6 82  214 6 82  170 6 62  126 2 46  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  150 150 150
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  122 122 122  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  34 34 34
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  186 186 186  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  226 226 226  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+86 86 86  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  158 158 158  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  122 122 122  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  90 90 90  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  202 6 74
+214 6 82  214 6 82  214 6 82  154 6 58  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 2 18  142 6 54  162 6 62
+50 2 18  74 2 26  214 6 82  214 6 82  214 6 82  66 2 26
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  114 2 42  162 6 62  214 6 82
+214 6 82  214 6 82  174 6 66  18 2 6  50 2 18  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  170 170 170
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  118 118 118  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  22 22 22
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  186 186 186  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  242 242 242  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+34 34 34  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  126 126 126  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  214 214 214  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  210 210 210
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  62 62 62  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  202 6 74
+214 6 82  214 6 82  214 6 82  150 6 58  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  90 2 34  86 2 34
+174 6 66  142 6 54  70 2 26  214 6 82  214 6 82  214 6 82
+114 2 42  10 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 2 2  166 6 62  214 6 82  214 6 82  214 6 82
+214 6 82  174 6 66  18 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  178 178 178
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  118 118 118  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  10 10 10
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  206 206 206  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  246 246 246  6 6 6
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  242 242 242
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  106 106 106  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  110 110 110  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  18 18 18  34 34 34  50 50 50
+62 62 62  62 62 62  66 66 66  86 86 86  90 90 90  90 90 90
+90 90 90  66 66 66  42 42 42  30 30 30  218 218 218  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  190 190 190
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  94 2 34
+214 6 82  214 6 82  214 6 82  186 6 70  22 2 10  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  54 2 22
+14 2 6  118 2 46  142 6 54  62 2 22  214 6 82  214 6 82
+214 6 82  214 6 82  114 2 42  14 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 2 6  106 2 38
+114 2 42  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+78 2 30  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  178 178 178
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  122 122 122  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  18 18 18
+10 10 10  10 10 10  10 10 10  10 10 10  10 10 10  10 10 10
+10 10 10  10 10 10  10 10 10  10 10 10  10 10 10  10 10 10
+10 10 10  10 10 10  210 210 210  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  246 246 246  10 10 10
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  202 202 202
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  102 102 102  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  30 30 30  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  98 98 98  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  34 34 34  126 126 126
+186 186 186  230 230 230  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  182 182 182
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  94 2 34
+214 6 82  214 6 82  214 6 82  214 6 82  46 2 18  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  174 6 66  150 6 58  54 2 22  166 6 62
+214 6 82  214 6 82  214 6 82  210 6 78  210 6 78  118 2 46
+98 2 38  98 2 38  118 2 46  210 6 78  210 6 78  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  122 2 46  14 2 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  186 186 186
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  118 118 118  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  246 246 246  6 6 6
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  166 166 166
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  90 90 90  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  86 86 86  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  54 54 54  174 174 174  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  190 190 190
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  50 2 18
+210 6 78  214 6 82  214 6 82  214 6 82  50 2 18  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  14 2 6  126 2 46  206 6 78  154 6 58
+170 6 62  210 6 78  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  126 2 46  70 2 26  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  202 202 202
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  122 122 122  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  250 250 250  10 10 10
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  138 138 138
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  78 78 78  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  30 30 30  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  126 126 126  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  210 210 210
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+198 6 74  214 6 82  214 6 82  214 6 82  150 6 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  78 2 30  170 6 62
+210 6 78  110 2 42  26 2 10  114 2 42  126 2 46  126 2 46
+126 2 46  126 2 46  126 2 46  126 2 46  134 6 50  122 2 46
+18 2 6  18 2 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  206 206 206
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  118 118 118  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  242 242 242  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  130 130 130
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+150 150 150  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+154 6 58  214 6 82  214 6 82  214 6 82  206 6 78  106 2 38
+62 2 22  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  14 2 6
+74 2 26  138 6 50  186 6 70  98 2 38  82 2 30  62 2 22
+6 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  202 202 202
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  122 122 122  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  222 222 222  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  30 30 30  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  82 82 82
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  234 234 234  230 230 230  230 230 230
+230 230 230  230 230 230  230 230 230  230 230 230  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+86 2 34  214 6 82  214 6 82  214 6 82  214 6 82  214 6 82
+206 6 78  94 2 34  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  26 2 10  74 2 26  142 6 54  134 6 50
+114 2 42  114 2 42  110 2 42  90 2 34  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  206 206 206
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  118 118 118  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  202 202 202  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  206 206 206
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  230 230 230  150 150 150  86 86 86
+46 46 46  18 18 18  10 10 10  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  146 146 146  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+14 2 6  198 6 74  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  210 6 78  62 2 22  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  202 202 202
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  122 122 122  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  62 62 62  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  194 194 194  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  34 34 34  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  150 150 150  10 10 10  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  154 154 154  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  102 2 38  214 6 82  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  106 2 38  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  206 206 206
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  122 122 122  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 66 66  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  42 42 42  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  102 102 102  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  214 214 214  6 6 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  178 178 178  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  22 2 10  194 6 74  214 6 82  214 6 82  214 6 82
+214 6 82  198 6 74  122 2 46  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  194 194 194
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  146 146 146  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+86 86 86  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  34 34 34  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  74 74 74  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+234 234 234  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  102 102 102  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  146 146 146  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  126 126 126  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  178 178 178  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  162 6 62  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  98 2 38  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  182 182 182
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  170 170 170  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+94 94 94  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  34 34 34  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  78 78 78  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+198 198 198  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  118 118 118  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  174 174 174  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  78 78 78  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  202 202 202  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  58 2 22  214 6 82  214 6 82  214 6 82
+214 6 82  214 6 82  206 6 78  54 2 22  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  174 174 174
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  226 226 226  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+90 90 90  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  30 30 30  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  94 94 94  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+158 158 158  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  134 134 134  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  186 186 186  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  46 46 46  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  202 202 202  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  162 6 62  214 6 82  214 6 82
+214 6 82  214 6 82  214 6 82  82 2 30  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  162 162 162
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  6 6 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+102 102 102  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  22 22 22  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  102 102 102  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+118 118 118  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  138 138 138  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  82 82 82  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  202 202 202  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  26 26 26  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  206 206 206  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  22 2 10  190 6 70  214 6 82
+214 6 82  214 6 82  214 6 82  154 6 58  6 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  146 146 146
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  50 50 50  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+122 122 122  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  86 86 86  2 2 2  2 2 2
+2 2 2  10 10 10  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  114 114 114  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+82 82 82  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  134 134 134  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  78 78 78  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  218 218 218  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  222 222 222  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  218 218 218
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  102 2 38  214 6 82
+214 6 82  214 6 82  214 6 82  206 6 78  98 2 38  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  142 142 142
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  90 90 90  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+126 126 126  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  82 82 82  2 2 2  2 2 2
+2 2 2  6 6 6  246 246 246  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  130 130 130  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+26 26 26  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  138 138 138  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  70 70 70  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  234 234 234  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+242 242 242  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  6 6 6  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  238 238 238
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  26 2 10  186 6 70
+214 6 82  214 6 82  214 6 82  214 6 82  98 2 38  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  130 130 130
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  138 138 138  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+138 138 138  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  90 90 90  2 2 2  2 2 2
+2 2 2  2 2 2  238 238 238  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  94 94 94
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  134 134 134  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  202 202 202
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  134 134 134  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  54 54 54  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+238 238 238  6 6 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  58 58 58  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  238 238 238
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  50 2 18
+214 6 82  214 6 82  214 6 82  214 6 82  206 6 78  50 2 18
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  118 118 118
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  198 198 198  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+154 154 154  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  98 98 98  2 2 2  2 2 2
+2 2 2  2 2 2  222 222 222  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  118 118 118
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  162 162 162  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  150 150 150  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  54 54 54  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+238 238 238  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  142 142 142  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  242 242 242
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+102 2 38  214 6 82  214 6 82  214 6 82  214 6 82  206 6 78
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  98 98 98
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  238 238 238  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+150 150 150  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  114 114 114  2 2 2  2 2 2
+2 2 2  2 2 2  198 198 198  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  146 146 146
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  186 186 186  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  242 242 242  18 18 18
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  162 162 162  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  58 58 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  222 222 222  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  242 242 242
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  150 6 58  214 6 82  214 6 82  214 6 82  214 6 82
+150 6 58  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  78 78 78
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  42 42 42  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+178 178 178  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  110 110 110  2 2 2  2 2 2
+2 2 2  2 2 2  166 166 166  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  170 170 170
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  230 230 230  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  146 146 146  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  166 166 166  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  54 54 54  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  18 18 18  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  90 90 90  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  242 242 242
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  26 2 10  186 6 70  214 6 82  214 6 82  214 6 82
+214 6 82  202 6 74  6 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  50 50 50
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  122 122 122  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+198 198 198  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  114 114 114  2 2 2  2 2 2
+2 2 2  2 2 2  130 130 130  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  230 230 230
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  34 34 34  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  34 34 34  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  170 170 170  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  58 58 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  54 54 54  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  222 222 222  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 10 10  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  30 2 10  186 6 70  214 6 82  214 6 82
+214 6 82  214 6 82  50 2 18  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  30 30 30
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  218 218 218  6 6 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  10 10 10
+250 250 250  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  138 138 138  2 2 2  2 2 2
+2 2 2  2 2 2  94 94 94  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+62 62 62  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  106 106 106
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  102 102 102  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  170 170 170  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  190 190 190  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  54 54 54  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  222 222 222  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  102 102 102  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  106 106 106  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 14 14  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  242 242 242  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  34 2 14  214 6 82  214 6 82
+214 6 82  214 6 82  202 6 74  10 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  6 6 6
+250 250 250  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  114 114 114
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  90 90 90
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  166 166 166  2 2 2  2 2 2
+2 2 2  2 2 2  50 50 50  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+182 182 182  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  110 110 110
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  178 178 178  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  34 34 34  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  210 210 210  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  58 58 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  194 194 194  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  194 194 194  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+22 22 22  234 234 234  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+250 250 250  14 14 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 14 14  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  246 246 246  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  6 2 2  102 2 38  182 6 70
+214 6 82  214 6 82  214 6 82  134 6 50  126 2 46  6 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+226 226 226  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  250 250 250
+122 122 122  22 22 22  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  70 70 70  230 230 230
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  182 182 182  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  230 230 230  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  102 102 102  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  10 10 10  86 86 86  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  130 130 130
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  42 42 42  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  154 154 154  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  226 226 226  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  54 54 54  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  162 162 162  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  82 82 82  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  38 38 38
+206 206 206  254 254 254  254 254 254  246 246 246  178 178 178  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+246 246 246  10 10 10  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  22 22 22  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  14 14 14  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  26 2 10
+186 6 70  214 6 82  214 6 82  214 6 82  214 6 82  142 6 54
+10 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+190 190 190  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  214 214 214  182 182 182  162 162 162  138 138 138
+150 150 150  174 174 174  198 198 198  226 226 226  254 254 254  254 254 254
+234 234 234  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  202 202 202  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  154 154 154  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  162 162 162  46 46 46  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  74 74 74  226 226 226  150 150 150  2 2 2
+2 2 2  2 2 2  154 154 154  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  134 134 134
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+6 6 6  186 186 186  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  242 242 242  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  226 226 226  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  58 58 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  126 126 126  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  182 182 182  126 126 126  98 98 98
+78 78 78  78 78 78  78 78 78  118 118 118  182 182 182  250 250 250
+254 254 254  254 254 254  254 254 254  146 146 146  158 158 158  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  18 18 18  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  50 50 50  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  14 14 14  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+26 2 10  190 6 70  214 6 82  214 6 82  214 6 82  214 6 82
+138 6 50  38 2 14  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+138 138 138  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+138 138 138  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  226 226 226  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  42 42 42  250 250 250  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  222 222 222  182 182 182
+146 146 146  114 114 114  90 90 90  78 78 78  62 62 62  42 42 42
+22 22 22  18 18 18  18 18 18  22 22 22  46 46 46  58 58 58
+118 118 118  214 214 214  254 254 254  254 254 254  106 106 106  2 2 2
+2 2 2  2 2 2  158 158 158  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  142 142 142
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  50 50 50
+186 186 186  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  110 110 110  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  238 238 238  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  54 54 54  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  62 62 62  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  250 250 250  42 42 42  182 182 182  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  30 30 30  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  50 50 50  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  18 18 18  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  26 2 10  186 6 70  214 6 82  214 6 82  214 6 82
+214 6 82  154 6 58  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+70 70 70  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+46 46 46  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  18 18 18  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  146 146 146  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  42 42 42  2 2 2
+2 2 2  2 2 2  186 186 186  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  214 214 214
+106 106 106  70 70 70  42 42 42  34 34 34  34 34 34  42 42 42
+66 66 66  98 98 98  130 130 130  170 170 170  226 226 226  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+206 206 206  6 6 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  58 58 58  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  10 10 10  226 226 226
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  174 174 174  2 2 2  186 186 186  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  42 42 42  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  50 50 50  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  30 30 30  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  30 30 30  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  30 2 10  110 2 42  210 6 78  214 6 82
+214 6 82  194 6 74  122 2 46  10 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+10 10 10  234 234 234  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  178 178 178
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  74 74 74  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  14 14 14  214 214 214
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  250 250 250  10 10 10  2 2 2
+2 2 2  2 2 2  218 218 218  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+58 58 58  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+6 6 6  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  74 74 74  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  98 98 98
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  250 250 250  46 46 46  2 2 2  178 178 178  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  74 74 74  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  66 66 66  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  26 26 26  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  50 50 50  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  90 90 90  2 2 2  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  62 2 22  166 6 62
+210 6 78  214 6 82  214 6 82  162 6 62  86 2 34  62 2 22
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  118 118 118  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  78 78 78
+14 14 14  250 250 250  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  126 126 126  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  30 30 30
+218 218 218  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  246 246 246  2 2 2  2 2 2
+2 2 2  30 30 30  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  146 146 146
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+26 26 26  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  122 122 122  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+166 166 166  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  158 158 158  2 2 2  2 2 2  154 154 154  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  110 110 110  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  74 74 74  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  42 42 42  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  90 90 90  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  106 106 106  2 2 2  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+102 2 38  198 6 74  214 6 82  214 6 82  214 6 82  202 6 74
+62 2 22  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  6 6 6  178 178 178  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  170 170 170  2 2 2
+14 14 14  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  198 198 198  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+22 22 22  190 190 190  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  246 246 246  2 2 2  2 2 2
+2 2 2  110 110 110  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  198 198 198  10 10 10
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+62 62 62  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  214 214 214  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+6 6 6  142 142 142  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+234 234 234  26 26 26  2 2 2  2 2 2  154 154 154  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  146 146 146  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  94 94 94  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  82 82 82  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  118 118 118  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  158 158 158  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  22 2 10  114 2 42  202 6 74  214 6 82  214 6 82
+206 6 78  118 2 46  6 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 2 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  142 142 142  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  190 190 190  14 14 14  2 2 2
+10 10 10  246 246 246  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  58 58 58
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  110 110 110  234 234 234  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  246 246 246  2 2 2  2 2 2
+2 2 2  86 86 86  214 214 214  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  186 186 186  14 14 14  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+146 146 146  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  66 66 66
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  62 62 62  214 214 214  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  246 246 246
+70 70 70  2 2 2  2 2 2  2 2 2  126 126 126  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  238 238 238  14 14 14  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  154 154 154  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  162 162 162  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  158 158 158  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  230 230 230  6 6 6  2 2 2  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  22 2 10  90 2 34  162 6 62
+210 6 78  214 6 82  162 6 62  62 2 22  14 2 6  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  14 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  46 46 46  166 166 166
+238 238 238  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  222 222 222  102 102 102  2 2 2  2 2 2  2 2 2
+2 2 2  234 234 234  234 234 234  222 222 222  206 206 206  206 206 206
+206 206 206  206 206 206  206 206 206  222 222 222  230 230 230  150 150 150
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  14 14 14  90 90 90  154 154 154
+210 210 210  246 246 246  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  238 238 238  170 170 170  78 78 78  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  38 38 38  130 130 130  198 198 198
+250 250 250  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  206 206 206  90 90 90  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  34 34 34
+226 226 226  210 210 210  182 182 182  162 162 162  146 146 146  146 146 146
+146 146 146  146 146 146  146 146 146  174 174 174  206 206 206  178 178 178
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  6 6 6  86 86 86  190 190 190
+254 254 254  254 254 254  254 254 254  254 254 254  254 254 254  254 254 254
+254 254 254  254 254 254  254 254 254  234 234 234  154 154 154  30 30 30
+2 2 2  2 2 2  2 2 2  2 2 2  110 110 110  238 238 238
+230 230 230  210 210 210  206 206 206  206 206 206  206 206 206  206 206 206
+210 210 210  230 230 230  158 158 158  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  26 26 26  226 226 226  206 206 206
+178 178 178  170 170 170  170 170 170  170 170 170  170 170 170  182 182 182
+206 206 206  226 226 226  218 218 218  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  218 218 218  206 206 206  170 170 170
+146 146 146  146 146 146  146 146 146  146 146 146  150 150 150  174 174 174
+214 214 214  238 238 238  86 86 86  2 2 2  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+66 2 26  110 2 42  206 6 78  210 6 78  206 6 78  118 2 46
+118 2 46  118 2 46  18 2 6  6 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  6 6 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+6 6 6  46 46 46  82 82 82  90 90 90  90 90 90  90 90 90
+90 90 90  90 90 90  90 90 90  90 90 90  70 70 70  46 46 46
+18 18 18  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  6 6 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  10 10 10  42 42 42  62 62 62  78 78 78  94 94 94
+110 110 110  122 122 122  138 138 138  150 150 150  150 150 150  150 150 150
+150 150 150  150 150 150  150 150 150  142 142 142  126 126 126  102 102 102
+54 54 54  6 6 6  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+10 10 10  46 46 46  86 86 86  122 122 122  134 134 134  150 150 150
+150 150 150  150 150 150  150 150 150  150 150 150  150 150 150  150 150 150
+150 150 150  150 150 150  150 150 150  146 146 146  118 118 118  86 86 86
+34 34 34  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+30 30 30  78 78 78  90 90 90  90 90 90  90 90 90  90 90 90
+78 78 78  58 58 58  22 22 22  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  6 6 6
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  6 6 6  2 2 2  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+14 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+14 2 6  10 2 6  10 2 6  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  102 2 38
+102 2 38  102 2 38  102 2 38  102 2 38  14 2 6  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  14 2 6  10 2 6  10 2 6  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  2 2 2  2 2 2
+2 2 2  2 2 2  2 2 2  2 2 2  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+6 6 6  14 2 6  6 6 6  14 2 6  6 6 6  14 2 6
+10 2 6  14 2 6  10 2 6  14 2 6  10 2 6  14 2 6
+10 2 6  14 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  14 2 6  10 2 6  14 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  14 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  10 2 6  10 2 6
+10 2 6  10 2 6  10 2 6  10 2 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
+14 2 6  6 6 6  14 2 6  6 6 6  14 2 6  6 6 6
diff -Naur linux-2.6.17.orig/drivers/video/logo/logo_linux_debian_tux.ppm linux-2.6.17/drivers/video/logo/logo_linux_debian_tux.ppm
--- linux-2.6.17.orig/drivers/video/logo/logo_linux_debian_tux.ppm	1970-01-01 01:00:00.000000000 +0100
+++ linux-2.6.17/drivers/video/logo/logo_linux_debian_tux.ppm	2006-10-20 14:17:41.000000000 +0200
@@ -0,0 +1,19203 @@
+P3
+80 80
+255
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+6
+6
+6
+10
+10
+10
+10
+10
+10
+10
+10
+10
+6
+6
+6
+6
+6
+6
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+10
+10
+10
+14
+14
+14
+22
+22
+22
+26
+26
+26
+30
+30
+30
+34
+34
+34
+30
+30
+30
+30
+30
+30
+26
+26
+26
+18
+18
+18
+14
+14
+14
+10
+10
+10
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+26
+26
+26
+42
+42
+42
+54
+54
+54
+66
+66
+66
+78
+78
+78
+78
+78
+78
+78
+78
+78
+74
+74
+74
+66
+66
+66
+54
+54
+54
+42
+42
+42
+26
+26
+26
+18
+18
+18
+10
+10
+10
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+22
+22
+22
+42
+42
+42
+66
+66
+66
+86
+86
+86
+66
+66
+66
+38
+38
+38
+38
+38
+38
+22
+22
+22
+26
+26
+26
+34
+34
+34
+54
+54
+54
+66
+66
+66
+86
+86
+86
+70
+70
+70
+46
+46
+46
+26
+26
+26
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+26
+26
+26
+50
+50
+50
+82
+82
+82
+58
+58
+58
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+54
+54
+54
+86
+86
+86
+66
+66
+66
+38
+38
+38
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+50
+50
+50
+78
+78
+78
+34
+34
+34
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+70
+70
+70
+78
+78
+78
+46
+46
+46
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+42
+42
+42
+82
+82
+82
+26
+26
+26
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+14
+14
+14
+46
+46
+46
+34
+34
+34
+6
+6
+6
+2
+2
+6
+42
+42
+42
+78
+78
+78
+42
+42
+42
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+66
+66
+66
+58
+58
+58
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+26
+26
+26
+86
+86
+86
+101
+101
+101
+46
+46
+46
+10
+10
+10
+2
+2
+6
+58
+58
+58
+70
+70
+70
+34
+34
+34
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+42
+42
+42
+86
+86
+86
+10
+10
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+30
+30
+30
+94
+94
+94
+94
+94
+94
+58
+58
+58
+26
+26
+26
+2
+2
+6
+6
+6
+6
+78
+78
+78
+54
+54
+54
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+62
+62
+62
+62
+62
+62
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+26
+26
+26
+54
+54
+54
+38
+38
+38
+18
+18
+18
+10
+10
+10
+2
+2
+6
+2
+2
+6
+34
+34
+34
+82
+82
+82
+38
+38
+38
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+30
+30
+30
+78
+78
+78
+30
+30
+30
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+10
+10
+10
+10
+10
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+78
+78
+78
+50
+50
+50
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+38
+38
+38
+86
+86
+86
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+54
+54
+54
+66
+66
+66
+26
+26
+26
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+42
+42
+42
+82
+82
+82
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+10
+10
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+14
+14
+14
+10
+10
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+18
+18
+18
+82
+82
+82
+34
+34
+34
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+46
+46
+46
+86
+86
+86
+2
+2
+6
+2
+2
+6
+6
+6
+6
+6
+6
+6
+22
+22
+22
+34
+34
+34
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+18
+18
+18
+34
+34
+34
+10
+10
+10
+50
+50
+50
+22
+22
+22
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+10
+10
+10
+86
+86
+86
+42
+42
+42
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+46
+46
+46
+86
+86
+86
+2
+2
+6
+2
+2
+6
+38
+38
+38
+116
+116
+116
+94
+94
+94
+22
+22
+22
+22
+22
+22
+2
+2
+6
+2
+2
+6
+2
+2
+6
+14
+14
+14
+86
+86
+86
+138
+138
+138
+162
+162
+162
+154
+154
+154
+38
+38
+38
+26
+26
+26
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+86
+86
+86
+46
+46
+46
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+46
+46
+46
+86
+86
+86
+2
+2
+6
+14
+14
+14
+134
+134
+134
+198
+198
+198
+195
+195
+195
+116
+116
+116
+10
+10
+10
+2
+2
+6
+2
+2
+6
+6
+6
+6
+101
+98
+89
+187
+187
+187
+210
+210
+210
+218
+218
+218
+214
+214
+214
+134
+134
+134
+14
+14
+14
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+86
+86
+86
+50
+50
+50
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+46
+46
+46
+86
+86
+86
+2
+2
+6
+54
+54
+54
+218
+218
+218
+195
+195
+195
+226
+226
+226
+246
+246
+246
+58
+58
+58
+2
+2
+6
+2
+2
+6
+30
+30
+30
+210
+210
+210
+253
+253
+253
+174
+174
+174
+123
+123
+123
+221
+221
+221
+234
+234
+234
+74
+74
+74
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+70
+70
+70
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+46
+46
+46
+82
+82
+82
+2
+2
+6
+106
+106
+106
+170
+170
+170
+26
+26
+26
+86
+86
+86
+226
+226
+226
+123
+123
+123
+10
+10
+10
+14
+14
+14
+46
+46
+46
+231
+231
+231
+190
+190
+190
+6
+6
+6
+70
+70
+70
+90
+90
+90
+238
+238
+238
+158
+158
+158
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+70
+70
+70
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+42
+42
+42
+86
+86
+86
+6
+6
+6
+116
+116
+116
+106
+106
+106
+6
+6
+6
+70
+70
+70
+149
+149
+149
+128
+128
+128
+18
+18
+18
+38
+38
+38
+54
+54
+54
+221
+221
+221
+106
+106
+106
+2
+2
+6
+14
+14
+14
+46
+46
+46
+190
+190
+190
+198
+198
+198
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+74
+74
+74
+62
+62
+62
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+42
+42
+42
+94
+94
+94
+14
+14
+14
+101
+101
+101
+128
+128
+128
+2
+2
+6
+18
+18
+18
+116
+116
+116
+118
+98
+46
+121
+92
+8
+121
+92
+8
+98
+78
+10
+162
+162
+162
+106
+106
+106
+2
+2
+6
+2
+2
+6
+2
+2
+6
+195
+195
+195
+195
+195
+195
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+74
+74
+74
+62
+62
+62
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+1
+0
+0
+1
+0
+0
+1
+0
+0
+0
+0
+0
+1
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+38
+38
+38
+90
+90
+90
+14
+14
+14
+58
+58
+58
+210
+210
+210
+26
+26
+26
+54
+38
+6
+154
+114
+10
+226
+170
+11
+236
+186
+11
+225
+175
+15
+184
+144
+12
+215
+174
+15
+175
+146
+61
+37
+26
+9
+2
+2
+6
+70
+70
+70
+246
+246
+246
+138
+138
+138
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+70
+70
+70
+66
+66
+66
+26
+26
+26
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+38
+38
+38
+86
+86
+86
+14
+14
+14
+10
+10
+10
+195
+195
+195
+188
+164
+115
+192
+133
+9
+225
+175
+15
+239
+182
+13
+234
+190
+10
+232
+195
+16
+232
+200
+30
+245
+207
+45
+241
+208
+19
+232
+195
+16
+184
+144
+12
+218
+194
+134
+211
+206
+186
+42
+42
+42
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+50
+50
+50
+74
+74
+74
+30
+30
+30
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+34
+34
+34
+86
+86
+86
+14
+14
+14
+2
+2
+6
+121
+87
+25
+192
+133
+9
+219
+162
+10
+239
+182
+13
+236
+186
+11
+232
+195
+16
+241
+208
+19
+244
+214
+54
+246
+218
+60
+246
+218
+38
+246
+215
+20
+241
+208
+19
+241
+208
+19
+226
+184
+13
+121
+87
+25
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+50
+50
+50
+82
+82
+82
+34
+34
+34
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+34
+34
+34
+82
+82
+82
+30
+30
+30
+61
+42
+6
+180
+123
+7
+206
+145
+10
+230
+174
+11
+239
+182
+13
+234
+190
+10
+238
+202
+15
+241
+208
+19
+246
+218
+74
+246
+218
+38
+246
+215
+20
+246
+215
+20
+246
+215
+20
+226
+184
+13
+215
+174
+15
+184
+144
+12
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+26
+26
+26
+94
+94
+94
+42
+42
+42
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+78
+78
+78
+50
+50
+50
+104
+69
+6
+192
+133
+9
+216
+158
+10
+236
+178
+12
+236
+186
+11
+232
+195
+16
+241
+208
+19
+244
+214
+54
+245
+215
+43
+246
+215
+20
+246
+215
+20
+241
+208
+19
+198
+155
+10
+200
+144
+11
+216
+158
+10
+156
+118
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+90
+90
+90
+54
+54
+54
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+78
+78
+78
+46
+46
+46
+22
+22
+22
+137
+92
+6
+210
+162
+10
+239
+182
+13
+238
+190
+10
+238
+202
+15
+241
+208
+19
+246
+215
+20
+246
+215
+20
+241
+208
+19
+203
+166
+17
+185
+133
+11
+210
+150
+10
+216
+158
+10
+210
+150
+10
+102
+78
+10
+2
+2
+6
+6
+6
+6
+54
+54
+54
+14
+14
+14
+2
+2
+6
+2
+2
+6
+62
+62
+62
+74
+74
+74
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+34
+34
+34
+78
+78
+78
+50
+50
+50
+6
+6
+6
+94
+70
+30
+139
+102
+15
+190
+146
+13
+226
+184
+13
+232
+200
+30
+232
+195
+16
+215
+174
+15
+190
+146
+13
+168
+122
+10
+192
+133
+9
+210
+150
+10
+213
+154
+11
+202
+150
+34
+182
+157
+106
+101
+98
+89
+2
+2
+6
+2
+2
+6
+78
+78
+78
+116
+116
+116
+58
+58
+58
+2
+2
+6
+22
+22
+22
+90
+90
+90
+46
+46
+46
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+38
+38
+38
+86
+86
+86
+50
+50
+50
+6
+6
+6
+128
+128
+128
+174
+154
+114
+156
+107
+11
+168
+122
+10
+198
+155
+10
+184
+144
+12
+197
+138
+11
+200
+144
+11
+206
+145
+10
+206
+145
+10
+197
+138
+11
+188
+164
+115
+195
+195
+195
+198
+198
+198
+174
+174
+174
+14
+14
+14
+2
+2
+6
+22
+22
+22
+116
+116
+116
+116
+116
+116
+22
+22
+22
+2
+2
+6
+74
+74
+74
+70
+70
+70
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+50
+50
+50
+101
+101
+101
+26
+26
+26
+10
+10
+10
+138
+138
+138
+190
+190
+190
+174
+154
+114
+156
+107
+11
+197
+138
+11
+200
+144
+11
+197
+138
+11
+192
+133
+9
+180
+123
+7
+190
+142
+34
+190
+178
+144
+187
+187
+187
+202
+202
+202
+221
+221
+221
+214
+214
+214
+66
+66
+66
+2
+2
+6
+2
+2
+6
+50
+50
+50
+62
+62
+62
+6
+6
+6
+2
+2
+6
+10
+10
+10
+90
+90
+90
+50
+50
+50
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+34
+34
+34
+74
+74
+74
+74
+74
+74
+2
+2
+6
+6
+6
+6
+144
+144
+144
+198
+198
+198
+190
+190
+190
+178
+166
+146
+154
+121
+60
+156
+107
+11
+156
+107
+11
+168
+124
+44
+174
+154
+114
+187
+187
+187
+190
+190
+190
+210
+210
+210
+246
+246
+246
+253
+253
+253
+253
+253
+253
+182
+182
+182
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+62
+62
+62
+74
+74
+74
+34
+34
+34
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+22
+22
+22
+54
+54
+54
+94
+94
+94
+18
+18
+18
+2
+2
+6
+46
+46
+46
+234
+234
+234
+221
+221
+221
+190
+190
+190
+190
+190
+190
+190
+190
+190
+187
+187
+187
+187
+187
+187
+190
+190
+190
+190
+190
+190
+195
+195
+195
+214
+214
+214
+242
+242
+242
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+82
+82
+82
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+14
+14
+14
+86
+86
+86
+54
+54
+54
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+46
+46
+46
+90
+90
+90
+46
+46
+46
+18
+18
+18
+6
+6
+6
+182
+182
+182
+253
+253
+253
+246
+246
+246
+206
+206
+206
+190
+190
+190
+190
+190
+190
+190
+190
+190
+190
+190
+190
+190
+190
+190
+206
+206
+206
+231
+231
+231
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+202
+202
+202
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+42
+42
+42
+86
+86
+86
+42
+42
+42
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+38
+38
+38
+74
+74
+74
+66
+66
+66
+2
+2
+6
+6
+6
+6
+90
+90
+90
+250
+250
+250
+253
+253
+253
+253
+253
+253
+238
+238
+238
+198
+198
+198
+190
+190
+190
+190
+190
+190
+195
+195
+195
+221
+221
+221
+246
+246
+246
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+82
+82
+82
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+78
+78
+78
+70
+70
+70
+34
+34
+34
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+34
+34
+34
+66
+66
+66
+78
+78
+78
+6
+6
+6
+2
+2
+6
+18
+18
+18
+218
+218
+218
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+246
+246
+246
+226
+226
+226
+231
+231
+231
+246
+246
+246
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+178
+178
+178
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+18
+18
+18
+90
+90
+90
+62
+62
+62
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+26
+26
+26
+58
+58
+58
+90
+90
+90
+18
+18
+18
+2
+2
+6
+2
+2
+6
+110
+110
+110
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+231
+231
+231
+18
+18
+18
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+18
+18
+18
+94
+94
+94
+54
+54
+54
+26
+26
+26
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+50
+50
+50
+90
+90
+90
+26
+26
+26
+2
+2
+6
+2
+2
+6
+14
+14
+14
+195
+195
+195
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+242
+242
+242
+54
+54
+54
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+38
+38
+38
+86
+86
+86
+50
+50
+50
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+38
+38
+38
+82
+82
+82
+34
+34
+34
+2
+2
+6
+2
+2
+6
+2
+2
+6
+42
+42
+42
+195
+195
+195
+246
+246
+246
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+248
+223
+230
+224
+112
+142
+213
+64
+104
+210
+48
+92
+213
+64
+104
+227
+127
+154
+244
+207
+217
+253
+253
+253
+253
+253
+253
+250
+250
+250
+246
+246
+246
+238
+238
+238
+226
+226
+226
+231
+231
+231
+101
+101
+101
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+38
+38
+38
+82
+82
+82
+42
+42
+42
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+26
+26
+26
+62
+62
+62
+66
+66
+66
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+70
+70
+70
+170
+170
+170
+206
+206
+206
+234
+234
+234
+246
+246
+246
+250
+250
+250
+250
+250
+250
+220
+96
+130
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+206
+32
+79
+227
+127
+154
+206
+206
+206
+202
+202
+202
+202
+202
+202
+198
+198
+198
+202
+202
+202
+182
+182
+182
+18
+18
+18
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+62
+62
+62
+66
+66
+66
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+42
+42
+42
+82
+82
+82
+18
+18
+18
+2
+2
+6
+2
+2
+6
+2
+2
+6
+10
+10
+10
+94
+94
+94
+182
+182
+182
+218
+218
+218
+242
+242
+242
+250
+250
+250
+253
+253
+253
+227
+127
+154
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+199
+0
+54
+203
+16
+67
+241
+191
+205
+202
+202
+202
+195
+195
+195
+195
+195
+195
+210
+210
+210
+158
+158
+158
+6
+6
+6
+14
+14
+14
+50
+50
+50
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+86
+86
+86
+46
+46
+46
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+54
+54
+54
+70
+70
+70
+2
+2
+6
+2
+2
+6
+10
+10
+10
+2
+2
+6
+22
+22
+22
+166
+166
+166
+231
+231
+231
+250
+250
+250
+253
+253
+253
+253
+253
+253
+220
+96
+130
+199
+0
+54
+199
+0
+54
+199
+0
+54
+206
+32
+79
+234
+159
+179
+237
+175
+192
+255
+255
+255
+241
+191
+205
+234
+159
+179
+213
+64
+104
+199
+0
+54
+199
+0
+54
+199
+0
+54
+234
+159
+179
+231
+231
+231
+206
+206
+206
+198
+198
+198
+226
+226
+226
+94
+94
+94
+2
+2
+6
+6
+6
+6
+38
+38
+38
+30
+30
+30
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+62
+62
+62
+66
+66
+66
+26
+26
+26
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+74
+74
+74
+50
+50
+50
+2
+2
+6
+26
+26
+26
+26
+26
+26
+2
+2
+6
+106
+106
+106
+238
+238
+238
+253
+253
+253
+253
+253
+253
+253
+253
+253
+217
+80
+117
+199
+0
+54
+199
+0
+54
+210
+48
+92
+227
+127
+154
+251
+239
+242
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+234
+159
+179
+199
+0
+54
+199
+0
+54
+199
+0
+54
+241
+191
+205
+246
+246
+246
+218
+218
+218
+202
+202
+202
+210
+210
+210
+14
+14
+14
+2
+2
+6
+2
+2
+6
+30
+30
+30
+22
+22
+22
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+18
+18
+18
+86
+86
+86
+42
+42
+42
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+42
+42
+42
+90
+90
+90
+22
+22
+22
+2
+2
+6
+42
+42
+42
+2
+2
+6
+18
+18
+18
+218
+218
+218
+253
+253
+253
+253
+253
+253
+253
+253
+253
+237
+175
+192
+199
+0
+54
+199
+0
+54
+199
+0
+54
+248
+223
+230
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+199
+0
+54
+199
+0
+54
+199
+0
+54
+203
+16
+67
+251
+239
+242
+250
+250
+250
+221
+221
+221
+218
+218
+218
+101
+101
+101
+2
+2
+6
+14
+14
+14
+18
+18
+18
+38
+38
+38
+10
+10
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+78
+78
+78
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+54
+54
+54
+82
+82
+82
+2
+2
+6
+26
+26
+26
+22
+22
+22
+2
+2
+6
+123
+123
+123
+253
+253
+253
+253
+253
+253
+241
+191
+205
+244
+207
+217
+206
+32
+79
+199
+0
+54
+203
+16
+67
+237
+175
+192
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+230
+143
+167
+199
+0
+54
+199
+0
+54
+199
+0
+54
+230
+143
+167
+253
+253
+253
+250
+250
+250
+238
+238
+238
+198
+198
+198
+6
+6
+6
+38
+38
+38
+58
+58
+58
+26
+26
+26
+38
+38
+38
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+46
+46
+46
+78
+78
+78
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+74
+74
+74
+58
+58
+58
+2
+2
+6
+42
+42
+42
+2
+2
+6
+22
+22
+22
+231
+231
+231
+253
+253
+253
+253
+253
+253
+237
+175
+192
+199
+0
+54
+199
+0
+54
+234
+159
+179
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+241
+191
+205
+210
+48
+92
+213
+64
+104
+227
+127
+154
+251
+239
+242
+255
+255
+255
+255
+255
+255
+234
+159
+179
+199
+0
+54
+199
+0
+54
+234
+159
+179
+253
+253
+253
+253
+253
+253
+253
+253
+253
+246
+246
+246
+46
+46
+46
+38
+38
+38
+42
+42
+42
+14
+14
+14
+38
+38
+38
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+86
+86
+86
+46
+46
+46
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+42
+42
+42
+90
+90
+90
+18
+18
+18
+18
+18
+18
+26
+26
+26
+2
+2
+6
+116
+116
+116
+253
+253
+253
+253
+253
+253
+253
+253
+253
+220
+96
+130
+199
+0
+54
+199
+0
+54
+251
+239
+242
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+234
+159
+179
+203
+16
+67
+251
+239
+242
+255
+255
+255
+244
+207
+217
+227
+127
+154
+251
+239
+242
+255
+255
+255
+248
+223
+230
+199
+0
+54
+199
+0
+54
+224
+112
+142
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+94
+94
+94
+6
+6
+6
+2
+2
+6
+2
+2
+6
+10
+10
+10
+34
+34
+34
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+74
+74
+74
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+26
+26
+26
+66
+66
+66
+82
+82
+82
+2
+2
+6
+38
+38
+38
+6
+6
+6
+14
+14
+14
+210
+210
+210
+253
+253
+253
+253
+253
+253
+253
+253
+253
+210
+48
+92
+199
+0
+54
+227
+127
+154
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+248
+223
+230
+206
+32
+79
+244
+207
+217
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+199
+0
+54
+199
+0
+54
+241
+191
+205
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+144
+144
+144
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+46
+46
+46
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+42
+42
+42
+74
+74
+74
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+42
+42
+42
+90
+90
+90
+26
+26
+26
+6
+6
+6
+42
+42
+42
+2
+2
+6
+74
+74
+74
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+203
+16
+67
+199
+0
+54
+248
+223
+230
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+220
+96
+130
+227
+127
+154
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+199
+0
+54
+199
+0
+54
+230
+143
+167
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+182
+182
+182
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+46
+46
+46
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+10
+10
+10
+86
+86
+86
+38
+38
+38
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+26
+26
+26
+66
+66
+66
+82
+82
+82
+2
+2
+6
+22
+22
+22
+18
+18
+18
+2
+2
+6
+149
+149
+149
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+213
+64
+104
+199
+0
+54
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+203
+16
+67
+248
+223
+230
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+199
+0
+54
+199
+0
+54
+244
+207
+217
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+206
+206
+206
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+38
+38
+38
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+86
+86
+86
+46
+46
+46
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+46
+46
+46
+86
+86
+86
+18
+18
+18
+2
+2
+6
+34
+34
+34
+10
+10
+10
+6
+6
+6
+210
+210
+210
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+199
+0
+54
+199
+0
+54
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+199
+0
+54
+244
+207
+217
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+251
+239
+242
+199
+0
+54
+203
+16
+67
+234
+159
+179
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+221
+221
+221
+6
+6
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+30
+30
+30
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+82
+82
+82
+54
+54
+54
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+26
+26
+26
+66
+66
+66
+62
+62
+62
+2
+2
+6
+2
+2
+6
+38
+38
+38
+10
+10
+10
+26
+26
+26
+238
+238
+238
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+199
+0
+54
+213
+64
+104
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+213
+64
+104
+217
+80
+117
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+199
+0
+54
+203
+16
+67
+234
+159
+179
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+231
+231
+231
+6
+6
+6
+2
+2
+6
+2
+2
+6
+10
+10
+10
+30
+30
+30
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+66
+66
+66
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+38
+38
+38
+78
+78
+78
+6
+6
+6
+2
+2
+6
+2
+2
+6
+46
+46
+46
+14
+14
+14
+42
+42
+42
+246
+246
+246
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+213
+64
+104
+199
+0
+54
+251
+239
+242
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+248
+223
+230
+213
+64
+104
+199
+0
+54
+234
+159
+179
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+220
+96
+130
+199
+0
+54
+237
+175
+192
+241
+191
+205
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+234
+234
+234
+10
+10
+10
+2
+2
+6
+2
+2
+6
+22
+22
+22
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+66
+66
+66
+62
+62
+62
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+50
+50
+50
+74
+74
+74
+2
+2
+6
+2
+2
+6
+14
+14
+14
+70
+70
+70
+34
+34
+34
+62
+62
+62
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+213
+64
+104
+199
+0
+54
+241
+191
+205
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+251
+239
+242
+206
+32
+79
+206
+32
+79
+199
+0
+54
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+234
+159
+179
+199
+0
+54
+230
+143
+167
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+234
+234
+234
+14
+14
+14
+2
+2
+6
+2
+2
+6
+30
+30
+30
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+66
+66
+66
+62
+62
+62
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+54
+54
+54
+62
+62
+62
+2
+2
+6
+2
+2
+6
+2
+2
+6
+30
+30
+30
+46
+46
+46
+70
+70
+70
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+224
+112
+142
+199
+0
+54
+227
+127
+154
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+248
+223
+230
+234
+159
+179
+199
+0
+54
+206
+32
+79
+220
+96
+130
+220
+96
+130
+206
+32
+79
+199
+0
+54
+244
+207
+217
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+226
+226
+226
+10
+10
+10
+2
+2
+6
+6
+6
+6
+30
+30
+30
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+66
+66
+66
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+58
+58
+58
+62
+62
+62
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+30
+30
+30
+78
+78
+78
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+237
+175
+192
+199
+0
+54
+210
+48
+92
+241
+191
+205
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+244
+207
+217
+206
+32
+79
+213
+64
+104
+213
+64
+104
+227
+127
+154
+244
+207
+217
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+206
+206
+206
+2
+2
+6
+22
+22
+22
+34
+34
+34
+18
+14
+6
+22
+22
+22
+26
+26
+26
+18
+18
+18
+6
+6
+6
+2
+2
+6
+2
+2
+6
+82
+82
+82
+54
+54
+54
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+26
+26
+26
+62
+62
+62
+106
+106
+106
+74
+54
+14
+185
+133
+11
+210
+162
+10
+121
+92
+8
+6
+6
+6
+62
+62
+62
+238
+238
+238
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+203
+16
+67
+199
+0
+54
+203
+16
+67
+251
+239
+242
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+251
+239
+242
+241
+191
+205
+241
+191
+205
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+158
+158
+158
+18
+18
+18
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+18
+18
+18
+66
+66
+66
+38
+38
+38
+6
+6
+6
+94
+94
+94
+50
+50
+50
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+10
+10
+10
+10
+10
+10
+18
+18
+18
+38
+38
+38
+78
+78
+78
+142
+134
+106
+216
+158
+10
+242
+186
+14
+246
+190
+14
+246
+190
+14
+156
+118
+10
+10
+10
+10
+90
+90
+90
+238
+238
+238
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+227
+127
+154
+199
+0
+54
+199
+0
+54
+244
+207
+217
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+246
+230
+190
+238
+204
+91
+238
+204
+91
+181
+142
+44
+37
+26
+9
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+38
+38
+38
+46
+46
+46
+26
+26
+26
+106
+106
+106
+54
+54
+54
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+22
+22
+22
+30
+30
+30
+38
+38
+38
+50
+50
+50
+70
+70
+70
+106
+106
+106
+190
+142
+34
+226
+170
+11
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+154
+114
+10
+6
+6
+6
+74
+74
+74
+226
+226
+226
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+230
+143
+167
+199
+0
+54
+203
+16
+67
+251
+239
+242
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+228
+184
+62
+241
+196
+14
+241
+208
+19
+232
+195
+16
+38
+30
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+30
+30
+30
+26
+26
+26
+203
+166
+17
+154
+142
+90
+66
+66
+66
+26
+26
+26
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+38
+38
+38
+58
+58
+58
+78
+78
+78
+86
+86
+86
+101
+101
+101
+123
+123
+123
+175
+146
+61
+210
+150
+10
+234
+174
+13
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+238
+190
+10
+102
+78
+10
+2
+2
+6
+46
+46
+46
+198
+198
+198
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+213
+64
+104
+199
+0
+54
+220
+96
+130
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+224
+178
+62
+242
+186
+14
+241
+196
+14
+210
+166
+10
+22
+18
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+121
+92
+8
+238
+202
+15
+232
+195
+16
+82
+82
+82
+34
+34
+34
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+38
+38
+38
+70
+70
+70
+154
+122
+46
+190
+142
+34
+200
+144
+11
+197
+138
+11
+197
+138
+11
+213
+154
+11
+226
+170
+11
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+225
+175
+15
+46
+32
+6
+2
+2
+6
+22
+22
+22
+158
+158
+158
+250
+250
+250
+253
+253
+253
+253
+253
+253
+251
+239
+242
+210
+48
+92
+199
+0
+54
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+242
+242
+242
+224
+178
+62
+239
+182
+13
+236
+186
+11
+213
+154
+11
+46
+32
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+61
+42
+6
+225
+175
+15
+238
+190
+10
+236
+186
+11
+112
+100
+78
+42
+42
+42
+14
+14
+14
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+54
+54
+54
+154
+122
+46
+213
+154
+11
+226
+170
+11
+230
+174
+11
+226
+170
+11
+226
+170
+11
+236
+178
+12
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+241
+196
+14
+184
+144
+12
+10
+10
+10
+2
+2
+6
+6
+6
+6
+116
+116
+116
+242
+242
+242
+253
+253
+253
+253
+253
+253
+244
+207
+217
+206
+32
+79
+220
+96
+130
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+231
+231
+231
+198
+198
+198
+214
+170
+54
+236
+178
+12
+236
+178
+12
+210
+150
+10
+137
+92
+6
+18
+14
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+70
+47
+6
+200
+144
+11
+236
+178
+12
+239
+182
+13
+239
+182
+13
+124
+112
+88
+58
+58
+58
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+70
+70
+70
+180
+133
+36
+226
+170
+11
+239
+182
+13
+242
+186
+14
+242
+186
+14
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+232
+195
+16
+98
+70
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+66
+66
+66
+221
+221
+221
+253
+253
+253
+253
+253
+253
+251
+239
+242
+199
+0
+54
+217
+80
+117
+251
+239
+242
+255
+255
+255
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+206
+206
+206
+198
+198
+198
+214
+166
+58
+230
+174
+11
+230
+174
+11
+216
+158
+10
+192
+133
+9
+163
+110
+8
+116
+81
+8
+102
+78
+10
+116
+81
+8
+167
+114
+7
+197
+138
+11
+226
+170
+11
+239
+182
+13
+242
+186
+14
+242
+186
+14
+162
+146
+94
+78
+78
+78
+34
+34
+34
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+30
+30
+30
+78
+78
+78
+190
+142
+34
+226
+170
+11
+239
+182
+13
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+241
+196
+14
+203
+166
+17
+22
+18
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+38
+38
+38
+218
+218
+218
+253
+253
+253
+253
+253
+253
+227
+127
+154
+203
+16
+67
+199
+0
+54
+234
+159
+179
+255
+255
+255
+255
+255
+255
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+206
+206
+206
+198
+198
+198
+202
+162
+69
+226
+170
+11
+236
+178
+12
+224
+166
+10
+210
+150
+10
+200
+144
+11
+197
+138
+11
+192
+133
+9
+197
+138
+11
+210
+150
+10
+226
+170
+11
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+225
+175
+15
+124
+112
+88
+62
+62
+62
+30
+30
+30
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+78
+78
+78
+174
+135
+50
+224
+166
+10
+239
+182
+13
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+241
+196
+14
+139
+102
+15
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+78
+78
+78
+250
+250
+250
+253
+253
+253
+253
+253
+253
+251
+239
+242
+230
+143
+167
+210
+48
+92
+220
+96
+130
+241
+191
+205
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+214
+214
+214
+198
+198
+198
+190
+150
+46
+219
+162
+10
+236
+178
+12
+234
+174
+13
+224
+166
+10
+216
+158
+10
+213
+154
+11
+213
+154
+11
+216
+158
+10
+226
+170
+11
+239
+182
+13
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+242
+186
+14
+206
+162
+42
+101
+101
+101
+58
+58
+58
+30
+30
+30
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+74
+74
+74
+174
+135
+50
+216
+158
+10
+236
+178
+12
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+241
+196
+14
+226
+184
+13
+61
+42
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+22
+22
+22
+238
+238
+238
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+226
+226
+226
+187
+187
+187
+180
+133
+36
+216
+158
+10
+236
+178
+12
+239
+182
+13
+236
+178
+12
+230
+174
+11
+226
+170
+11
+226
+170
+11
+230
+174
+11
+236
+178
+12
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+239
+182
+13
+206
+162
+42
+106
+106
+106
+66
+66
+66
+34
+34
+34
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+26
+26
+26
+70
+70
+70
+163
+133
+67
+213
+154
+11
+236
+178
+12
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+241
+196
+14
+190
+146
+13
+18
+14
+6
+2
+2
+6
+2
+2
+6
+46
+46
+46
+246
+246
+246
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+221
+221
+221
+86
+86
+86
+156
+107
+11
+216
+158
+10
+236
+178
+12
+242
+186
+14
+246
+186
+14
+242
+186
+14
+239
+182
+13
+239
+182
+13
+242
+186
+14
+242
+186
+14
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+242
+186
+14
+225
+175
+15
+142
+122
+72
+66
+66
+66
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+26
+26
+26
+70
+70
+70
+163
+133
+67
+210
+150
+10
+236
+178
+12
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+232
+195
+16
+121
+92
+8
+34
+34
+34
+106
+106
+106
+221
+221
+221
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+242
+242
+242
+82
+82
+82
+18
+14
+6
+163
+110
+8
+216
+158
+10
+236
+178
+12
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+242
+186
+14
+163
+133
+67
+46
+46
+46
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+10
+10
+10
+30
+30
+30
+78
+78
+78
+163
+133
+67
+210
+150
+10
+236
+178
+12
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+241
+196
+14
+215
+174
+15
+190
+178
+144
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+218
+218
+218
+58
+58
+58
+2
+2
+6
+22
+18
+6
+167
+114
+7
+216
+158
+10
+236
+178
+12
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+242
+186
+14
+190
+150
+46
+54
+54
+54
+22
+22
+22
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+38
+38
+38
+86
+86
+86
+180
+133
+36
+213
+154
+11
+236
+178
+12
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+232
+195
+16
+190
+146
+13
+214
+214
+214
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+170
+170
+170
+26
+26
+26
+2
+2
+6
+2
+2
+6
+37
+26
+9
+163
+110
+8
+219
+162
+10
+239
+182
+13
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+236
+178
+12
+224
+166
+10
+142
+122
+72
+46
+46
+46
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+50
+50
+50
+109
+106
+95
+192
+133
+9
+224
+166
+10
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+242
+186
+14
+226
+184
+13
+210
+162
+10
+142
+110
+46
+226
+226
+226
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+253
+198
+198
+198
+66
+66
+66
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+50
+34
+6
+156
+107
+11
+219
+162
+10
+239
+182
+13
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+242
+186
+14
+234
+174
+13
+213
+154
+11
+154
+122
+46
+66
+66
+66
+30
+30
+30
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+58
+58
+58
+154
+121
+60
+206
+145
+10
+234
+174
+13
+242
+186
+14
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+236
+178
+12
+210
+162
+10
+163
+110
+8
+61
+42
+6
+138
+138
+138
+218
+218
+218
+250
+250
+250
+253
+253
+253
+253
+253
+253
+253
+253
+253
+250
+250
+250
+242
+242
+242
+210
+210
+210
+144
+144
+144
+66
+66
+66
+6
+6
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+61
+42
+6
+163
+110
+8
+216
+158
+10
+236
+178
+12
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+239
+182
+13
+230
+174
+11
+216
+158
+10
+190
+142
+34
+124
+112
+88
+70
+70
+70
+38
+38
+38
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+22
+22
+22
+62
+62
+62
+168
+124
+44
+206
+145
+10
+224
+166
+10
+236
+178
+12
+239
+182
+13
+242
+186
+14
+242
+186
+14
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+236
+178
+12
+216
+158
+10
+175
+118
+6
+80
+54
+7
+2
+2
+6
+6
+6
+6
+30
+30
+30
+54
+54
+54
+62
+62
+62
+50
+50
+50
+38
+38
+38
+14
+14
+14
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+80
+54
+7
+167
+114
+7
+213
+154
+11
+236
+178
+12
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+242
+186
+14
+239
+182
+13
+239
+182
+13
+230
+174
+11
+210
+150
+10
+174
+135
+50
+124
+112
+88
+82
+82
+82
+54
+54
+54
+34
+34
+34
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+50
+50
+50
+158
+118
+36
+192
+133
+9
+200
+144
+11
+216
+158
+10
+219
+162
+10
+224
+166
+10
+226
+170
+11
+230
+174
+11
+236
+178
+12
+239
+182
+13
+239
+182
+13
+242
+186
+14
+246
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+230
+174
+11
+210
+150
+10
+163
+110
+8
+104
+69
+6
+10
+10
+10
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+91
+60
+6
+167
+114
+7
+206
+145
+10
+230
+174
+11
+242
+186
+14
+246
+190
+14
+246
+190
+14
+246
+190
+14
+246
+186
+14
+242
+186
+14
+239
+182
+13
+230
+174
+11
+224
+166
+10
+213
+154
+11
+180
+133
+36
+124
+112
+88
+86
+86
+86
+58
+58
+58
+38
+38
+38
+22
+22
+22
+10
+10
+10
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+14
+14
+14
+34
+34
+34
+70
+70
+70
+138
+110
+50
+158
+118
+36
+167
+114
+7
+180
+123
+7
+192
+133
+9
+197
+138
+11
+200
+144
+11
+206
+145
+10
+213
+154
+11
+219
+162
+10
+224
+166
+10
+230
+174
+11
+239
+182
+13
+242
+186
+14
+246
+186
+14
+246
+186
+14
+246
+186
+14
+246
+186
+14
+239
+182
+13
+216
+158
+10
+185
+133
+11
+152
+99
+6
+104
+69
+6
+18
+14
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+2
+2
+6
+6
+6
+6
+80
+54
+7
+152
+99
+6
+192
+133
+9
+219
+162
+10
+236
+178
+12
+239
+182
+13
+246
+186
+14
+242
+186
+14
+239
+182
+13
+236
+178
+12
+224
+166
+10
+206
+145
+10
+192
+133
+9
+154
+121
+60
+94
+94
+94
+62
+62
+62
+42
+42
+42
+22
+22
+22
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+34
+34
+34
+58
+58
+58
+78
+78
+78
+101
+98
+89
+124
+112
+88
+142
+110
+46
+156
+107
+11
+163
+110
+8
+167
+114
+7
+175
+118
+6
+180
+123
+7
+185
+133
+11
+197
+138
+11
+210
+150
+10
+219
+162
+10
+226
+170
+11
+236
+178
+12
+236
+178
+12
+234
+174
+13
+219
+162
+10
+197
+138
+11
+163
+110
+8
+130
+83
+6
+91
+60
+6
+10
+10
+10
+2
+2
+6
+2
+2
+6
+18
+18
+18
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+38
+26
+26
+26
+2
+2
+6
+2
+2
+6
+6
+6
+6
+70
+47
+6
+137
+92
+6
+175
+118
+6
+200
+144
+11
+219
+162
+10
+230
+174
+11
+234
+174
+13
+230
+174
+11
+219
+162
+10
+210
+150
+10
+192
+133
+9
+163
+110
+8
+124
+112
+88
+82
+82
+82
+50
+50
+50
+30
+30
+30
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+22
+22
+22
+34
+34
+34
+42
+42
+42
+58
+58
+58
+74
+74
+74
+86
+86
+86
+101
+98
+89
+122
+102
+70
+130
+98
+46
+121
+87
+25
+137
+92
+6
+152
+99
+6
+163
+110
+8
+180
+123
+7
+185
+133
+11
+197
+138
+11
+206
+145
+10
+200
+144
+11
+180
+123
+7
+156
+107
+11
+130
+83
+6
+104
+69
+6
+50
+34
+6
+54
+54
+54
+110
+110
+110
+101
+98
+89
+86
+86
+86
+82
+82
+82
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+78
+82
+82
+82
+86
+86
+86
+94
+94
+94
+106
+106
+106
+101
+101
+101
+86
+66
+34
+124
+80
+6
+156
+107
+11
+180
+123
+7
+192
+133
+9
+200
+144
+11
+206
+145
+10
+200
+144
+11
+192
+133
+9
+175
+118
+6
+139
+102
+15
+109
+106
+95
+70
+70
+70
+42
+42
+42
+22
+22
+22
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+10
+10
+10
+14
+14
+14
+22
+22
+22
+30
+30
+30
+38
+38
+38
+50
+50
+50
+62
+62
+62
+74
+74
+74
+90
+90
+90
+101
+98
+89
+112
+100
+78
+121
+87
+25
+124
+80
+6
+137
+92
+6
+152
+99
+6
+152
+99
+6
+152
+99
+6
+138
+86
+6
+124
+80
+6
+98
+70
+6
+86
+66
+30
+101
+98
+89
+82
+82
+82
+58
+58
+58
+46
+46
+46
+38
+38
+38
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+34
+38
+38
+38
+42
+42
+42
+54
+54
+54
+82
+82
+82
+94
+86
+76
+91
+60
+6
+134
+86
+6
+156
+107
+11
+167
+114
+7
+175
+118
+6
+175
+118
+6
+167
+114
+7
+152
+99
+6
+121
+87
+25
+101
+98
+89
+62
+62
+62
+34
+34
+34
+18
+18
+18
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+6
+6
+6
+10
+10
+10
+18
+18
+18
+22
+22
+22
+30
+30
+30
+42
+42
+42
+50
+50
+50
+66
+66
+66
+86
+86
+86
+101
+98
+89
+106
+86
+58
+98
+70
+6
+104
+69
+6
+104
+69
+6
+104
+69
+6
+91
+60
+6
+82
+62
+34
+90
+90
+90
+62
+62
+62
+38
+38
+38
+22
+22
+22
+14
+14
+14
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+6
+6
+6
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+10
+14
+14
+14
+22
+22
+22
+42
+42
+42
+70
+70
+70
+89
+81
+66
+80
+54
+7
+104
+69
+6
+124
+80
+6
+137
+92
+6
+134
+86
+6
+116
+81
+8
+100
+82
+52
+86
+86
+86
+58
+58
+58
+30
+30
+30
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+10
+10
+10
+14
+14
+14
+18
+18
+18
+26
+26
+26
+38
+38
+38
+54
+54
+54
+70
+70
+70
+86
+86
+86
+94
+86
+76
+89
+81
+66
+89
+81
+66
+86
+86
+86
+74
+74
+74
+50
+50
+50
+30
+30
+30
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+18
+18
+18
+34
+34
+34
+58
+58
+58
+82
+82
+82
+89
+81
+66
+89
+81
+66
+89
+81
+66
+94
+86
+66
+94
+86
+76
+74
+74
+74
+50
+50
+50
+26
+26
+26
+14
+14
+14
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+6
+6
+6
+14
+14
+14
+18
+18
+18
+30
+30
+30
+38
+38
+38
+46
+46
+46
+54
+54
+54
+50
+50
+50
+42
+42
+42
+30
+30
+30
+18
+18
+18
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+26
+26
+26
+38
+38
+38
+50
+50
+50
+58
+58
+58
+58
+58
+58
+54
+54
+54
+42
+42
+42
+30
+30
+30
+18
+18
+18
+10
+10
+10
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+6
+6
+6
+10
+10
+10
+14
+14
+14
+18
+18
+18
+18
+18
+18
+14
+14
+14
+10
+10
+10
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+6
+6
+6
+14
+14
+14
+18
+18
+18
+22
+22
+22
+22
+22
+22
+18
+18
+18
+14
+14
+14
+10
+10
+10
+6
+6
+6
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
+0
