/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/


#define CTRL(X) (X & 0x1f)

/*
 * Curses Helper functions
 */

void	wblankrect(	WINDOW *win,
			int miny, int minx,
			int maxy, int maxx,
			int saveattr);

void	blankrect(
			int miny, int minx,
			int maxy, int maxx,
			int saveattr);

void	wvscrollrect(	WINDOW *win,
			int miny, int minx,
			int maxy, int maxx,
			int lines);

void	vscrollrect(
			int miny, int minx,
			int maxy, int maxx,
			int lines);

#define	SCROLL1UP	1
#define	SCROLL1DOWN	-1

void	whscrollrect(	WINDOW *win,
			int miny, int minx,
			int maxy, int maxx,
			int cols);

void	hscrollrect(
			int miny, int minx,
			int maxy, int maxx,
			int cols);

#define	SCROLL1LEFT	1
#define	SCROLL1RIGHT	-1

void	print_window(WINDOW *win, int numlines, char *printcmd);

void	wprint_rect_troff(WINDOW *win, int sy, int sx, int lines, int cols,
				char *spchar, char *filename);
void	print_rect_troff(int sy, int sx, int lines, int cols,
				char *spchar, char *filename);

void	mvwcenter(WINDOW *win, int y, char *str);
void	mvcenter(int y, char *str);
void	mvcenter80(int y, char *str);

void	wlinecursor(WINDOW *win, int y, int sx, int wid, int on, attr_t attr);
void	linecursor(int y, int sx, int wid, int on, attr_t attr);

static inline int
cols80(void)
{
	int	cols = COLS;

	if (cols > 80) cols = 80;
	return (cols);
}
