/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "error.h"

/*
 * Error routines
 */
static int	ErrorCount = 0;
static int	SysErrorCount = 0;
static char	ErrorTag[256];
static void	(*UserErrorExit)(void);

void
error_init(void (*exitfunc)(void), char *tagfmt, ...)
{
	va_list ap;

	UserErrorExit = exitfunc;
	ErrorCount = 0;
	SysErrorCount = 0;

	if (tagfmt)
	{
		va_start(ap, tagfmt);
		vsnprintf(ErrorTag, sizeof(ErrorTag) - 2, tagfmt, ap);
		va_end(ap);
		if (ErrorTag[0])
			strcat(ErrorTag, ": ");
	}

	setvbuf(stderr, (char *) NULL, _IOLBF, BUFSIZ);
}

void
error(int fatal, char *fmt, ...)
{
	va_list	ap;

	++ErrorCount;

	if (fatal && UserErrorExit)
		(*UserErrorExit)();

        fprintf(stderr, "%sERROR: ", ErrorTag);

        va_start(ap, fmt);
        vfprintf(stderr, fmt, ap);
        va_end(ap);

	if (fatal)
		exit(fatal & 255);
}

void
syserror(int fatal, char *fmt, ...)
{
	va_list	ap;
	int	err = errno;
	
	++SysErrorCount;

	if (fatal && UserErrorExit)
		(*UserErrorExit)();

        fprintf(stderr, "%sERROR: ", ErrorTag);

#ifdef  bsdi
	if (err > 0 && err <= sys_nerr)
		(void) fprintf(stderr, "%s: ", sys_errlist[err]);
#else
	(void) fprintf(stderr, "%s: ", strerror(err));
#endif

        va_start(ap, fmt);
        vfprintf(stderr, fmt, ap);
        va_end(ap);

	if (fatal)
		exit(fatal & 255);
}
