/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "curse.h"
#include "linuxtrade.h"
#include "help.h"
#include "config.h"

static char ProgVer[] = " " PACKAGE " " VERSION " by Rick Richardson ";

static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;

static int	Cursor;		// Help line number at top of display
static int	MaxCursor;	// Maximum value for above
static int	NumLines;	// Number of lines in the help display

static int	AutoDown;

#define	PADLINES	100

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1,
		Cursor ? ACS_UARROW : ACS_VLINE);

	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Cursor < MaxCursor) ? ACS_DARROW : ACS_VLINE);
}

void
help_main(void)
{
	int	x, y;
	int	cols;
	int	n;

	n = LINES - 4 - 2 - NumStock - 12;
	if (n < 24)
		n = 24;
	Win = bestwin(n);
	if (!Win)
		error(1, "Can't create help window\n");
	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	cols = getmaxx(Win);

	box(Win, 0, 0);
	mvwprintw(Win, 0, cols/2 - 3, " Help ");
	mvwprintw(Win, getmaxy(Win)-1, (cols - strlen(ProgVer))/2, ProgVer);

	// Subwin = derwin(Win, getmaxy(Win) - 2, cols - 2, 1, 1);
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create help pad\n");

	Panel = new_panel(Win);

	x = 1;
	y = -1;

	mvwprintw(Subwin, ++y, x, "STOCK COMMANDS..................");
	mvwprintw(Subwin, ++y, x, "a    Add Symbol(s)");
	mvwprintw(Subwin, ++y, x, "d    Delete Symbol(s)");
	mvwprintw(Subwin, ++y, x, "j/k  Move cursor down/up");
	mvwprintw(Subwin, ++y, x, "0-9  Display stocklist #");
	mvwprintw(Subwin, ++y, x, "s#   Save current list to list #");
	mvwprintw(Subwin, ++y, x, "S#   Save current symbol to list#");
	mvwprintw(Subwin, ++y, x, "A    Set alerts for stock");
	mvwprintw(Subwin, ++y, x, "^A   Clear alert, ^A^A clears all");
	mvwprintw(Subwin, ++y, x, "H    Show/don't show holdings");
	mvwprintw(Subwin, ++y, x, "*    ... by total or share cost");
	mvwprintw(Subwin, ++y, x, "#    Enter holdings (shares,cost)");
	++y;
	mvwprintw(Subwin, ++y, x, "MARKET COMMANDS.................");
	mvwprintw(Subwin, ++y, x, "E/N/Q Show AMEX/NYSE/NASD top 10");
	mvwprintw(Subwin, ++y, x, "$/%%  ... by net/percent change");
	mvwprintw(Subwin, ++y, x, "m    Show Market Movers");
	mvwprintw(Subwin, ++y, x, "t/T  Toggle Time & Sales windows");
	mvwprintw(Subwin, ++y, x, "^B   Start broker browser");
	mvwprintw(Subwin, ++y, x, "^L   Refresh screen");
	mvwprintw(Subwin, ++y, x, ":?   Help for : extended commands");
	NumLines = max(NumLines, getcury(Subwin) + 1);

	y = -1; x = cols/2 -1;
	mvwprintw(Subwin, ++y, x, "INFO COMMANDS...................");
	mvwprintw(Subwin, ++y, x, "c/C  Popup Stock Chart/LiveChart");
	mvwprintw(Subwin, ++y, x, "e    Popup Earnings Calendar");
	mvwprintw(Subwin, ++y, x, "g/G  Browse all charts in this list");
	mvwprintw(Subwin, ++y, x, "i    Popup Fundamental Info");
	mvwprintw(Subwin, ++y, x, "I    Popup Technical Info");
	mvwprintw(Subwin, ++y, x, "n    Popup News");
	mvwprintw(Subwin, ++y, x, "p/u  Popup InPlay/Upgrades list");
	mvwprintw(Subwin, ++y, x, "b/B  Popup Archipelago/Island L2 Book");
	mvwprintw(Subwin, ++y, x, "l/L  Popup L2 Book");
	mvwprintw(Subwin, ++y, x, "o/O  Popup/Browse Option Chains");
	mvwprintw(Subwin, ++y, x, "M    Popup NASDAQ 100 heatmap");

	++y;
	mvwprintw(Subwin, ++y, x, "MISC COMMANDS...................");
	mvwprintw(Subwin, ++y, x, "P    Change password/preferences");
	// mvwprintw(Subwin, ++y, x, "R/U  Register/Upgrade this software");
	mvwprintw(Subwin, ++y, x, "U    Upgrade this software");
	mvwprintw(Subwin, ++y, x, "^N/^P Switch to next/prev streamer");
	mvwprintw(Subwin, ++y, x, "^R   Restart current streamer");
	mvwprintw(Subwin, ++y, x, "W    Record session to file");
	mvwprintw(Subwin, ++y, x, "q    Quit/Quit popup");
	mvwprintw(Subwin, ++y, x, "F12  Print");
	NumLines = max(NumLines, getcury(Subwin) + 1);
}

void
help_colon(void)
{
	int	x, y;
	int	cols;
	int	n;

	n = LINES - 4 - 2 - NumStock - 12;
	if (n < 24)
		n = 24;
	Win = bestwin(n);
	if (!Win)
		error(1, "Can't create help window\n");
	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	cols = getmaxx(Win);

	box(Win, 0, 0);
	mvwcenter(Win, 0, " Extended Commands Help ");
	mvwprintw(Win, getmaxy(Win)-1, (cols - strlen(ProgVer))/2, ProgVer);

	// Subwin = derwin(Win, getmaxy(Win) - 2, cols - 2, 1, 1);
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create help subwindow\n");

	Panel = new_panel(Win);

	x = 1;
	y = -1;

	mvwprintw(Subwin, ++y, x, ":sort n|N|p|P|c|C|v|V|g|G");
	mvwprintw(Subwin, ++y, x, ":<number>");
	mvwprintw(Subwin, ++y, x, ":list <string>");
	mvwprintw(Subwin, ++y, x, ":save [<number>]");
	mvwprintw(Subwin, ++y, x, ":label <string>");
	mvwprintw(Subwin, ++y, x, ":comment <string>");
	mvwprintw(Subwin, ++y, x, ":heatmap [etf|pmi|100]");
	mvwprintw(Subwin, ++y, x, ":heatmap [market|heat|sector]");
	mvwprintw(Subwin, ++y, x, ":carpet [sector|market|index]");
	mvwprintw(Subwin, ++y, x, ":carpet [fidelity|rydex|toronto]");
	mvwprintw(Subwin, ++y, x, ":lc [<symbol>|all]");
	mvwprintw(Subwin, ++y, x, ":mn [<symbol>|all]");
	mvwprintw(Subwin, ++y, x, ":pf [<symbol>|all]");
	mvwprintw(Subwin, ++y, x, ":earnings [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":news/mnews/snews  [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":onews");
	mvwprintw(Subwin, ++y, x, ":halts");
	mvwprintw(Subwin, ++y, x, ":pre / :after [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":wc [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":name [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":pe [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":pivot [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":players [@][<symbol>]");
	mvwprintw(Subwin, ++y, x, ":range [<symbol>] [<days>]");
	mvwprintw(Subwin, ++y, x, ":shortint [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":ts [<symbol>] [0|1]");
	mvwprintw(Subwin, ++y, x, ":whisper [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":arca [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":island [<symbol>]");
	mvwprintw(Subwin, ++y, x, ":econ");
	mvwprintw(Subwin, ++y, x, ":ipo");
	mvwprintw(Subwin, ++y, x, ":lookup <string>");
	mvwprintw(Subwin, ++y, x, ":mmid <string>");
	mvwprintw(Subwin, ++y, x, ":qp");
	mvwprintw(Subwin, ++y, x, ":splits");
	mvwprintw(Subwin, ++y, x, ":indexes");
	mvwprintw(Subwin, ++y, x, ":majors / :dow");
	mvwprintw(Subwin, ++y, x, ":spiders");
	mvwprintw(Subwin, ++y, x, ":wide / :Wide");
	mvwprintw(Subwin, ++y, x, ":weekly / :Weekly");
	mvwprintw(Subwin, ++y, x, ":ibdvol");
	mvwprintw(Subwin, ++y, x, ":bwkvol");
	mvwprintw(Subwin, ++y, x, ":frb");
	mvwprintw(Subwin, ++y, x, ":!<cmd>");
	mvwprintw(Subwin, ++y, x, ":clrcom");
	mvwprintw(Subwin, ++y, x, ":clralerts");
	mvwprintw(Subwin, ++y, x, ":clrhold");
	mvwprintw(Subwin, ++y, x, ":total");
	mvwprintw(Subwin, ++y, x, ":streamer <type>");
	mvwprintw(Subwin, ++y, x, ":manualpage");
	mvwprintw(Subwin, ++y, x, ":homepage");
	mvwprintw(Subwin, ++y, x, ":grouppage");

	++y;
	mvwprintw(Subwin, ++y, x,
			"All commands and arguments may be abbreviated");
	NumLines = max(NumLines, getcury(Subwin) + 1);

	y = -1; x = cols/2 -1;
	mvwprintw(Subwin, ++y, x, "Sort stocks by name/price/chg/vol/gain");
	mvwprintw(Subwin, ++y, x, "Switch to stocklist <number> (1-99)");
	mvwprintw(Subwin, ++y, x, "Switch to stocklist name <string>");
	mvwprintw(Subwin, ++y, x, "Save the current stocklist as <number>");
	mvwprintw(Subwin, ++y, x, "Label the current stocklist");
	mvwprintw(Subwin, ++y, x, "Add comment to current stock");
	mvwprintw(Subwin, ++y, x, "NASDAQ Heatmaps: ETF, Premarket, 100");
	mvwprintw(Subwin, ++y, x, "Money.net heatmaps");
	mvwprintw(Subwin, ++y, x, "Stockcharts.com carpets");
	mvwprintw(Subwin, ++y, x, "more Stockcharts.com carpets");
	mvwprintw(Subwin, ++y, x, "Lycos.com LiveChart Applet");
	mvwprintw(Subwin, ++y, x, "Money.net ChartStream Applet");
	mvwprintw(Subwin, ++y, x, "ProphetFinance.com ChartStream Applet");
	mvwprintw(Subwin, ++y, x, "Display full earnings info for <symbol>");
	mvwprintw(Subwin, ++y, x, "Display news for <symbol>");
	mvwprintw(Subwin, ++y, x, "Popup old (saved) news window");
	mvwprintw(Subwin, ++y, x, "Display NASDAQ trading halts");
	mvwprintw(Subwin, ++y, x, "Pre/after-mkt trades for <symbol>");
	mvwprintw(Subwin, ++y, x, "Display web chart for <symbol>");
	mvwprintw(Subwin, ++y, x, "Full name for <symbol>");
	mvwprintw(Subwin, ++y, x, "P/E ratios for <symbol>");
	mvwprintw(Subwin, ++y, x, "Pivots for <symbol>");
	mvwprintw(Subwin, ++y, x, "Players/Components for <symbol>");
	mvwprintw(Subwin, ++y, x, "Daily range for <symbol> <days>");
	mvwprintw(Subwin, ++y, x, "Short interest for <symbol>");
	mvwprintw(Subwin, ++y, x, "T&S for <symbol>");
	mvwprintw(Subwin, ++y, x, "Earnings whisper #'s for <symbol>");
	mvwprintw(Subwin, ++y, x, "Display ARCA book for <symbol>");
	mvwprintw(Subwin, ++y, x, "Display Island book for <symbol>");
	mvwprintw(Subwin, ++y, x, "Briefing.com economic calendar");
	mvwprintw(Subwin, ++y, x, "Alert!IPO upcoming calendar");
	mvwprintw(Subwin, ++y, x, "Lookup symbol for <string>");
	mvwprintw(Subwin, ++y, x, "Lookup full MM name for <string>");
	mvwprintw(Subwin, ++y, x, "ipo.com quiet period calendar");
	mvwprintw(Subwin, ++y, x, "Briefing.com splits calendar");
	mvwprintw(Subwin, ++y, x, "Display all canonical index syms");
	mvwprintw(Subwin, ++y, x, "Display major industries / dow stocks");
	mvwprintw(Subwin, ++y, x, "Display S&P select SPDRS");
	mvwprintw(Subwin, ++y, x, "Same as 'g'/'G' but wider charts");
	mvwprintw(Subwin, ++y, x, "Weekly charts, narrow/wide");
	mvwprintw(Subwin, ++y, x, "Get IBD unusual volume list");
	mvwprintw(Subwin, ++y, x, "Get BWK unusual volume list");
	mvwprintw(Subwin, ++y, x, "Display Fed Reserve Bank $$$ input");
	mvwprintw(Subwin, ++y, x, "Fill stocklist 0 by running <cmd>");
	mvwprintw(Subwin, ++y, x, "Clear all comments in this list");
	mvwprintw(Subwin, ++y, x, "Clear all alerts in this list");
	mvwprintw(Subwin, ++y, x, "Clear all holdings in this list");
	mvwprintw(Subwin, ++y, x, "Display total holdings value");
	mvwprintw(Subwin, ++y, x, "Switch to streamer <type>");
	mvwprintw(Subwin, ++y, x, "Display full manual page");
	mvwprintw(Subwin, ++y, x, "Browse linuxtrade home page");
	mvwprintw(Subwin, ++y, x, "Browse linuxtrade group page");
	NumLines = max(NumLines, getcury(Subwin) + 1);
}

void
help_chart(void)
{
	int	x, y;
	int	cols;

	Win = newwin(11, cols80(), LINES/4 - 1, 0);
	if (!Win)
		error(1, "Can't create help window\n");
	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	cols = getmaxx(Win);

	box(Win, 0, 0);
	mvwprintw(Win, 0, cols/2 - 6, " Chart Help ");

	// Subwin = derwin(Win, getmaxy(Win) - 2, getmaxx(Win) - 2, 1, 1);
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create help subwindow\n");

	Panel = new_panel(Win);

	x = 1;
	y = 0;

	mvwprintw(Subwin, ++y, x, "CHART COMMANDS..................");
	mvwprintw(Subwin, ++y, x, "1    1 Minute Chart");
	mvwprintw(Subwin, ++y, x, "2    5 Minute Chart");
	mvwprintw(Subwin, ++y, x, "3    10 Minute Chart");
	mvwprintw(Subwin, ++y, x, "4    Hourly Chart");
	mvwprintw(Subwin, ++y, x, "5    Daily Chart");
	mvwprintw(Subwin, ++y, x, "6    Weekly Chart");
	NumLines = max(NumLines, getcury(Subwin) + 1);

	y = 0; x = cols/2 -1;
	mvwprintw(Subwin, ++y, x, "+    Increase chart duration");
	mvwprintw(Subwin, ++y, x, "-    Decrease chart duration");
	mvwprintw(Subwin, ++y, x, "<--  Scroll left");
	mvwprintw(Subwin, ++y, x, "-->  Scroll right");
	mvwprintw(Subwin, ++y, x, "HOME Scroll to beginning");
	mvwprintw(Subwin, ++y, x, "END  Scroll to end");
	mvwprintw(Subwin, ++y, x, "^L   Refresh screen");
	mvwprintw(Subwin, ++y, x, "p    Display pivot points");
	NumLines = max(NumLines, getcury(Subwin) + 1);
}

void
help_options(void)
{
	int	x, y;
	int	cols;

	Win = newwin(8, cols80(), LINES/4 - 1, 0);
	if (!Win)
		error(1, "Can't create help window\n");
	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	cols = getmaxx(Win);

	box(Win, 0, 0);
	mvwprintw(Win, 0, cols/2 - 6, " Options Help ");

	// Subwin = derwin(Win, getmaxy(Win) - 2, getmaxx(Win) - 2, 1, 1);
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create help subwindow\n");

	Panel = new_panel(Win);

	x = 1;
	y = 0;

	mvwprintw(Subwin, ++y, x, "OPTIONS COMMANDS..................");
	mvwprintw(Subwin, ++y, x, "A    Display AMEX quotes");
	mvwprintw(Subwin, ++y, x, "E    Display CBOE quotes");
	mvwprintw(Subwin, ++y, x, "X    Display Philly quotes");
	NumLines = max(NumLines, getcury(Subwin) + 1);

	y = 0; x = cols/2 -1;
	mvwprintw(Subwin, ++y, x, "P    Display Pacific quotes");
	mvwprintw(Subwin, ++y, x, "8    Display ? quotes");
	mvwprintw(Subwin, ++y, x, "*    Display all quotes");
	NumLines = max(NumLines, getcury(Subwin) + 1);
}

void
help_popup(char	*which)
{
	NumLines = 0;
	AutoDown = 0;

	switch (which[0])
	{
	default:	help_main(); break;
	case 'c':	help_chart(); AutoDown = 1; break;
	case 'o':	help_options(); AutoDown = 1; break;
	case ':':	help_colon(); break;
	}

	Cursor = 0;
	MaxCursor = NumLines - (getmaxy(Win) - 2);
	if (MaxCursor < 0) MaxCursor = 0;

	display_more();
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
}

static void
popdown(void)
{
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = NULL;
	Subwin = NULL;
}

int
help_command(int c, STREAMER sr)
{
	MEVENT	m;

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return -1;
	case 'j':
	case KEY_DOWN:
		if (++Cursor > MaxCursor)
		{
			--Cursor;
			if (!AutoDown)
				beep();
			break;
		}
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			if (!AutoDown)
				beep();
			break;
		}
		break;
	case '-':
	case KEY_PPAGE:
		if (Cursor == 0)
		{
			if (!AutoDown)
				beep();
			break;
		}
		Cursor -= getmaxy(Win) - 2 - 1;
		if (Cursor < 0)
			Cursor = 0;
		break;
	case '+':
	case ' ':
	case KEY_NPAGE:
		if (Cursor == MaxCursor)
		{
			if (!AutoDown)
				beep();
			break;
		}
		Cursor += getmaxy(Win) - 2 - 1;
		if (Cursor > MaxCursor)
			Cursor = MaxCursor;
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		break;
	case '$':
	case KEY_END:
		Cursor = MaxCursor;
		break;
	case KEY_F(11):
		if (1) print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				"#", "screen.tr");
		break;
	case KEY_F(12):
	case CTRL('P'):
	case KEY_PRINT:
		print_window(Subwin, NumLines,
				get_rc_value(RcFile, "print_cmd"));
		break;
	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;
	default:
		popdown();
		return 1;
	}

	if (AutoDown)
	{
		popdown();
		return (1);
	}

	display_more();
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();

	return (-1);
}
