/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ncurses.h>
#include <panel.h>
#include <time.h>
#include <sys/time.h>
#include "curse.h"
#include "error.h"
#include "debug.h"
#include "rc.h"
#include "streamer.h"
#include "linuxtrade.h"
#include "pref.h"
#include "srpref.h"
#include "p2open.h"
#include "help.h"

//
// Prefs popup - incomplete
//


static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;
static RCFILE	*Rcp;
static char	*Filename;

static int	Cursor;
static int	Top;
static int	NumPrefs;

static char	Choice[16][64];
static int	NumChoice = 0;
static int	CurChoice = 0;
static int	ShowPassword = 0;

static void
display_pref_line(RCFILE *rcp, int y, int hilite)
{
	char	*str;
	char	stars[256];

	if (!rcp || !rcp->name || !rcp->value)
	{
		mvwprintw(Subwin, y, 0, "%-16.16s  %-*.*s",
			"",
			getmaxx(Subwin) - 16 - 2,
			getmaxx(Subwin) - 16 - 2,
			"");
		return;
	}

	if (hilite)
		wattrset(Subwin, A_REVERSE);

	if (rcp->type == RC_PASS && !ShowPassword)
	{
		memset(stars, '*', strlen(rcp->value));
		stars[strlen(rcp->value)] = 0;
		str = stars;
	}
	else
		str = rcp->value;

	mvwprintw(Subwin, y, 0, "%-16.16s  %-*.*s",
		rcp->name,
		getmaxx(Subwin) - 16 - 2,
		getmaxx(Subwin) - 16 - 2,
		str);
	wattrset(Subwin, A_NORMAL);
}

static void
repaint_pref_lines(RCFILE *rcp)
{
	int	y;

	for (y = 0; y < getmaxy(Subwin); ++y)
	{
		display_pref_line(rcp, y, FALSE);
		if (rcp->name)
			++rcp;
	}
}

static void
display_comment(RCFILE *rcp)
{
	mvprintw(LINES-2, 0, "%-*.*s", COLS, COLS, Rcp[Cursor].comment);
}

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1, Top ? ACS_UARROW : ACS_VLINE);
	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Top+getmaxy(Subwin)) < NumPrefs ? ACS_DARROW : ACS_VLINE);
}

void
pref_popup(RCFILE *rcp, char *filename)
{
	int	y;
	int	cols;

	// Count entries
	for (y = 0; rcp[y].name; ++y)
		{}

	y += 2;		// Account for 2 lines of help
	y += 2;		// Account for box

	if (y > (LINES-2)) y = (LINES-2);
	Win = newwin(y, cols80(), LINES - 2 - y, 0);
	// Win = bestwin(y);
	if (!Win)
		error(1, "Can't create pref window\n");

	cols = getmaxx(Win);

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);
	mvwprintw(Win, 0, cols/2 - 6, " Preferences ");

	Subwin = derwin(Win, getmaxy(Win) - 2 - 2, cols - 2, 1, 1);
	if (!Subwin)
		error(1, "Can't create pref subwindow\n");

	Panel = new_panel(Win);

	Rcp = rcp;
	Filename = filename;

	y = 0;
	NumPrefs = 0;
	while (rcp->name)
	{
		if (rcp->value == NULL)
		{
			rcp->value = strdup(rcp->defvalue);
			if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
			{
				char	*p = strchr(rcp->value, '|');
				if (p) *p = 0;
			}
		}

		if (y < getmaxy(Subwin))
		{
			display_pref_line(rcp, y, y == 0);
			++y;
		}
		++rcp;
		++NumPrefs;
	}

	mvwprintw(Win, getmaxy(Win)-2, 2,
		"c=Change  f=Reset to Factory  F=Reset All  s=Save  q=Quit"
		"  ^p=ShowPass"
		);

	blankrect(LINES-2, 0, LINES-1, COLS-1, 0);
	Cursor = 0;
	Top = 0;

	display_comment(&Rcp[Cursor]);
	display_more();
	touchwin(Win);
}

static void
get_encpasswd(char *site, char *usertag, char *passtag, int cursor)
{
	FILE	*fp[2];
	char	buf[BUFSIZ];
	char	*p;
	int	rc;
	char	*cmd = PROGNAMESTR ".auth ";

	attrset(A_BOLD);
	mvprintw(LINES-1, 0,
		"*** Please Wait - getting hashed password from website");
	attrset(A_NORMAL);
	update_panels(); refresh(); // doupdate();

	sprintf(buf, "%s %s", cmd, site);
	rc = p2open("/bin/sh", buf, fp);
	if (rc < 0)
	{
		set_rc_value(Rcp, Rcp[cursor].name, "cannot determine");
		display_pref_line(&Rcp[cursor], cursor, FALSE);
		return;
	}

	fprintf(fp[1], "%s\n", get_rc_value(Rcp, usertag));
	fprintf(fp[1], "%s\n", get_rc_value(Rcp, passtag));
	fflush(fp[1]);

	strcpy(buf, "couldn't run " PROGNAMESTR ".auth");
	fgets(buf, sizeof(buf), fp[0]);

	rc = p2close(fp);
	if (rc < 0)
	{
		set_rc_value(Rcp, Rcp[cursor].name, "cannot determine2");
		display_pref_line(&Rcp[cursor], cursor, FALSE);
		return;
	}

	p = strchr(buf, '\n');
	if (p) *p = 0;
	set_rc_value(Rcp, Rcp[cursor].name, buf);
	display_pref_line(&Rcp[cursor], cursor, FALSE);

	blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
}

static char	ChBuf[256];
static char	*ChPtr;
static int	PromptEndX;

static int
valid(RCFILE *rcp, char *str)
{
	if (rcp->type == RC_NUM)
	{
		int val = atoi(str);

		if (val < rcp->min || val > rcp->max)
			return 0;
	}
	else
	{
		int	len = strlen(str);

		if (len < rcp->min || len > rcp->max)
			return 0;
	}
	return 1;
}

static void
show_change(RCFILE *rcp)
{
	char	*str;
	char	stars[256];

	move(LINES-1, PromptEndX);
	if (rcp->type == RC_PASS && !ShowPassword)
	{
		memset(stars, '*', strlen(ChBuf));
		stars[strlen(ChBuf)] = 0;
		str = stars;
	}
	else
		str = ChBuf;
	debug(1, "show_change: CursorX=%d, str=<%s>\n", PromptEndX, str);
	printw("%-*.*s", COLS - PromptEndX - 1, COLS - PromptEndX - 1, str);
	CursorX = PromptEndX + (ChPtr - ChBuf);
}

static void
make_choice_list(RCFILE *rcp)
{
	char	*b, *e;

	NumChoice = 0;
	CurChoice = 0;
	for (b = e = Rcp[Cursor].defvalue; *e; b = e + 1)
	{
		e = strchr(b, '|');
		if (!e) e = strchr(b, 0);
		memcpy(Choice[NumChoice], b, e - b);
		Choice[NumChoice][e-b] = 0;
		if (strcmp(Choice[NumChoice], rcp->value) == 0)
			CurChoice = NumChoice;
		++NumChoice;
	}
	if (rcp->type == RC_COMBO)
	{
		strcpy(Choice[NumChoice], rcp->value);
		CurChoice = NumChoice;
		++NumChoice;
	}
}

static int NewChange;

static void
start_change(RCFILE *rcp)
{
	strcpy(ChPtr = ChBuf, rcp->value);
	NumChoice = 0;
	CurChoice = 0;

	switch (rcp->type)
	{
	case RC_NUM:
		mvprintw(LINES-1, 0, "Number (%d-%d): ", rcp->min, rcp->max);
		break;
	case RC_LIST:
		make_choice_list(rcp);
		mvprintw(LINES-1, 0, "Choice (use arrow keys): ");
		break;
	case RC_COMBO:
		make_choice_list(rcp);
		mvprintw(LINES-1, 0, "Combo (up/down/edit)): ");
		break;
	case RC_PASS:
		mvprintw(LINES-1, 0, "Password: ");
		break;
	default:
		mvprintw(LINES-1, 0, "String: ");
		break;
	}
	PromptEndX = CursorX = getcurx(stdscr);
	show_change(rcp);
	NewChange = 1;
}

static int
do_change(int c, STREAMER sr)
{
	int	y;

	switch (c)
	{
	case 033:
	abort:
		display_comment(&Rcp[Cursor]);
		blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
		CursorX = 0;
		return 1;
	case '\r':
	save:
		if (!valid(&Rcp[Cursor], ChBuf))
		{
			beep();
			return 0;
		}
		set_rc_value(Rcp, Rcp[Cursor].name, ChBuf);
		display_pref_line(&Rcp[Cursor], Cursor, 1);
		display_comment(&Rcp[Cursor]);
		blankrect(LINES-1, 0, LINES-1, COLS-1, 0);
		CursorX = 0;
		if (strcmp(Rcp[Cursor].name, "lc_pass") == 0
			&& Rcp[Cursor+1].name
			&& strcmp(Rcp[Cursor+1].name, "lc_encpass") == 0)
			get_encpasswd("livecharts.com",
					"lc_user", "lc_pass", Cursor+1);
		if (strcmp(Rcp[Cursor].name, "lc_user") == 0
			&& Rcp[Cursor+2].name
			&& strcmp(Rcp[Cursor+2].name, "lc_encpass") == 0)
			get_encpasswd("livecharts.com",
					"lc_user", "lc_pass", Cursor+2);
		touchwin(Win);
		return 1;
	case CTRL('U'):
	case KEY_SDC:
		if (Rcp[Cursor].type == RC_LIST)
			beep();
		else
			strcpy(ChPtr = ChBuf, "");
		break;
	case 0x7f:
	case KEY_DC:
		if (Rcp[Cursor].type == RC_LIST)
			beep();
		else if (*ChPtr)
			memmove(ChPtr, ChPtr+1, strlen(ChPtr+1)+1);
		else
			beep();
		break;
	case KEY_DOWN:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
			goto next_choice;
		beep();
		break;
	case KEY_UP:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
			goto prev_choice;
		beep();
		break;
	case KEY_LEFT:
		if (Rcp[Cursor].type == RC_LIST)
		{
		prev_choice:
			--CurChoice;
			if (CurChoice < 0)
				CurChoice = NumChoice - 1;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
		{
			if (ChPtr > ChBuf)
				--ChPtr;
			else
				beep();
		}
		break;
	case KEY_RIGHT:
		if (Rcp[Cursor].type == RC_LIST)
		{
		next_choice:
			++CurChoice;
			if (CurChoice >= NumChoice)
				CurChoice = 0;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
		{
			if (*ChPtr)
				++ChPtr;
			else
				beep();
		}
		break;
	case KEY_END:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
		{
			CurChoice = NumChoice - 1;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
			ChPtr = strchr(ChBuf, 0);
		break;
	case KEY_HOME:
		if (Rcp[Cursor].type == RC_LIST || Rcp[Cursor].type == RC_COMBO)
		{
			CurChoice = 0;
			strcpy(ChPtr = ChBuf, Choice[CurChoice]);
		}
		else
			ChPtr = ChBuf;
		break;
	case '\b':
		if (Rcp[Cursor].type == RC_LIST)
			goto prev_choice;
		else if (ChPtr > ChBuf)
		{
			--ChPtr;
			memmove(ChPtr, ChPtr+1, strlen(ChPtr+1)+1);
		}
		else
			beep();
		break;
	case CTRL('p'):
		ShowPassword = !ShowPassword;
		for (y = 0; y < getmaxy(Subwin); ++y)
			display_pref_line(&Rcp[Top+y], y, 0);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		touchwin(Win);
		goto justshow;
	default:
		if (Rcp[Cursor].type == RC_LIST)
		{
			if (c == ' ')
				goto next_choice;
			if (c == 'q')
				goto abort;
			if (c == 's')
				goto save;
			beep();
			break;
		}
		if (Rcp[Cursor].type == RC_NUM && (c < '0' || c > '9') )
		{
			beep();
			break;
		}
		if (c >= ' ' && c < 127)
		{
			if (NewChange)
				strcpy(ChPtr = ChBuf, "");
			memmove(ChPtr+1, ChPtr, strlen(ChPtr)+1);
			*ChPtr++ = c;
		}
		else
			beep();
		break;
	}

	NewChange = 0;
justshow:
	show_change(&Rcp[Cursor]);
	return 0;
}

static void
popdown(void)
{
	blankrect(LINES-2, 0, LINES-1, COLS-1, 0);
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = NULL;
}

int
pref_command(int c, STREAMER sr)
{
	static int	(*handler)(int c, STREAMER sr);
	int		y;
	int		rc;
	RCFILE		*rcp;
	MEVENT		m;

	if (handler)
	{
		rc = (*handler)(c, sr);
		if (rc > 0)
		{
			if (handler == srpref_command)
			{
				display_pref_line(Rcp, 0, TRUE);
				touchwin(Win);
			}
			handler = NULL;
			rc = 0;
		}
		else if (rc == 0)
		{
			touchwin(Win);
			move(LINES-1, CursorX);
			update_panels(); refresh(); // doupdate();
			//wrefresh(curscr);	// Hack for panel refresh prob
		}
		return rc;
	}

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return 0;
	case '?':
		handler = help_command;
		help_popup("pref");
		break;
	case '\r':
	case 'c':
		if (Cursor == 0)
		{
			display_pref_line(&Rcp[Cursor], 0, FALSE);
			touchwin(Win);
			handler = srpref_command;
			srpref_popup();
		}
		else
		{
			start_change(&Rcp[Cursor]);
			handler = do_change;
		}
		break;
	case 'f':
		rcp = &Rcp[Cursor];
		if (rcp->value)
			free(rcp->value);
		rcp->value = strdup(rcp->defvalue);
		if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
		{
			char	*p = strchr(rcp->value, '|');
			if (p) *p = 0;
		}
		display_pref_line(rcp, Cursor, 1);
		touchwin(Win);
		break;
	case 'F':
		for (y = 0, rcp = Rcp; rcp->name; ++rcp, ++y)
		{
			if (rcp->value)
				free(rcp->value);
			rcp->value = strdup(rcp->defvalue);
			if (rcp->type == RC_LIST || rcp->type == RC_COMBO)
			{
				char	*p = strchr(rcp->value, '|');
				if (p) *p = 0;
			}
			display_pref_line(rcp, y, y == Cursor);
		}
		touchwin(Win);
		break;
	case 'j':
	case KEY_DOWN:
		if (++Cursor == NumPrefs)
		{
			--Cursor;
			beep();
			break;
		}
		if (Cursor >= Top+getmaxy(Subwin))
		{
			++Top;
			repaint_pref_lines(Rcp + Top);
		}
		else
			display_pref_line(&Rcp[Cursor-1], Cursor-Top-1, 0);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			beep();
			break;
		}
		if (Cursor < Top)
		{
			--Top;
			repaint_pref_lines(Rcp + Top);
		}
		else
			display_pref_line(&Rcp[Cursor+1], Cursor-Top+1, 0);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		Top = 0;
		repaint_pref_lines(Rcp + Top);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case 'G':
	case KEY_END:
		Cursor = NumPrefs - 1;
		Top = Cursor - getmaxy(Subwin) + 1;
		if (Top < 0)
			Top = 0;
		repaint_pref_lines(Rcp + Top);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		display_comment(&Rcp[Cursor]);
		display_more();
		touchwin(Win);
		break;
	case 'l':
	case KEY_RIGHT:
		if (Cursor == 0)
		{
			// Must explicitly change the streamer with 'c'
			beep();
		}
		else if (Rcp[Cursor].type == RC_LIST)
		{
			make_choice_list(&Rcp[Cursor]);
			++CurChoice;
			if (CurChoice >= NumChoice)
				CurChoice = 0;
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name,
				Choice[CurChoice]);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else if (Rcp[Cursor].type == RC_NUM)
		{
			int	val = atoi(Rcp[Cursor].value);
			char	numbuf[64];

			if (++val > Rcp[Cursor].max)
				val = Rcp[Cursor].min;
			sprintf(numbuf, "%d", val);
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name, numbuf);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else
		{
			start_change(&Rcp[Cursor]);
			handler = do_change;
		}
		touchwin(Win);
		break;
	case 'h':
	case KEY_LEFT:
		if (Cursor == 0)
		{
			// Must explicitly change the streamer with 'c'
			beep();
		}
		else if (Rcp[Cursor].type == RC_LIST)
		{
			make_choice_list(&Rcp[Cursor]);
			--CurChoice;
			if (CurChoice < 0)
				CurChoice = NumChoice - 1;
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name,
					Choice[CurChoice]);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else if (Rcp[Cursor].type == RC_NUM)
		{
			int	val = atoi(Rcp[Cursor].value);
			char	numbuf[64];

			if (--val < Rcp[Cursor].min)
				val = Rcp[Cursor].max;
			sprintf(numbuf, "%d", val);
			set_rc_value(&Rcp[Cursor], Rcp[Cursor].name, numbuf);
			display_pref_line(&Rcp[Cursor], Cursor-Top, TRUE);
		}
		else
		{
			start_change(&Rcp[Cursor]);
			handler = do_change;
		}
		touchwin(Win);
		break;

	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		// TODO: position on clicked line
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

	case KEY_F(11):
		print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;

	case CTRL('p'):
		ShowPassword = !ShowPassword;
		repaint_pref_lines(Rcp + Top);
		display_pref_line(&Rcp[Cursor], Cursor-Top, 1);
		touchwin(Win);
		break;

	case 's':
		save_rc_file(Rcp, Filename);
		popdown();
		return 2;

	case 033:
	case 'q':
		popdown();
		return 2;

	default:
		beep();
		return 0;
	}
	return 0;
}
