/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <ctype.h>
#include <pthread.h>
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "curse.h"
#include "linuxtrade.h"
#include "minihtml.h"
#include "quiet.h"

/*
 * This is very hacked, do not use as a prototype.  Try splits.c instead.
 */
static WINDOW	*Win;
static WINDOW	*Subwin;
static PANEL	*Panel;

static int	Cursor;		// Article line number at top of display
static int	MaxCursor;	// Maximum value for above
static int	NumLines;	// Number of lines in the article
static time_t	LastLivePoll;	// Last time we grabbed the live quotes
static STREAMER	Sr = NULL;
static int	ValLivePoll;

#define	PADLINES	700

typedef struct
{
	char	sym[SYMLEN+1];
	int	x;
} QUOTELOC;

static QUOTELOC	Live[PADLINES];

static void
get_live_quotes(void)
{
	int	y;
	int	cnt = 0;

	for (y = Cursor; y < Cursor+getmaxy(Win)-2; ++y)
		if (Live[y].sym[0])
		{
			(Sr->send_livequote)(Sr, Live[y].sym);
			++cnt;
		}
	if (cnt)
		(Sr->send_livequote_end)(Sr);

	time(&LastLivePoll);
}

void
quiet_livequote(LIVEQUOTE *lq)
{
	int	y;

	if (!Win)
		return;

	for (y = Cursor; y < Cursor+getmaxy(Win)-2; ++y)
	{
		attr_t	attr;

		if (strcmp(lq->sym, Live[y].sym))
			continue;

		if (lq->last > lq->close)
			attr = COLOR_PAIR(1) | A_NORMAL;
		else if (lq->last < lq->close)
			attr = COLOR_PAIR(2) | A_NORMAL;
		else
			attr = A_NORMAL;

		wattrset(Subwin, attr);
		mvwprintw(Subwin, y, Live[y].x,
			"%7.2f %+7.2f", lq->last, lq->last - lq->close);
		wattrset(Subwin, A_NORMAL);
	}

	// TODO: optimize this to do 1 line and move into loop
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
}

//
// TODO: make this asynchronous
//

static void
display_more(void)
{
	mvwaddch(Win, 1, getmaxx(Win)-1,
		Cursor ? ACS_UARROW : ACS_VLINE);

	mvwaddch(Win, getmaxy(Win)-2, getmaxx(Win)-1,
		(Cursor < MaxCursor) ? ACS_DARROW : ACS_VLINE);
}

static int
fixdate(char *buf)
{
	int	rc;
	int	mm, dd, yy;

	rc = sscanf(buf, "%d/%d/%d", &mm, &dd, &yy);
	if (rc == 3)
		sprintf(buf, "%02d/%02d/%02d", mm, dd, yy);

	return strlen(buf);
}

static TBLCOL	Col[] =
{
	{  0, 99999},
	{  0, 8 },	//Quiet Period Ends
	{ 10, 17 },	//Trading
	{ 19, 45},	//Company
	{ 47, 52 },	//Symbol (pseudo column created by parser)
	{ 54, 62 },	//Offering Price
	{ 64, 63 },	//Closing Price
	{ 64, 78 },
	{ 0, 99999 }
};
#define	NUMCOL	asizeof(Col)

static int	Nstock0;
static int	Paren;

static int
prewordhook(int *tblcolp, char *wbuf, int wlen)
{
	int	x, y;
	int	tblcol = *tblcolp;
	int	dolive = ValLivePoll > 1;

	if (tblcol == 6 && strcmp(wbuf, " Closing Price ") == 0)
		return 0;
	if (tblcol == 1 || tblcol == 2)
		wlen = fixdate(wbuf);

	if (Paren)
	{
		if (strcmp(wbuf, ")") == 0)
		{
			Paren = 0;
			return 0;
		}
		else if (dolive && (wlen-0) < SYMLEN)
		{
			x = getcurx(Subwin);
			y = getcury(Subwin);

			memcpy(Live[y].sym, wbuf, wlen);
			Live[y].sym[wlen] = 0;
			Live[y].x = getmaxx(Subwin) - 15;

			if (Nstock0)
				strcat(List0, " ");
			strcat(List0, Live[y].sym);
			strcpy(StockList0Name, "Quiet Period");
			++Nstock0;

			if (Nstock0 == 1)
			{
				wattrset(Subwin, A_BOLD);
				mvwprintw(Subwin,
					y-2, getmaxx(Subwin)-15,
					"   Live Quotes ");
				mvwprintw(Subwin,
					y-1, getmaxx(Subwin)-15,
					"  Price  Change");
				wattrset(Subwin, A_NORMAL);
				wmove(Subwin, y, x);
			}
		}
	}

	if (tblcol == 3 && strcmp(wbuf, " (") == 0)
	{
		Paren = 1;
		*tblcolp = ++tblcol;
		while (getcurx(Subwin) < Col[tblcol].sx)
			waddch(Subwin, ' ');
		return 0;
	}

	if (tblcol == 3 && strcmp(wbuf, "Company (Symbol) ") == 0)
	{
		waddstr(Subwin, "Company");
		*tblcolp = ++tblcol;
		while (getcurx(Subwin) < Col[tblcol].sx)
			waddch(Subwin, ' ');
		waddstr(Subwin, "Symbol");
		return 0;
	}

	if (tblcol == 1 && (strcmp(wbuf, "  Any") == 0
		|| strcmp(wbuf, " Companies") == 0
		|| strcmp(wbuf, "Printed") == 0) )
	{
		*tblcolp = tblcol = 0; x = 0;
		wmove(Subwin, getcury(Subwin), x);
	}
	else if (tblcol == 1 && strcmp(wbuf, " Quiet Period ") == 0)
	{
		strcpy(wbuf, "Quiet Ends");
		wattrset(Subwin, A_BOLD);
	}
	else if (tblcol == 1 && strcmp(wbuf, " End Date ") == 0)
		strcpy(wbuf, "");
	else if (tblcol == 1)
	{
		if (wlen < COMLEN)
		{
			strcat(List0Comments, "QP til ");
			strcat(List0Comments, wbuf);
		}
	}
	if (tblcol == 5 && strchr(wbuf, '$') && wlen < COMLEN)
	{
		strcat(List0Comments, wbuf);
		strcat(List0Comments, "\n");
	}

	return wlen;
}

static void
postwordhook(int *tblcolp, char *wbuf,int wlen)
{
	if (*tblcolp == 5 && strcmp(wbuf, " Offering ") == 0)
	{
		wattrset(Subwin, A_NORMAL);
	}
}

static void
get_quiet(void)
{
	int	y;
	FILE	*fp;
	char	buf[BUFSIZ];
	int	i;
	char	*url = get_rc_value(RcFile, "quiet_URL");
	static int	adjust = 1;

	// Paint empty frame to give user some feedback
	mvwcenter(Win, 4, "*** Please wait, fetching data ***");
	clearok(Win, TRUE);
	update_panels(); doupdate();
	mvwcenter(Subwin, 3, "*** No Data Available ***");

	sprintf(buf, "%s \"%s\"", SUCKURL, url);
	if (Debug)
		fprintf(stderr, "URL: <%s>\n", url);

	fp = popen(buf, "r");
	if (!fp)
	{
		mvwcenter(Win, 4, "   *** Can't access quiet period ***   ");
		touchwin(Win);
		return;
	}

	/*
	 * Eat lines until we see the table
	 */
	if (0)
	minihtml_skip_past_line(fp, "<P>Splits announced");

	/*
	 * Fix columns for narrow displays
	 */
	if (COLS < 80 && adjust)
	{
		Col[3].ex -= (80-COLS);
		for (i = 4; i <= 7; ++i)
		{
			Col[i].sx -= (80-COLS);
			Col[i].ex -= (80-COLS);
		}
		adjust = 0;
	}

	/*
	 * Parse HTML
	 */
	Nstock0 = 0;
	List0[0] = 0;
	List0Comments[0] = 0;
	Paren = 0;

	for (y = 0; y < PADLINES; ++y)
		Live[y].sym[0] = 0;

	minihtml_parse(Subwin, fp, Col, NUMCOL, MHP_EATBLANK,
			prewordhook, postwordhook, NULL, NULL);

	pclose(fp);

	Cursor = 0;
	NumLines = getcury(Subwin) + 1;
	MaxCursor = NumLines - (getmaxy(Win) - 2);
	if (MaxCursor < 0)
		MaxCursor = 0;

	display_more();

	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
	get_live_quotes();
}

void
quiet_popup(STREAMER sr)
{
	int	n;
	int	cols;

	// Clear alert, if any
	mvprintw(1, 7, "      ");

	n = LINES - 4 - 2 - NumStock - 12;
	if (n < 24)
		n = 24;
	Win = bestwin(n);
	if (!Win)
		error(1, "Can't create quiet window\n");

	cols = getmaxx(Win);

	wbkgd(Win, Reverse ? A_REVERSE : A_NORMAL);

	box(Win, 0, 0);
	mvwcenter(Win, 0, "Quiet Period Calendar");

	//
	// Turns out, this works best for most news articles and an 80
	// column xterm. We will clip columns 78 and 79, but there are
	// only blanks there in the news articles I've seen.  For smaller
	// displays, we are screwed anyway.
	//
	Subwin = newpad(PADLINES, cols - 2);
	if (!Subwin)
		error(1, "Can't create quiet pad\n");
	wbkgd(Subwin, Reverse ? A_REVERSE : A_NORMAL);

	Panel = new_panel(Win);

	//
	// Lots of stocks on this list, limit poll period
	//
	ValLivePoll = atoi(get_rc_value(RcFile, "live_quotes"));
	if (ValLivePoll && ValLivePoll < 10)
		ValLivePoll = 10;

	Sr = sr;
	get_quiet();
}

static void
popdown(void)
{
	hide_panel(Panel);
	update_panels();
	del_panel(Panel);
	delwin(Subwin);
	delwin(Win);
	Win = 0;
	Subwin = 0;
	Sr = NULL;
}

int
quiet_command(int c, STREAMER sr)
{
	MEVENT	m;

	switch (c)
	{
	case '\f':
		move(LINES-1, CursorX);
		wrefresh(curscr);
		return -1;
	case 'j':
	case KEY_DOWN:
		if (++Cursor > MaxCursor)
		{
			--Cursor;
			beep();
			break;
		}
		break;
	case 'k':
	case KEY_UP:
		if (--Cursor < 0)
		{
			++Cursor;
			beep();
			break;
		}
		break;
	case '-':
	case KEY_PPAGE:
		if (Cursor == 0)
		{
			beep();
			break;
		}
		Cursor -= getmaxy(Win) - 2 - 1;
		if (Cursor < 0)
			Cursor = 0;
		break;
	case '+':
	case ' ':
	case KEY_NPAGE:
		if (Cursor == MaxCursor)
		{
			beep();
			break;
		}
		Cursor += getmaxy(Win) - 2 - 1;
		if (Cursor > MaxCursor)
			Cursor = MaxCursor;
		break;
	case '0':
	case KEY_HOME:
		Cursor = 0;
		break;
	case '$':
	case KEY_END:
		Cursor = MaxCursor;
		break;

	case KEY_F(11):
		print_rect_troff(getbegy(Win), getbegx(Win),
				getmaxy(Win), getmaxx(Win),
				NULL, "screen.tr");
		break;
	case KEY_F(12):
	case CTRL('P'):
	case KEY_PRINT:
		print_window(Subwin, NumLines,
				get_rc_value(RcFile, "print_cmd"));
		break;

		// Change stocklist on main screen
	case '1': case '2': case '3': case '4': case '5':
	case '6': case '7': case '8': case '9':
		return 3;

	case KEY_MOUSE:
		if (getmouse(&m) != OK)
			break;

		// Ignore clicks in our window
		if (m.y >= getbegy(Win)
			&& m.y < getbegy(Win) + getmaxy(Win))
			break;

		// popdown and reprocess clicks in main window
		if (ungetmouse(&m) == OK)
			Ungetch = 1;
		popdown();
		return 2;

		// Quick switches to another popup
	case 'p':
	case 'e':
		popdown();
		return 1;

		// Regular exit
	case 033:
	case 'q':
	case 'x':
		popdown();
		return 2;
	default:
		beep();
		break;
	}

	display_more();
	copywin(Subwin, Win,
			Cursor, 0,
			1, 1,
			getmaxy(Win)-2, getmaxx(Win)-2,
			FALSE);
	move(LINES-1, CursorX);
	update_panels();
	doupdate();
	get_live_quotes();

	return (-1);
}
