#! /bin/sh
### BEGIN INIT INFO
# Provides:          lirc
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Starts LIRC daemon.
# Description:       LIRC is used to control different
#                    infrared receivers and transceivers.
### END INIT INFO

load_modules ()
{
	MODULES_MISSING=false

	log_daemon_msg "Loading LIRC modules"
	for mod in $*; do
		if [ $mod = "udev" ]; then
			log_end_msg 0
			log_success_msg "Restarted via udev, don't reload modules"
			break
		else
			modprobe $mod 2> /dev/null || MODULES_MISSING=true
		fi
	done
	log_end_msg $?

	if $MODULES_MISSING; then
		log_failure_msg "Unable to load LIRC kernel modules. Verify your"
		log_failure_msg "selected kernel modules in /etc/lirc/hardware.conf"
		START_LIRCMD=false
		START_LIRCD=false
	fi
}

build_args ()
{
	ARGS="$*"

	## Try to find an lirc device.
	if [ -z "$DEVICE" ]; then
		if [ -c $dev ]; then
			DEVICE="$dev"
			break
		fi
	fi

	if [ -n "$DEVICE" ] && [ "$DEVICE" != "none" ]; then
		ARGS="--device=$DEVICE $ARGS"
	fi

	if [ -n "$DRIVER" ] && [ "$DRIVER" != "none" ]; then
		ARGS="--driver=$DRIVER $ARGS"
	fi

	echo $ARGS
}

. /lib/lsb/init-functions

test -f /usr/sbin/lircd || exit 0
test -f /usr/sbin/lircmd || exit 0

START_LIRCMD=true
START_LIRCD=true
START_IREXEC=true


if [ -f /etc/lirc/hardware.conf ];then
	. /etc/lirc/hardware.conf
fi

if [ ! -f /etc/lirc/lircd.conf ] || grep -q "^#UNCONFIGURED" /etc/lirc/lircd.conf; then
	if [ "$1" = "start" ]; then
		log_success_msg "No valid /etc/lirc/lircd.conf has been found."
		log_success_msg "Remote control support has been disabled."
		log_success_msg "Reconfigure LIRC or manually replace /etc/lirc/lircd.conf to enable."
	fi

	START_LIRCD=false
	START_LIRCMD=false
	START_IREXEC=false
fi

if [ ! -f /etc/lirc/lircmd.conf ] || grep -q "^#UNCONFIGURED" /etc/lirc/lircmd.conf; then
	START_LIRCMD=false
fi

if [ ! -f /etc/lirc/lircrc ] || grep -q "^#UNCONFIGURED" /etc/lirc/lircrc; then
	START_IREXEC=false
fi

case "$1" in
	start)
		[ -d "/var/run/lirc" ] || mkdir -p "/var/run/lirc"
		if [ "$LOAD_MODULES" = "true" ] && [ "$START_LIRCD" = "true" ]; then
			load_modules $2 $MODULES
		fi

		if [ "$START_LIRCD" = "true" ]; then
			log_daemon_msg "Starting remote control daemon(s) : LIRC "
			LIRCD_ARGS=`build_args $LIRCD_ARGS`

			if [ ! -z "$LIRCD_ARGS" ]; then
				start-stop-daemon --start --quiet --oknodo --exec /usr/sbin/lircd -- $LIRCD_ARGS < /dev/null
				# retain compatibility with old clients
				ln -fs ../var/run/lirc/lircd /dev/lircd
				log_end_msg $?
			else
				log_end_msg 1
			fi
		fi

		if [ "$START_LIRCMD" = "true" ]; then
			log_daemon_msg "Starting remote control mouse daemon : LIRCMD "
			start-stop-daemon --start --quiet --oknodo --exec /usr/sbin/lircmd < /dev/null
			log_end_msg $?
		fi

		if [ "$START_IREXEC" = "true" ]; then
			log_daemon_msg "Starting execution daemon: irexec"
			start-stop-daemon --start --quiet --oknodo --exec /usr/bin/irexec -- -d /etc/lirc/lircrc < /dev/null
			log_end_msg $?
		fi
		;;
	stop)
		if [ "$START_IREXEC" = "true" ]; then
			log_daemon_msg "Stopping execution daemon: irexec"
			start-stop-daemon --stop --quiet --exec /usr/bin/irexec
			log_end_msg $?
		fi

		if [ "$START_LIRCMD" = "true" ]; then
			log_daemon_msg "Stopping remote control mouse daemon: LIRCMD"
			start-stop-daemon --stop --quiet --exec /usr/sbin/lircmd
			log_end_msg $?
		fi

		if [ "$START_LIRCD" = "true" ]; then
			log_daemon_msg "Stopping remote control daemon(s): LIRC"
			start-stop-daemon --stop --quiet --exec /usr/sbin/lircd
			log_end_msg $?
		fi
		;;
	reload|force-reload)
		if [ "$START_IREXEC" = "true" ]; then
			start-stop-daemon --stop --quiet --signal 1 --exec /usr/bin/irexec
		fi

		if [ "$START_LIRCD" = "true" ]; then
			start-stop-daemon --stop --quiet --signal 1 --exec /usr/sbin/lircd
		fi

		if [ "$START_LIRCMD" = "true" ]; then
			start-stop-daemon --stop --quiet --signal 1 --exec /usr/sbin/lircmd
		fi
		;;
	restart)
		$0 stop
		sleep 1
		#passes parameter $2 which is possibly our udev paramater
		$0 start $2
		;;
	*)
		echo "Usage: /etc/init.d/lircd {start|stop|reload|restart|force-reload}"
	exit 1
esac

exit 0
